/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import draylar.tiered.Tiered;
import draylar.tiered.api.AttributeTemplate;
import draylar.tiered.api.ModifierUtils;
import draylar.tiered.api.TierComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class CommandInit {
    private static final List<String> TIER_LIST = List.of("common", "uncommon", "rare", "epic", "legendary", "unique");

    public static void init() {
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tiered").requires(serverCommandSource -> serverCommandSource.method_9259(3))).then(class_2170.method_9247((String)"tier").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"common").executes(commandContext -> CommandInit.executeCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), 0)))).then(class_2170.method_9247((String)"uncommon").executes(commandContext -> CommandInit.executeCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), 1)))).then(class_2170.method_9247((String)"rare").executes(commandContext -> CommandInit.executeCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), 2)))).then(class_2170.method_9247((String)"epic").executes(commandContext -> CommandInit.executeCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), 3)))).then(class_2170.method_9247((String)"legendary").executes(commandContext -> CommandInit.executeCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), 4)))).then(class_2170.method_9247((String)"unique").executes(commandContext -> CommandInit.executeCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), 5)))))).then(class_2170.method_9247((String)"untier").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(commandContext -> CommandInit.executeCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), -1))))));
    }

    private static int executeCommand(class_2168 source, Collection<class_3222> targets, int tier) {
        for (class_3222 serverPlayerEntity : targets) {
            class_1799 itemStack = serverPlayerEntity.method_6047();
            if (itemStack.method_7960()) {
                source.method_9226(() -> class_2561.method_43469((String)"commands.tiered.failed", (Object[])new Object[]{serverPlayerEntity.method_5476()}), true);
                continue;
            }
            if (tier == -1) {
                if (itemStack.method_57824(Tiered.TIER) != null) {
                    ModifierUtils.removeItemStackAttribute(itemStack);
                    source.method_9226(() -> class_2561.method_43469((String)"commands.tiered.untier", (Object[])new Object[]{itemStack.method_7909().method_7864(itemStack).getString(), serverPlayerEntity.method_5476()}), true);
                    continue;
                }
                source.method_9226(() -> class_2561.method_43469((String)"commands.tiered.untier_failed", (Object[])new Object[]{itemStack.method_7909().method_7864(itemStack).getString(), serverPlayerEntity.method_5476()}), true);
                continue;
            }
            ArrayList potentialAttributes = new ArrayList();
            Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes().forEach((id, attribute) -> {
                if (attribute.isValid(class_7923.field_41178.method_10221((Object)itemStack.method_7909()))) {
                    potentialAttributes.add(class_2960.method_60654((String)attribute.getID()));
                }
            });
            if (potentialAttributes.size() <= 0) {
                source.method_9226(() -> class_2561.method_43469((String)"commands.tiered.tiering_failed", (Object[])new Object[]{itemStack.method_7909().method_7864(itemStack).getString(), serverPlayerEntity.method_5476()}), true);
                continue;
            }
            ArrayList<class_2960> potentialTier = new ArrayList<class_2960>();
            for (class_2960 potentialAttribute : potentialAttributes) {
                if (!potentialAttribute.method_12832().contains(TIER_LIST.get(tier)) || TIER_LIST.get(tier).equals("common") && potentialAttribute.method_12832().contains("uncommon")) continue;
                potentialTier.add(potentialAttribute);
            }
            if (potentialTier.size() <= 0) {
                source.method_9226(() -> class_2561.method_43469((String)"commands.tiered.tiering_failed", (Object[])new Object[]{itemStack.method_7909().method_7864(itemStack).getString(), serverPlayerEntity.method_5476()}), true);
                continue;
            }
            ModifierUtils.removeItemStackAttribute(itemStack);
            class_2960 attribute2 = (class_2960)potentialTier.get(serverPlayerEntity.method_37908().method_8409().method_43048(potentialTier.size()));
            if (attribute2 == null) continue;
            float durableFactor = -1.0f;
            int operation = 0;
            List<AttributeTemplate> attributeList = Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes().get(class_2960.method_60654((String)attribute2.toString())).getAttributes();
            for (AttributeTemplate attributeTemplate : attributeList) {
                if (!attributeTemplate.getAttributeTypeID().equals("tiered:generic.durable")) continue;
                durableFactor = (float)Math.round(attributeTemplate.getEntityAttributeModifier().comp_2449() * 100.0) / 100.0f;
                operation = attributeTemplate.getEntityAttributeModifier().comp_2450().method_56082();
                break;
            }
            itemStack.method_57379(Tiered.TIER, (Object)new TierComponent(attribute2.toString(), durableFactor, operation));
            source.method_9226(() -> class_2561.method_43469((String)"commands.tiered.tier", (Object[])new Object[]{itemStack.method_7909().method_7864(itemStack).getString(), serverPlayerEntity.method_5476()}), true);
        }
        return 1;
    }
}

