/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered;

import draylar.tiered.Tiered;
import draylar.tiered.api.AttributeTemplate;
import draylar.tiered.api.BorderTemplate;
import draylar.tiered.api.ModifierUtils;
import draylar.tiered.api.PotentialAttribute;
import draylar.tiered.data.TooltipBorderLoader;
import draylar.tiered.network.TieredClientPacket;
import draylar.tiered.reforge.ReforgeScreen;
import draylar.tiered.reforge.widget.AnvilTab;
import draylar.tiered.reforge.widget.ReforgeTab;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.slot.SlotType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.libz.api.InventoryTab;
import net.libz.registry.TabRegistry;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3929;
import net.minecraft.class_471;

@Environment(value=EnvType.CLIENT)
public class TieredClient
implements ClientModInitializer {
    public static final Map<class_2960, PotentialAttribute> CACHED_ATTRIBUTES = new HashMap<class_2960, PotentialAttribute>();
    public static final List<BorderTemplate> BORDER_TEMPLATES = new ArrayList<BorderTemplate>();
    private class_1799 lastStack = class_1799.field_8037;
    private int tickCounter = 0;
    private boolean debugMessage = false;
    private static final class_2960 ANVIL_TAB_ICON = class_2960.method_60654((String)"tiered:textures/gui/anvil_tab_icon.png");
    private static final class_2960 REFORGE_TAB_ICON = class_2960.method_60654((String)"tiered:textures/gui/reforge_tab_icon.png");
    public static final Queue<Runnable> TASK_QUEUE = new LinkedList<Runnable>();

    public void onInitializeClient() {
        class_3929.method_17542(Tiered.REFORGE_SCREEN_HANDLER_TYPE, ReforgeScreen::new);
        TieredClientPacket.init();
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new TooltipBorderLoader());
        TabRegistry.registerOtherTab((InventoryTab)new AnvilTab((class_2561)class_2561.method_43471((String)"container.repair"), ANVIL_TAB_ICON, 0, class_471.class), class_471.class);
        TabRegistry.registerOtherTab((InventoryTab)new ReforgeTab((class_2561)class_2561.method_43471((String)"screen.tiered.reforging_screen"), REFORGE_TAB_ICON, 1, ReforgeScreen.class), class_471.class);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (!TASK_QUEUE.isEmpty()) {
                TASK_QUEUE.poll().run();
            }
        });
        if (this.debugMessage) {
            ClientTickEvents.END_CLIENT_TICK.register(client -> {
                if (client.field_1724 == null) {
                    return;
                }
                ++this.tickCounter;
                if (this.tickCounter < 60) {
                    return;
                }
                this.tickCounter = 0;
                class_1799 currentStack = client.field_1724.method_6047();
                if (currentStack.method_7960()) {
                    return;
                }
                System.out.println("[Tiered Debug] [3s Interval] Currently held item: " + String.valueOf(currentStack.method_7909()));
                Collection validSlots = AccessoriesAPI.getValidSlotTypes((class_1309)client.field_1724, (class_1799)currentStack);
                if (!validSlots.isEmpty()) {
                    System.out.println("  \u2022 Valid accessory slots:");
                    for (SlotType slot : validSlots) {
                        System.out.println("    - " + slot.name());
                    }
                } else {
                    System.out.println("  \u2022 No valid accessory slots found.");
                }
                class_2960 tier = ModifierUtils.getAttributeId(currentStack);
                if (tier != null) {
                    System.out.println("  \u2022 Modifier ID: " + String.valueOf(tier));
                    PotentialAttribute attr = Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes().get(tier);
                    if (attr != null) {
                        for (AttributeTemplate template : attr.getAttributes()) {
                            if (template.getOptionalAccessoriesSlots() != null) {
                                System.out.println("    \u25e6 Template accessory slots:");
                                for (String string : template.getOptionalAccessoriesSlots()) {
                                    System.out.println("      - " + string);
                                }
                            }
                            if (template.getOptionalEquipmentSlots() == null) continue;
                            System.out.println("    \u25e6 Template equipment slots:");
                            for (String string : template.getOptionalEquipmentSlots()) {
                                System.out.println("      - " + string.method_5923());
                            }
                        }
                    } else {
                        System.out.println("  \u2022 No PotentialAttribute found for: " + String.valueOf(tier));
                    }
                } else {
                    System.out.println("  \u2022 No modifier (tier) found.");
                }
            });
        }
    }
}

