/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered;

import draylar.tiered.api.CustomEntityAttributes;
import draylar.tiered.api.ModifierUtils;
import draylar.tiered.api.TierComponent;
import draylar.tiered.api.TieredItemTags;
import draylar.tiered.command.CommandInit;
import draylar.tiered.config.ConfigInit;
import draylar.tiered.config.TieredConfig;
import draylar.tiered.data.AttributeDataLoader;
import draylar.tiered.data.ReforgeDataLoader;
import draylar.tiered.network.TieredServerPacket;
import draylar.tiered.reforge.ReforgeScreenHandler;
import draylar.tiered.registry.ModComponents;
import draylar.tiered.registry.ModItems;
import draylar.tiered.registry.ModLoot;
import java.util.function.UnaryOperator;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1819;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_5151;
import net.minecraft.class_7701;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Tiered
implements ModInitializer {
    public static final boolean isLevelZLoaded = FabricLoader.getInstance().isModLoaded("levelz");
    public static final AttributeDataLoader ATTRIBUTE_DATA_LOADER = new AttributeDataLoader();
    public static final ReforgeDataLoader REFORGE_DATA_LOADER = new ReforgeDataLoader();
    public static class_3917<ReforgeScreenHandler> REFORGE_SCREEN_HANDLER_TYPE;
    public static final class_9331<TierComponent> TIER;
    public static TieredConfig CONFIG;
    public static final Logger LOGGER;

    public void onInitialize() {
        ConfigInit.init();
        CONFIG = ConfigInit.CONFIG;
        ModComponents.init();
        TieredItemTags.init();
        ModItems.init();
        ModLoot.init();
        CustomEntityAttributes.init();
        CommandInit.init();
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)ATTRIBUTE_DATA_LOADER);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)REFORGE_DATA_LOADER);
        REFORGE_SCREEN_HANDLER_TYPE = (class_3917)class_2378.method_10226((class_2378)class_7923.field_41187, (String)"tiered:reforge", (Object)new class_3917((syncId, inventory) -> new ReforgeScreenHandler(syncId, inventory, class_3914.field_17304), class_7701.field_40182));
        TieredServerPacket.init();
        ServerPlayConnectionEvents.JOIN.register((network, packetSender, minecraftServer) -> {
            TieredServerPacket.writeS2CReforgeItemSyncPacket(network.method_32311());
            TieredServerPacket.writeS2CAttributePacket(network.method_32311());
            TieredServerPacket.writeS2CHealthPacket(network.method_32311());
        });
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, serverResourceManager, success) -> {
            if (success) {
                for (int i = 0; i < server.method_3760().method_14571().size(); ++i) {
                    ModifierUtils.updateItemStackComponent(((class_3222)server.method_3760().method_14571().get(i)).method_31548());
                }
                LOGGER.info("Finished reload on {}", (Object)Thread.currentThread());
            } else {
                LOGGER.error("Failed to reload on {}", (Object)Thread.currentThread());
            }
        });
        ServerPlayConnectionEvents.INIT.register((handler, server) -> ModifierUtils.updateItemStackComponent(handler.field_14140.method_31548()));
    }

    private static <T> class_9331<T> registerComponent(String id, UnaryOperator<class_9331.class_9332<T>> builderOperator) {
        return (class_9331)class_2378.method_10226((class_2378)class_7923.field_49658, (String)id, (Object)((class_9331.class_9332)builderOperator.apply(class_9331.method_57873())).method_57880());
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)"tiered", (String)path);
    }

    public static boolean isPreferredEquipmentSlot(class_1799 stack, class_1304 slot) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_5151) {
            class_5151 equipment = (class_5151)class_17922;
            return equipment.method_7685().equals((Object)slot);
        }
        if (stack.method_7909() instanceof class_1819 || stack.method_7909() instanceof class_1811 || stack.method_31573(TieredItemTags.MAIN_OFFHAND_ITEM)) {
            return slot == class_1304.field_6173 || slot == class_1304.field_6171;
        }
        return slot == class_1304.field_6173;
    }

    static {
        TIER = Tiered.registerComponent("tiered:tier", builder -> builder.method_57881(TierComponent.CODEC).method_57882(TierComponent.PACKET_CODEC));
        LOGGER = LogManager.getLogger();
    }
}

