/*
 * Decompiled with CFR 0.152.
 */
package absolutelyaya.formidulus.item.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record ChargeComponent(float charge, float maxCharge) {
    public static final Codec<ChargeComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("charge").forGetter(ChargeComponent::charge), (App)Codec.FLOAT.fieldOf("maxCharge").forGetter(ChargeComponent::maxCharge)).apply((Applicative)instance, ChargeComponent::new));
    public static final class_9139<ByteBuf, ChargeComponent> PACKET_CODEC = class_9139.method_56435((class_9139)class_9135.field_48552, ChargeComponent::charge, (class_9139)class_9135.field_48552, ChargeComponent::maxCharge, ChargeComponent::new);

    public boolean isCharged(float minPercent) {
        return this.getChargePercent() >= minPercent;
    }

    public ChargeComponent consumeCharge(float percent) {
        return new ChargeComponent(Math.max(this.charge - percent * this.maxCharge, 0.0f), this.maxCharge);
    }

    public Optional<ChargeComponent> tryConsumeCharge(float percent) {
        if (this.getChargePercent() < percent) {
            return Optional.empty();
        }
        return Optional.of(new ChargeComponent(Math.max(this.charge - percent * this.maxCharge, 0.0f), this.maxCharge));
    }

    public Optional<ChargeComponent> tryAddCharge(float percent) {
        if (this.getChargePercent() < percent) {
            return Optional.empty();
        }
        return Optional.of(new ChargeComponent(Math.min(this.charge + percent * this.maxCharge, this.maxCharge), this.maxCharge));
    }

    public float getChargePercent() {
        return this.charge / this.maxCharge;
    }
}

