/*
 * Decompiled with CFR 0.152.
 */
package absolutelyaya.formidulus.entities.boss;

import absolutelyaya.formidulus.advancement.CriteriaRegistry;
import absolutelyaya.formidulus.block.BossSpawnerBlockEntity;
import absolutelyaya.formidulus.datagen.Lang;
import absolutelyaya.formidulus.entities.BossEntity;
import absolutelyaya.formidulus.entities.boss.BossFightManager;
import absolutelyaya.formidulus.entities.boss.BossType;
import absolutelyaya.formidulus.network.BossMusicUpdatePayload;
import absolutelyaya.formidulus.sound.BossMusicEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_5575;
import net.minecraft.class_8710;

public abstract class BossFight {
    protected static final Map<String, BossMusicEntry> bossMusic = new HashMap<String, BossMusicEntry>();
    protected final class_1937 world;
    protected final BossType type;
    protected final class_2338 origin;
    protected final UUID fightID;
    protected final List<BossEntity> activeBossEntities = new ArrayList<BossEntity>();
    protected int phase;
    protected List<class_3222> participants = new ArrayList<class_3222>();
    protected Map<class_3222, Integer> outOfBoundsParticipants = new HashMap<class_3222, Integer>();
    protected int playerCheckIntervall = 20;
    protected int playerCheckRange = 40;
    int playerCheckTimer;
    int warmUp = 20;
    String lastMusicKey;
    boolean playerWin;
    boolean ended;

    protected BossFight(BossEntity entity, UUID id) {
        this.world = entity.method_37908();
        this.type = entity.getBossType();
        this.origin = entity.getOriginBlock();
        if (id == null) {
            this.participants = this.world.method_18023(class_5575.method_31795(class_3222.class), new class_238(this.origin).method_1014((double)this.playerCheckRange), this::isValidParticipant);
        }
        this.fightID = id == null ? UUID.randomUUID() : id;
        class_2586 class_25862 = this.world.method_8321(this.origin);
        if (class_25862 instanceof BossSpawnerBlockEntity) {
            BossSpawnerBlockEntity spawner = (BossSpawnerBlockEntity)class_25862;
            spawner.setBossFightId(this.fightID);
        }
        this.registerBossEntity(entity);
    }

    public void registerBossEntity(BossEntity boss) {
        this.activeBossEntities.add(boss);
    }

    public void tick() {
        if (this.ended) {
            return;
        }
        if (this.playerCheckTimer-- <= 0) {
            this.performParticipantCheck();
        }
        this.activeBossEntities.removeIf(i -> i.method_31481() || i.method_29504() || !i.isActive());
        String music = this.getCurMusicKey();
        if (music != null && !music.equals(this.lastMusicKey)) {
            this.onMusicChange(music);
            this.lastMusicKey = music;
        }
        if (this.warmUp-- > 0) {
            return;
        }
        if (this.shouldEnd()) {
            BossFightManager.INSTANCE.endFight(this);
        }
    }

    void performParticipantCheck() {
        List validParticipants = this.world.method_18023(class_5575.method_31795(class_3222.class), new class_238(this.origin).method_1014((double)this.playerCheckRange), this::isValidParticipant);
        ArrayList remove = new ArrayList();
        this.participants.forEach(p -> {
            if (!validParticipants.contains(p)) {
                int oob;
                if (!this.outOfBoundsParticipants.containsKey(p)) {
                    this.outOfBoundsParticipants.put((class_3222)p, 10);
                }
                if ((oob = this.outOfBoundsParticipants.get(p).intValue()) > 0) {
                    this.outOfBoundsParticipants.put((class_3222)p, oob - 1);
                    p.method_7353((class_2561)class_2561.method_43469((String)Lang.MESSAGE_OUT_OF_BOUNDS, (Object[])new Object[]{oob - 1}), true);
                }
            } else {
                this.outOfBoundsParticipants.remove(p);
            }
            if (this.outOfBoundsParticipants.getOrDefault(p, 9) <= 0 || !p.method_36608() || p.method_7337()) {
                remove.add(p);
            }
        });
        remove.forEach(this::leaveFight);
        validParticipants.forEach(p -> {
            if (!this.participants.contains(p) && !this.activeBossEntities.isEmpty()) {
                this.joinFight((class_3222)p);
            }
        });
        this.playerCheckTimer = this.playerCheckIntervall;
    }

    protected boolean shouldEnd() {
        return this.activeBossEntities.isEmpty() || !this.hasAnyValidParticipants();
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    public BossMusicEntry getCurMusicEntry() {
        return BossFight.getMusicEntry(this.getCurMusicKey());
    }

    public static BossMusicEntry getMusicEntry(String key) {
        return bossMusic.get(key);
    }

    protected String getCurMusicKey() {
        return "phase" + (this.phase + 1);
    }

    void onMusicChange(String key) {
        this.participants.forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_8710)new BossMusicUpdatePayload(this.type.id(), key)));
    }

    public void joinFight(class_3222 player) {
        if (this.participants.contains(player)) {
            return;
        }
        this.participants.add(player);
        ServerPlayNetworking.send((class_3222)player, (class_8710)new BossMusicUpdatePayload(this.type.id(), this.getCurMusicKey(), true));
    }

    public void leaveFight(class_3222 player) {
        if (this.participants.remove(player)) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new BossMusicUpdatePayload(this.type.id(), "cancel"));
        }
        this.outOfBoundsParticipants.remove(player);
    }

    public void onPlayerDeath(class_3222 player) {
        if (!this.participants.contains(player)) {
            return;
        }
        this.leaveFight(player);
        this.performParticipantCheck();
    }

    public List<class_3222> getAllParticipants() {
        return this.participants;
    }

    public boolean isValidParticipant(class_3222 player) {
        return player != null && player.method_36608() && !player.method_7337();
    }

    public boolean hasAnyValidParticipants() {
        for (class_3222 p : this.participants) {
            if (!this.isValidParticipant(p)) continue;
            return true;
        }
        return false;
    }

    public boolean isParticipant(class_3222 player) {
        return this.participants.contains(player);
    }

    public void setPlayerCheckRange(int range) {
        this.playerCheckRange = range;
    }

    public void setPlayerCheckIntervall(int intervall) {
        this.playerCheckIntervall = intervall;
    }

    public void interrupt(boolean removeRemainingBossEntities) {
        if (removeRemainingBossEntities) {
            this.activeBossEntities.forEach(BossEntity::forceReset);
        }
        this.onFightEnded();
    }

    public UUID getFightID() {
        return this.fightID;
    }

    public void markWon() {
        this.playerWin = true;
    }

    void onFightEnded() {
        if (this.ended) {
            return;
        }
        if (this.playerWin) {
            BossSpawnerBlockEntity spawner;
            this.participants.forEach(p -> CriteriaRegistry.BOSSFIGHT_WIN.trigger((class_3222)p, this.type.id()));
            class_2586 class_25862 = this.world.method_8321(this.origin);
            if (class_25862 instanceof BossSpawnerBlockEntity && this.fightID.equals((spawner = (BossSpawnerBlockEntity)class_25862).getFightId())) {
                spawner.onFightEnded();
            }
        } else {
            this.activeBossEntities.forEach(BossEntity::forceReset);
            while (!this.participants.isEmpty()) {
                this.leaveFight(this.participants.getFirst());
            }
        }
        this.ended = true;
    }

    public boolean hasEnded() {
        return this.ended;
    }
}

