/*
 * Decompiled with CFR 0.152.
 */
package absolutelyaya.formidulus.block;

import absolutelyaya.formidulus.Formidulus;
import absolutelyaya.formidulus.entities.BossEntity;
import absolutelyaya.formidulus.entities.boss.BossFightManager;
import absolutelyaya.formidulus.entities.boss.BossType;
import absolutelyaya.formidulus.registries.BlockEntityRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5575;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class BossSpawnerBlockEntity
extends class_2586 {
    final List<UUID> bossEntities = new ArrayList<UUID>();
    BossType bossType = BossType.DEER;
    UUID bossFightId;
    int respawnDelay = 12000;
    int fightCheckTimer;
    long lastFightEnded;
    boolean wasBossfightActive;

    public BossSpawnerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntityRegistry.BOSS_SPAWNER, pos, state);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public static <T extends class_2586> void tick(T t) {
        if (!(t instanceof BossSpawnerBlockEntity)) {
            return;
        }
        BossSpawnerBlockEntity spawner = (BossSpawnerBlockEntity)t;
        spawner.tick();
    }

    void tick() {
        class_1937 class_19372;
        if (this.fightCheckTimer-- > 0) {
            return;
        }
        boolean active = BossFightManager.INSTANCE.isActive(this.bossFightId);
        if (this.wasBossfightActive && !active) {
            this.onFightEnded();
        }
        if ((class_19372 = this.field_11863) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (!this.wasBossfightActive) {
                if (this.bossEntities.isEmpty() && (System.currentTimeMillis() > this.lastFightEnded + (long)this.respawnDelay * 50L || this.lastFightEnded == 0L)) {
                    if (this.isSpawnAreaValid()) {
                        this.trySpawnBoss();
                    } else {
                        this.lastFightEnded += 10000L;
                    }
                }
                this.bossEntities.removeIf(i -> {
                    class_1297 entity = serverWorld.method_14190(i);
                    return entity == null || !entity.method_5805() || entity.method_31481();
                });
                List list = serverWorld.method_18023((class_5575)this.bossType.bossEntities().getFirst(), new class_238(this.field_11867), i -> !i.isActive() && !this.bossEntities.contains(i.method_5667()));
                list.forEach(i -> {
                    i.method_31472();
                    this.lastFightEnded = 0L;
                    Formidulus.LOGGER.warn("discarded duplicate boss at {}", (Object)this.field_11867);
                });
            }
        }
        this.fightCheckTimer = (Integer)Formidulus.config.fightCheckInterval.getValue();
        this.wasBossfightActive = active;
    }

    void trySpawnBoss() {
        class_1937 class_19372;
        if (this.bossType == null) {
            this.bossType = BossType.DEER;
        }
        if ((class_19372 = this.field_11863) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            List bosses = serverWorld.method_18198(class_5575.method_31795(BossEntity.class), i -> true);
            for (BossEntity boss : bosses) {
                if (!boss.getBossType().equals(this.bossType) || !this.field_11867.equals((Object)boss.getOriginBlock())) continue;
                this.bossEntities.add(boss.method_5667());
                return;
            }
            BossEntity entity = (BossEntity)this.bossType.bossEntities().getFirst().method_5899(serverWorld, e -> {
                e.method_36456(0.0f);
                e.method_5847(0.0f);
                e.method_5636(0.0f);
                e.method_60949(e.method_19538(), 0.0f, 0.0f);
                if (e instanceof BossEntity) {
                    BossEntity boss = e;
                    boss.setOriginBlock(this.field_11867);
                    boss.afterBossReset();
                }
            }, this.field_11867, class_3730.field_16469, false, false);
            if (entity != null) {
                this.bossEntities.add(entity.method_5667());
            }
        }
    }

    public void addBossEntity(BossEntity entity) {
        if (this.bossType.bossEntities().contains(entity.method_5864())) {
            this.bossEntities.add(entity.method_5667());
        }
    }

    boolean isSpawnAreaValid() {
        if (this.field_11863 == null) {
            return false;
        }
        if (this.bossType.requiresSolidFloor() && !this.field_11863.method_8320(this.field_11867.method_10074()).method_26206((class_1922)this.field_11863, this.field_11867.method_10074(), class_2350.field_11036)) {
            return false;
        }
        return this.field_11863.method_18026(this.bossType.bossEntities().getFirst().method_58629((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260() + 0.5));
    }

    boolean isBossFightActive(UUID id) {
        return BossFightManager.INSTANCE.isActive(id);
    }

    public UUID getFightId() {
        return this.bossFightId;
    }

    public void setBossFightId(UUID bossFightId) {
        this.bossFightId = bossFightId;
        this.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 2);
        }
    }

    public BossType getBossType() {
        return this.bossType;
    }

    public void setBossType(BossType bossType) {
        this.bossType = bossType;
        this.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 2);
        }
    }

    public int getRespawnDelay() {
        return this.respawnDelay;
    }

    public void setRespawnDelay(int respawnDelay) {
        this.respawnDelay = respawnDelay;
        this.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 2);
        }
    }

    public void onFightEnded() {
        if (this.field_11863 != null) {
            this.lastFightEnded = System.currentTimeMillis();
            this.method_5431();
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 2);
        }
    }

    public void onBlockBroken() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        for (UUID id : this.bossEntities) {
            class_1297 class_12972 = serverWorld.method_14190(id);
            if (!(class_12972 instanceof BossEntity)) continue;
            BossEntity boss = (BossEntity)class_12972;
            boss.method_31472();
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10569("RespawnDelay", this.respawnDelay);
        nbt.method_10544("LastFightEnded", this.lastFightEnded);
        if (this.bossType != null) {
            nbt.method_10582("BossType", this.bossType.id().toString());
        }
        if (this.isBossFightActive(this.bossFightId)) {
            nbt.method_25927("BossFightId", this.bossFightId);
        }
        if (!this.bossEntities.isEmpty()) {
            class_2499 list = new class_2499();
            for (UUID id : this.bossEntities) {
                class_2487 compound = new class_2487();
                compound.method_25927("ID", id);
                list.add((Object)compound);
            }
            nbt.method_10566("LivingBossEntities", (class_2520)list);
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        if (nbt.method_10573("RespawnDelay", 3)) {
            this.respawnDelay = nbt.method_10550("RespawnDelay");
        }
        if (nbt.method_10573("LastFightEnded", 4)) {
            this.lastFightEnded = nbt.method_10537("LastFightEnded");
        }
        if (nbt.method_10573("BossType", 8)) {
            this.bossType = BossType.fromId(class_2960.method_12829((String)nbt.method_10558("BossType")));
        }
        if (nbt.method_25928("BossFightId")) {
            this.bossFightId = nbt.method_25926("BossFightId");
        }
        if (nbt.method_10573("LivingBossEntities", 9)) {
            class_2499 list = nbt.method_10554("LivingBossEntities", 10);
            list.forEach(i -> {
                class_2487 compound;
                if (i instanceof class_2487 && (compound = (class_2487)i).method_25928("ID")) {
                    this.bossEntities.add(compound.method_25926("ID"));
                }
            });
        }
    }
}

