/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.common.light;

import ca.spottedleaf.starlight.common.chunk.ExtendedChunk;
import ca.spottedleaf.starlight.common.light.BlockStarLightEngine;
import ca.spottedleaf.starlight.common.light.SWMRNibbleArray;
import ca.spottedleaf.starlight.common.light.SkyStarLightEngine;
import ca.spottedleaf.starlight.common.thread.GlobalExecutors;
import ca.spottedleaf.starlight.common.thread.SchedulingUtil;
import ca.spottedleaf.starlight.common.util.CoordinateUtils;
import ca.spottedleaf.starlight.common.util.WorldUtil;
import ca.spottedleaf.starlight.common.world.ExtendedWorld;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMaps;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2804;
import net.minecraft.class_2806;
import net.minecraft.class_2823;
import net.minecraft.class_3218;
import net.minecraft.class_3227;
import net.minecraft.class_3230;
import net.minecraft.class_3562;
import net.minecraft.class_3568;
import net.minecraft.class_4076;
import net.minecraft.class_5539;

public final class StarLightInterface {
    public static final class_3230<class_1923> CHUNK_WORK_TICKET = class_3230.method_14291((String)"starlight_chunk_work_ticket", (p1, p2) -> Long.compare(p1.method_8324(), p2.method_8324()));
    protected final class_1937 world;
    protected final class_2823 lightAccess;
    protected final ArrayDeque<SkyStarLightEngine> cachedSkyPropagators;
    protected final ArrayDeque<BlockStarLightEngine> cachedBlockPropagators;
    protected final LightQueue lightQueue = new LightQueue(this);
    protected final class_3562 skyReader;
    protected final class_3562 blockReader;
    protected final boolean isClientSide;
    protected final int minSection;
    protected final int maxSection;
    protected final int minLightSection;
    protected final int maxLightSection;
    public final class_3568 lightEngine;
    private final boolean hasBlockLight;
    private final boolean hasSkyLight;
    private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger(0);
    private static final CompletableFuture<Void> COMPLETED_FUTURE = CompletableFuture.completedFuture(null);
    private final int instanceId = INSTANCE_COUNTER.getAndIncrement();
    private final Long2ReferenceMap<CompletableFuture<Void>> chunkFutures = Long2ReferenceMaps.synchronize((Long2ReferenceMap)new Long2ReferenceOpenHashMap());

    public StarLightInterface(class_2823 lightAccess, boolean hasSkyLight, boolean hasBlockLight, class_3568 lightEngine) {
        this.lightAccess = lightAccess;
        this.world = lightAccess == null ? null : (class_1937)lightAccess.method_16399();
        this.cachedSkyPropagators = hasSkyLight && lightAccess != null ? new ArrayDeque() : null;
        this.cachedBlockPropagators = hasBlockLight && lightAccess != null ? new ArrayDeque() : null;
        boolean bl = this.isClientSide = !(this.world instanceof class_3218);
        if (this.world == null) {
            this.minSection = -4;
            this.maxSection = 19;
            this.minLightSection = -5;
            this.maxLightSection = 20;
        } else {
            this.minSection = WorldUtil.getMinSection((class_5539)this.world);
            this.maxSection = WorldUtil.getMaxSection((class_5539)this.world);
            this.minLightSection = WorldUtil.getMinLightSection((class_5539)this.world);
            this.maxLightSection = WorldUtil.getMaxLightSection((class_5539)this.world);
        }
        this.lightEngine = lightEngine;
        this.hasBlockLight = hasBlockLight;
        this.hasSkyLight = hasSkyLight;
        this.skyReader = !hasSkyLight ? class_3562.class_3563.field_15812 : new class_3562(){

            public void method_15513(class_2338 blockPos) {
                StarLightInterface.this.lightEngine.method_15513(blockPos.method_10062());
            }

            public void method_51471(class_1923 chunkPos) {
                throw new UnsupportedOperationException();
            }

            public boolean method_15518() {
                return StarLightInterface.this.hasUpdates();
            }

            public int method_15516() {
                throw new UnsupportedOperationException();
            }

            public void method_15512(class_1923 chunkPos, boolean bl) {
                throw new UnsupportedOperationException();
            }

            public class_2804 method_15544(class_4076 pos) {
                class_2791 chunk = StarLightInterface.this.getAnyChunkNow(pos.method_10263(), pos.method_10260());
                if (chunk == null || !StarLightInterface.this.isClientSide && !chunk.method_12038() || !chunk.method_51526().method_12165(class_2806.field_12805)) {
                    return null;
                }
                int sectionY = pos.method_10264();
                if (sectionY > StarLightInterface.this.maxLightSection || sectionY < StarLightInterface.this.minLightSection) {
                    return null;
                }
                if (((ExtendedChunk)chunk).getSkyEmptinessMap() == null) {
                    return null;
                }
                return ((ExtendedChunk)chunk).getSkyNibbles()[sectionY - StarLightInterface.this.minLightSection].toVanillaNibble();
            }

            public int method_15543(class_2338 blockPos) {
                return StarLightInterface.this.getSkyLightValue(blockPos, StarLightInterface.this.getAnyChunkNow(blockPos.method_10263() >> 4, blockPos.method_10260() >> 4));
            }

            public void method_15551(class_4076 pos, boolean notReady) {
                StarLightInterface.this.sectionChange(pos, notReady);
            }
        };
        this.blockReader = !hasBlockLight ? class_3562.class_3563.field_15812 : new class_3562(){

            public void method_15513(class_2338 blockPos) {
                StarLightInterface.this.lightEngine.method_15513(blockPos.method_10062());
            }

            public void method_51471(class_1923 chunkPos) {
                throw new UnsupportedOperationException();
            }

            public boolean method_15518() {
                return StarLightInterface.this.hasUpdates();
            }

            public int method_15516() {
                throw new UnsupportedOperationException();
            }

            public void method_15512(class_1923 chunkPos, boolean bl) {
                throw new UnsupportedOperationException();
            }

            public class_2804 method_15544(class_4076 pos) {
                class_2791 chunk = StarLightInterface.this.getAnyChunkNow(pos.method_10263(), pos.method_10260());
                if (chunk == null || pos.method_10264() < StarLightInterface.this.minLightSection || pos.method_10264() > StarLightInterface.this.maxLightSection) {
                    return null;
                }
                return ((ExtendedChunk)chunk).getBlockNibbles()[pos.method_10264() - StarLightInterface.this.minLightSection].toVanillaNibble();
            }

            public int method_15543(class_2338 blockPos) {
                return StarLightInterface.this.getBlockLightValue(blockPos, StarLightInterface.this.getAnyChunkNow(blockPos.method_10263() >> 4, blockPos.method_10260() >> 4));
            }

            public void method_15551(class_4076 pos, boolean notReady) {
                StarLightInterface.this.sectionChange(pos, notReady);
            }
        };
    }

    public boolean hasSkyLight() {
        return this.hasSkyLight;
    }

    public boolean hasBlockLight() {
        return this.hasBlockLight;
    }

    public int getSkyLightValue(class_2338 blockPos, class_2791 chunk) {
        int currY;
        SWMRNibbleArray[] nibbles;
        SWMRNibbleArray immediate;
        if (!this.hasSkyLight) {
            return 0;
        }
        int x = blockPos.method_10263();
        int y = blockPos.method_10264();
        int z = blockPos.method_10260();
        int minSection = this.minSection;
        int maxSection = this.maxSection;
        int minLightSection = this.minLightSection;
        int maxLightSection = this.maxLightSection;
        if (chunk == null || !this.isClientSide && !chunk.method_12038() || !chunk.method_12009().method_12165(class_2806.field_12805)) {
            return 15;
        }
        int sectionY = y >> 4;
        if (sectionY > maxLightSection) {
            return 15;
        }
        if (sectionY < minLightSection) {
            sectionY = minLightSection;
            y = sectionY << 4;
        }
        if (!(immediate = (nibbles = ((ExtendedChunk)chunk).getSkyNibbles())[sectionY - minLightSection]).isNullNibbleVisible()) {
            return immediate.getVisible(x, y, z);
        }
        boolean[] emptinessMap = ((ExtendedChunk)chunk).getSkyEmptinessMap();
        if (emptinessMap == null) {
            return 15;
        }
        int lowestY = minLightSection - 1;
        for (currY = maxSection; currY >= minSection; --currY) {
            if (emptinessMap[currY - minSection]) continue;
            lowestY = currY;
            break;
        }
        if (sectionY > lowestY) {
            return 15;
        }
        for (currY = sectionY + 1; currY <= maxLightSection; ++currY) {
            SWMRNibbleArray nibble = nibbles[currY - minLightSection];
            if (nibble.isNullNibbleVisible()) continue;
            return nibble.getVisible(x, 0, z);
        }
        return 15;
    }

    public int getBlockLightValue(class_2338 blockPos, class_2791 chunk) {
        if (!this.hasBlockLight) {
            return 0;
        }
        int y = blockPos.method_10264();
        int cy = y >> 4;
        int minLightSection = this.minLightSection;
        int maxLightSection = this.maxLightSection;
        if (cy < minLightSection || cy > maxLightSection) {
            return 0;
        }
        if (chunk == null) {
            return 0;
        }
        SWMRNibbleArray nibble = ((ExtendedChunk)chunk).getBlockNibbles()[cy - minLightSection];
        return nibble.getVisible(blockPos.method_10263(), y, blockPos.method_10260());
    }

    public int getRawBrightness(class_2338 pos, int ambientDarkness) {
        class_2791 chunk = this.getAnyChunkNow(pos.method_10263() >> 4, pos.method_10260() >> 4);
        int sky = this.getSkyLightValue(pos, chunk) - ambientDarkness;
        if (sky == 15) {
            return 15;
        }
        int block = this.getBlockLightValue(pos, chunk);
        return Math.max(sky, block);
    }

    public class_3562 getSkyReader() {
        return this.skyReader;
    }

    public class_3562 getBlockReader() {
        return this.blockReader;
    }

    public boolean isClientSide() {
        return this.isClientSide;
    }

    public class_2791 getAnyChunkNow(int chunkX, int chunkZ) {
        if (this.world == null) {
            return null;
        }
        return ((ExtendedWorld)this.world).getAnyChunkImmediately(chunkX, chunkZ);
    }

    public boolean hasUpdates() {
        return !this.lightQueue.isEmpty();
    }

    public class_1937 getWorld() {
        return this.world;
    }

    public class_2823 getLightAccess() {
        return this.lightAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SkyStarLightEngine getSkyLightEngine() {
        SkyStarLightEngine ret;
        if (this.cachedSkyPropagators == null) {
            return null;
        }
        ArrayDeque<SkyStarLightEngine> arrayDeque = this.cachedSkyPropagators;
        synchronized (arrayDeque) {
            ret = this.cachedSkyPropagators.pollFirst();
        }
        if (ret == null) {
            return new SkyStarLightEngine(this.world);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void releaseSkyLightEngine(SkyStarLightEngine engine) {
        if (this.cachedSkyPropagators == null) {
            return;
        }
        ArrayDeque<SkyStarLightEngine> arrayDeque = this.cachedSkyPropagators;
        synchronized (arrayDeque) {
            this.cachedSkyPropagators.addFirst(engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final BlockStarLightEngine getBlockLightEngine() {
        BlockStarLightEngine ret;
        if (this.cachedBlockPropagators == null) {
            return null;
        }
        ArrayDeque<BlockStarLightEngine> arrayDeque = this.cachedBlockPropagators;
        synchronized (arrayDeque) {
            ret = this.cachedBlockPropagators.pollFirst();
        }
        if (ret == null) {
            return new BlockStarLightEngine(this.world);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void releaseBlockLightEngine(BlockStarLightEngine engine) {
        if (this.cachedBlockPropagators == null) {
            return;
        }
        ArrayDeque<BlockStarLightEngine> arrayDeque = this.cachedBlockPropagators;
        synchronized (arrayDeque) {
            this.cachedBlockPropagators.addFirst(engine);
        }
    }

    public LightQueue.ChunkTasks blockChange(class_2338 pos) {
        if (this.world == null || pos.method_10264() < WorldUtil.getMinBlockY((class_5539)this.world) || pos.method_10264() > WorldUtil.getMaxBlockY((class_5539)this.world)) {
            return null;
        }
        return this.lightQueue.queueBlockChange(pos);
    }

    public LightQueue.ChunkTasks sectionChange(class_4076 pos, boolean newEmptyValue) {
        if (this.world == null) {
            return null;
        }
        return this.lightQueue.queueSectionChange(pos, newEmptyValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceLoadInChunk(class_2791 chunk, Boolean[] emptySections) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.forceHandleEmptySectionChanges(this.lightAccess, chunk, emptySections);
            }
            if (blockEngine != null) {
                blockEngine.forceHandleEmptySectionChanges(this.lightAccess, chunk, emptySections);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInChunk(int chunkX, int chunkZ, Boolean[] emptySections) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.handleEmptySectionChanges(this.lightAccess, chunkX, chunkZ, emptySections);
            }
            if (blockEngine != null) {
                blockEngine.handleEmptySectionChanges(this.lightAccess, chunkX, chunkZ, emptySections);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lightChunk(class_2791 chunk, Boolean[] emptySections) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.light(this.lightAccess, chunk, emptySections);
            }
            if (blockEngine != null) {
                blockEngine.light(this.lightAccess, chunk, emptySections);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relightChunks(Set<class_1923> chunks, Consumer<class_1923> chunkLightCallback, IntConsumer onComplete) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.relightChunks(this.lightAccess, chunks, blockEngine == null ? chunkLightCallback : null, blockEngine == null ? onComplete : null);
            }
            if (blockEngine != null) {
                blockEngine.relightChunks(this.lightAccess, chunks, chunkLightCallback, onComplete);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    public void checkChunkEdges(int chunkX, int chunkZ) {
        this.checkSkyEdges(chunkX, chunkZ);
        this.checkBlockEdges(chunkX, chunkZ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSkyEdges(int chunkX, int chunkZ) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkBlockEdges(int chunkX, int chunkZ) {
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (blockEngine != null) {
                blockEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ);
            }
        }
        finally {
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSkyEdges(int chunkX, int chunkZ, ShortCollection sections) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ, sections);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkBlockEdges(int chunkX, int chunkZ, ShortCollection sections) {
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (blockEngine != null) {
                blockEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ, sections);
            }
        }
        finally {
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    public void scheduleChunkLight(class_1923 pos, Runnable run) {
        this.lightQueue.queueChunkLighting(pos, run);
    }

    public void removeChunkTasks(class_1923 pos) {
        this.lightQueue.removeChunk(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagateChanges() {
        class_3568 class_35682;
        if (this.lightQueue.isEmpty()) {
            return;
        }
        if (GlobalExecutors.ENABLED && (class_35682 = this.lightEngine) instanceof class_3227) {
            class_3227 threadedLevelLightEngine = (class_3227)class_35682;
            this.schedulePropagation0(threadedLevelLightEngine);
            return;
        }
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            LightQueue.ChunkTasks task;
            while ((task = this.lightQueue.removeFirstTask()) != null) {
                this.handleUpdateInternal(task, skyEngine, blockEngine);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulePropagation0(class_3227 threadedLevelLightEngine) {
        LightQueue lightQueue = this.lightQueue;
        synchronized (lightQueue) {
            ObjectBidirectionalIterator iterator = this.lightQueue.chunkTasks.long2ObjectEntrySet().fastIterator();
            while (iterator.hasNext()) {
                Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
                long pos = entry.getLongKey();
                if (!((CompletableFuture)this.chunkFutures.getOrDefault(pos, COMPLETED_FUTURE)).isDone()) continue;
                CompletableFuture future = new CompletableFuture();
                SchedulingUtil.scheduleTask(this.instanceId, () -> {
                    try {
                        LightQueue.ChunkTasks tasks;
                        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
                        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
                        LightQueue lightQueue = this.lightQueue;
                        synchronized (lightQueue) {
                            tasks = (LightQueue.ChunkTasks)this.lightQueue.chunkTasks.remove(pos);
                        }
                        if (tasks != null) {
                            try {
                                this.handleUpdateInternal(tasks, skyEngine, blockEngine);
                            }
                            finally {
                                this.releaseSkyLightEngine(skyEngine);
                                this.releaseBlockLightEngine(blockEngine);
                            }
                            threadedLevelLightEngine.method_17303();
                        }
                        future.complete(null);
                    }
                    catch (Throwable t) {
                        future.completeExceptionally(t);
                        t.printStackTrace();
                    }
                }, CoordinateUtils.getChunkX(pos), CoordinateUtils.getChunkZ(pos), 2);
                this.chunkFutures.put(pos, future);
            }
            this.lightQueue.queueDirty = false;
        }
    }

    public boolean isQueueDirty() {
        return this.lightQueue.queueDirty;
    }

    private void handleUpdateInternal(LightQueue.ChunkTasks task, SkyStarLightEngine skyEngine, BlockStarLightEngine blockEngine) {
        if (task.lightTasks != null) {
            for (Runnable run : task.lightTasks) {
                run.run();
            }
        }
        long coordinate = task.chunkCoordinate;
        int chunkX = CoordinateUtils.getChunkX(coordinate);
        int chunkZ = CoordinateUtils.getChunkZ(coordinate);
        Set<class_2338> positions = task.changedPositions;
        Boolean[] sectionChanges = task.changedSectionSet;
        if (!(skyEngine == null || positions.isEmpty() && sectionChanges == null)) {
            skyEngine.blocksChangedInChunk(this.lightAccess, chunkX, chunkZ, positions, sectionChanges);
        }
        if (!(blockEngine == null || positions.isEmpty() && sectionChanges == null)) {
            blockEngine.blocksChangedInChunk(this.lightAccess, chunkX, chunkZ, positions, sectionChanges);
        }
        if (skyEngine != null && task.queuedEdgeChecksSky != null) {
            skyEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ, (ShortCollection)task.queuedEdgeChecksSky);
        }
        if (blockEngine != null && task.queuedEdgeChecksBlock != null) {
            blockEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ, (ShortCollection)task.queuedEdgeChecksBlock);
        }
        task.onComplete.complete(null);
    }

    public static final class LightQueue {
        protected final Long2ObjectLinkedOpenHashMap<ChunkTasks> chunkTasks = new Long2ObjectLinkedOpenHashMap();
        protected final StarLightInterface manager;
        protected volatile boolean queueDirty = false;

        public LightQueue(StarLightInterface manager) {
            this.manager = manager;
        }

        public synchronized boolean isEmpty() {
            return this.chunkTasks.isEmpty();
        }

        public synchronized ChunkTasks queueBlockChange(class_2338 pos) {
            ChunkTasks tasks = (ChunkTasks)this.chunkTasks.computeIfAbsent(CoordinateUtils.getChunkKey(pos), ChunkTasks::new);
            tasks.changedPositions.add(pos.method_10062());
            this.queueDirty = true;
            return tasks;
        }

        public synchronized ChunkTasks queueSectionChange(class_4076 pos, boolean newEmptyValue) {
            ChunkTasks tasks = (ChunkTasks)this.chunkTasks.computeIfAbsent(CoordinateUtils.getChunkKey(pos), ChunkTasks::new);
            if (tasks.changedSectionSet == null) {
                tasks.changedSectionSet = new Boolean[this.manager.maxSection - this.manager.minSection + 1];
            }
            tasks.changedSectionSet[pos.method_10264() - this.manager.minSection] = newEmptyValue;
            this.queueDirty = true;
            return tasks;
        }

        public synchronized ChunkTasks queueChunkLighting(class_1923 pos, Runnable lightTask) {
            ChunkTasks tasks = (ChunkTasks)this.chunkTasks.computeIfAbsent(CoordinateUtils.getChunkKey(pos), ChunkTasks::new);
            if (tasks.lightTasks == null) {
                tasks.lightTasks = new ArrayList<Runnable>();
            }
            tasks.lightTasks.add(lightTask);
            this.queueDirty = true;
            return tasks;
        }

        public synchronized ChunkTasks queueChunkSkylightEdgeCheck(class_4076 pos, ShortCollection sections) {
            ChunkTasks tasks = (ChunkTasks)this.chunkTasks.computeIfAbsent(CoordinateUtils.getChunkKey(pos), ChunkTasks::new);
            ShortOpenHashSet queuedEdges = tasks.queuedEdgeChecksSky;
            if (queuedEdges == null) {
                queuedEdges = tasks.queuedEdgeChecksSky = new ShortOpenHashSet();
            }
            queuedEdges.addAll(sections);
            this.queueDirty = true;
            return tasks;
        }

        public synchronized ChunkTasks queueChunkBlocklightEdgeCheck(class_4076 pos, ShortCollection sections) {
            ChunkTasks tasks = (ChunkTasks)this.chunkTasks.computeIfAbsent(CoordinateUtils.getChunkKey(pos), ChunkTasks::new);
            ShortOpenHashSet queuedEdges = tasks.queuedEdgeChecksBlock;
            if (queuedEdges == null) {
                queuedEdges = tasks.queuedEdgeChecksBlock = new ShortOpenHashSet();
            }
            queuedEdges.addAll(sections);
            this.queueDirty = true;
            return tasks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChunk(class_1923 pos) {
            ChunkTasks tasks;
            LightQueue lightQueue = this;
            synchronized (lightQueue) {
                tasks = (ChunkTasks)this.chunkTasks.remove(CoordinateUtils.getChunkKey(pos));
            }
            if (tasks != null) {
                tasks.onComplete.complete(null);
            }
            this.queueDirty = true;
        }

        public synchronized ChunkTasks removeFirstTask() {
            if (this.chunkTasks.isEmpty()) {
                return null;
            }
            return (ChunkTasks)this.chunkTasks.removeFirst();
        }

        public static final class ChunkTasks {
            public final Set<class_2338> changedPositions = new ObjectOpenHashSet();
            public Boolean[] changedSectionSet;
            public ShortOpenHashSet queuedEdgeChecksSky;
            public ShortOpenHashSet queuedEdgeChecksBlock;
            public List<Runnable> lightTasks;
            public boolean isTicketAdded = false;
            public final CompletableFuture<Void> onComplete = new CompletableFuture();
            public final long chunkCoordinate;

            public ChunkTasks(long chunkCoordinate) {
                this.chunkCoordinate = chunkCoordinate;
            }
        }
    }
}

