/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.paxi.mixin;

import com.google.common.collect.ImmutableList;
import com.yungnickyoung.minecraft.paxi.PaxiCommon;
import com.yungnickyoung.minecraft.paxi.PaxiRepositorySource;
import com.yungnickyoung.minecraft.paxi.client.ClientMixinUtil;
import com.yungnickyoung.minecraft.paxi.util.IPaxiSourceProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackCreator;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_3283;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3283.class}, priority=2000)
public abstract class MixinPackRepositoryFabric {
    @Final
    @Shadow
    private Set<class_3285> field_14227;

    @Shadow
    private Stream<class_3288> method_29209(Collection<String> names) {
        throw new AssertionError();
    }

    @Inject(at={@At(value="RETURN")}, method={"discoverAvailable"}, cancellable=true)
    private void paxi_removeDuplicatesInAvailableList(CallbackInfoReturnable<Map<String, class_3288>> cir) {
        Optional<class_3285> repositorySource = this.getPaxiRepositorySource();
        if (repositorySource.isEmpty()) {
            PaxiCommon.LOGGER.error("Unable to find Paxi repository source when removing duplicates from available packs. You may see duplicate pack entries in your list of available packs on the Resource Packs screen.");
            return;
        }
        PaxiRepositorySource paxiRepositorySource = (PaxiRepositorySource)repositorySource.get();
        List<String> orderedPaxiPacks = paxiRepositorySource.orderedPaxiPacks;
        TreeMap availablePacks = new TreeMap((Map)cir.getReturnValue());
        HashSet<String> keysToRemove = new HashSet<String>();
        block0: for (String vanillaPackId : availablePacks.keySet()) {
            for (String paxiPackId : orderedPaxiPacks) {
                if (!vanillaPackId.equals("file/" + paxiPackId)) continue;
                keysToRemove.add(vanillaPackId);
                continue block0;
            }
        }
        keysToRemove.forEach(availablePacks::remove);
        cir.setReturnValue(availablePacks);
    }

    @Inject(at={@At(value="RETURN")}, method={"rebuildSelected"}, cancellable=true)
    private void paxi_buildEnabledProfilesFabric(Collection<String> enabledNames, CallbackInfoReturnable<List<class_3288>> cir) {
        List sortedEnabledPacks = (List)((List)cir.getReturnValue()).stream().collect(class_156.method_58579());
        Optional<class_3285> paxiRepositorySource = this.getPaxiRepositorySource();
        ArrayList<class_3288> unorderedPaxiPacks = new ArrayList<class_3288>();
        ArrayList<class_3288> orderedPaxiPacks = new ArrayList<class_3288>();
        if (paxiRepositorySource.isPresent() && ((PaxiRepositorySource)paxiRepositorySource.get()).hasPacks()) {
            unorderedPaxiPacks.addAll(this.method_29209(((PaxiRepositorySource)paxiRepositorySource.get()).unorderedPaxiPacks).toList());
            orderedPaxiPacks.addAll(this.method_29209(((PaxiRepositorySource)paxiRepositorySource.get()).orderedPaxiPacks).toList());
            sortedEnabledPacks.removeAll(orderedPaxiPacks);
        }
        Stream.concat(unorderedPaxiPacks.stream(), orderedPaxiPacks.stream()).forEach(pack -> {
            if (pack.method_14464() && !sortedEnabledPacks.contains(pack)) {
                pack.method_14466().method_14468(sortedEnabledPacks, pack, class_3288::method_56934, false);
            }
        });
        cir.setReturnValue((Object)ImmutableList.copyOf((Collection)sortedEnabledPacks));
    }

    @Unique
    private Optional<class_3285> getPaxiRepositorySource() {
        boolean isClient = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
        Optional<Object> paxiRepositorySource = Optional.empty();
        Optional<ModResourcePackCreator> moddedPackRepositorySource = this.field_14227.stream().filter(provider -> provider instanceof ModResourcePackCreator).findFirst().map(repositorySource -> (ModResourcePackCreator)repositorySource);
        if (moddedPackRepositorySource.isPresent()) {
            paxiRepositorySource = Optional.of(((IPaxiSourceProvider)moddedPackRepositorySource.get()).getPaxiSource());
        }
        if (paxiRepositorySource.isEmpty() && isClient) {
            paxiRepositorySource = ClientMixinUtil.getClientRepositorySource(this.field_14227);
        }
        return paxiRepositorySource;
    }
}

