/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.network;

import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.BossTypeManager;
import com.brutalbosses.entity.capability.BossCapEntity;
import com.brutalbosses.entity.capability.BossCapability;
import com.brutalbosses.event.ClientEventHandler;
import com.brutalbosses.network.BossCapMessage;
import com.brutalbosses.network.BossOverlayMessage;
import com.brutalbosses.network.BossTypeSyncMessage;
import com.brutalbosses.network.VanillaParticleMessage;
import com.google.common.collect.ImmutableMap;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2520;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class ClientMessageHandler {
    private static final float WIDTH = 0.8f;
    private static final float HEIGHT = 2.0f;

    public static void handle(VanillaParticleMessage particleMessage, class_310 client) {
        class_638 world = class_310.method_1551().field_1687;
        ClientMessageHandler.spawnParticles(particleMessage.type, (class_1937)world, particleMessage.x, particleMessage.y, particleMessage.z);
    }

    private static void spawnParticles(class_2400 particleType, class_1937 world, double x, double y, double z) {
        Random rand = new Random();
        for (int i = 0; i < 5; ++i) {
            double d0 = rand.nextGaussian() * 0.02;
            double d1 = rand.nextGaussian() * 0.02;
            double d2 = rand.nextGaussian() * 0.02;
            world.method_8406((class_2394)new class_2392(class_2398.field_11218, new class_1799((class_1935)class_1802.field_8606)), x + (double)(rand.nextFloat() * 0.8f * 2.0f) - (double)0.8f, y + 1.0 + (double)(rand.nextFloat() * 2.0f), z + (double)(rand.nextFloat() * 0.8f * 2.0f) - (double)0.8f, d0, d1, d2);
        }
    }

    public static void handle(BossCapMessage bossCapMessage, class_310 client) {
        class_1297 entity = client.field_1724.method_37908().method_8469(bossCapMessage.entityID);
        if (entity instanceof BossCapEntity) {
            ((BossCapEntity)entity).setBossCap(new BossCapability(entity));
            ((BossCapEntity)entity).getBossCap().deserializeNBT((class_2520)bossCapMessage.nbt);
        }
    }

    public static void handle(BossOverlayMessage message, class_310 client) {
        class_1297 entity = client.field_1724.method_37908().method_8469(message.entityID);
        if (entity != null) {
            ClientEventHandler.checkEntity(entity);
        }
    }

    public static void handle(BossTypeSyncMessage message, class_310 client) {
        ImmutableMap.Builder bossTypesImm = ImmutableMap.builder();
        for (BossType type : message.bossTypes) {
            bossTypesImm.put((Object)type.getID(), (Object)type);
        }
        BossTypeManager.instance.bosses = bossTypesImm.build();
    }
}

