/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.event;

import com.brutalbosses.entity.capability.BossCapEntity;
import com.brutalbosses.entity.capability.BossCapability;
import com.brutalbosses.event.ClientBossEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_3966;
import net.minecraft.class_746;

public class ClientEventHandler {
    private static Map<class_1297, ClientBossUI> bossInfoMap = new HashMap<class_1297, ClientBossUI>();

    public static void onWorldUnload() {
        bossInfoMap.clear();
        class_310.method_1551().field_1705.method_1740().field_2060.clear();
    }

    public static void onPlayerTick(class_746 player) {
        if (!player.method_37908().method_8608() || player.method_37908().method_8510() % 5L != 0L) {
            return;
        }
        class_1297 target = class_310.method_1551().field_1765 != null && class_310.method_1551().field_1765 instanceof class_3966 ? ((class_3966)class_310.method_1551().field_1765).method_17782() : null;
        ClientEventHandler.checkEntity(target);
        Iterator<Map.Entry<class_1297, ClientBossUI>> iterator = bossInfoMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<class_1297, ClientBossUI> entry = iterator.next();
            entry.getValue().bossInfo.update((class_1309)entry.getKey(), entry.getValue().cap);
            if (!entry.getKey().method_5805() || entry.getValue().timeOut < entry.getKey().method_37908().method_8510()) {
                class_310.method_1551().field_1705.method_1740().field_2060.remove(entry.getValue().bossInfo.method_5407());
                iterator.remove();
                continue;
            }
            if (!player.method_6057(entry.getKey())) continue;
            entry.getValue().timeOut = player.method_37908().method_8510() + 600L;
        }
    }

    private static ClientBossUI createBossGUI(class_1309 target, BossCapability cap) {
        ClientBossUI ui = new ClientBossUI(new ClientBossEvent(target, cap), (class_1297)target, cap);
        class_310.method_1551().field_1705.method_1740().field_2060.put(ui.bossInfo.method_5407(), ui.bossInfo);
        return ui;
    }

    public static void checkEntity(class_1297 target) {
        BossCapability cap;
        if (target instanceof BossCapEntity && (cap = ((BossCapEntity)target).getBossCap()) != null && cap.isBoss() && cap.getBossType().showBossBar()) {
            if (bossInfoMap.containsKey(target)) {
                ClientBossUI ui = bossInfoMap.get(target);
                ui.timeOut = target.method_37908().method_8510() + 600L;
            } else {
                bossInfoMap.put(target, ClientEventHandler.createBossGUI((class_1309)target, cap));
            }
        }
    }

    private static class ClientBossUI {
        private ClientBossEvent bossInfo;
        private long timeOut;
        private class_1297 boss;
        private BossCapability cap;

        private ClientBossUI(ClientBossEvent bossEVent, class_1297 boss, BossCapability cap) {
            this.bossInfo = bossEVent;
            this.timeOut = boss.method_37908().method_8510() + 600L;
            this.boss = boss;
            this.cap = cap;
        }
    }
}

