/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.ai.IAIParams;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class WhirlWind
extends class_1352 {
    public static class_2960 ID = class_2960.method_12829((String)"brutalbosses:whirlwind");
    private final class_1308 mob;
    private class_1309 target = null;
    private WhirldWindParams params;
    private int attackTimer = 0;

    public WhirlWind(class_1308 mob, IAIParams params) {
        this.params = (WhirldWindParams)params;
        this.mob = mob;
    }

    public boolean method_6264() {
        class_1309 target = this.mob.method_5968();
        if (target != null && target.method_5805()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public void method_6270() {
        this.target = null;
        this.attackTimer = 0;
    }

    public void method_6268() {
        if (--this.attackTimer > 0) {
            return;
        }
        double distSqr = this.mob.method_5649(this.target.method_23317(), this.target.method_23318(), this.target.method_23321());
        if (distSqr < (double)(this.params.attackDistance * this.params.attackDistance) && BrutalBosses.rand.nextInt(40) == 0) {
            this.attackTimer = this.params.cooldown;
            ArrayList<class_1309> entities = new ArrayList<class_1309>(this.mob.method_37908().method_18467(class_1657.class, this.mob.method_5829().method_1009(2.0, 0.5, 2.0)));
            if (!entities.contains(this.target)) {
                entities.add(this.target);
            }
            for (class_1309 livingentity : entities) {
                if (livingentity == this.mob || livingentity == null || !livingentity.method_5805()) continue;
                if (this.params.knockup) {
                    livingentity.method_18799(livingentity.method_18798().method_1031(0.0, (double)(this.params.knockback / 5.0f), 0.0));
                } else {
                    livingentity.method_6005((double)this.params.knockback, (double)class_3532.method_15374((float)(livingentity.method_36454() * (float)Math.PI)), (double)(-class_3532.method_15362((float)(livingentity.method_36454() * (float)Math.PI))));
                }
                this.mob.method_6104(class_1268.field_5808);
                float damage = this.params.extraDamage;
                if (this.mob.method_6127().method_45331(class_5134.field_23721)) {
                    damage = (float)((double)damage + this.mob.method_45325(class_5134.field_23721));
                }
                livingentity.method_5643(this.mob.method_48923().method_48812((class_1309)this.mob), damage);
                if (this.params.onHitMobEffect == null) continue;
                livingentity.method_6092(new class_1293(this.params.onHitMobEffect, this.params.potionduration, this.params.potionlevel));
            }
            this.mob.method_37908().method_43128(null, this.mob.method_23317(), this.mob.method_23318(), this.mob.method_23321(), class_3417.field_14706, this.mob.method_5634(), 1.0f, 1.0f);
            double d0 = -class_3532.method_15374((float)(this.mob.method_36454() * ((float)Math.PI / 180)));
            double d1 = class_3532.method_15362((float)(this.mob.method_36454() * ((float)Math.PI / 180)));
            if (this.mob.method_37908() instanceof class_3218) {
                ((class_3218)this.mob.method_37908()).method_14199((class_2394)class_2398.field_11227, this.mob.method_23317() + d0, this.mob.method_23323(0.5), this.mob.method_23321() + d1, 2, d0, 0.0, d1, 0.0);
            }
        }
    }

    public static class WhirldWindParams
    extends IAIParams.DefaultParams {
        private float attackDistance = 4.0f;
        private float extraDamage = 2.0f;
        private class_6880<class_1291> onHitMobEffect = null;
        private float knockback = 4.0f;
        private int cooldown = 80;
        private int potionlevel = 1;
        private int potionduration = 60;
        private boolean knockup = false;
        private static final String ATKDIST = "attackdist";
        private static final String EXTDMG = "extradamage";
        private static final String POTION = "potiononhit";
        private static final String POTION_STR = "potionlevel";
        private static final String POTION_DUR = "potionduration";
        private static final String KNOCK = "knockback";
        private static final String COOLDOWN = "cooldown";
        private static final String KNOCK_UP = "knockup";

        public WhirldWindParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(ATKDIST)) {
                this.attackDistance = jsonElement.get(ATKDIST).getAsFloat();
                this.attackDistance *= this.attackDistance;
            }
            if (jsonElement.has(EXTDMG)) {
                this.extraDamage = jsonElement.get(EXTDMG).getAsFloat();
            }
            if (jsonElement.has(POTION_STR)) {
                this.potionlevel = jsonElement.get(POTION_STR).getAsInt();
            }
            if (jsonElement.has(POTION_DUR)) {
                this.potionduration = jsonElement.get(POTION_DUR).getAsInt();
            }
            if (jsonElement.has(COOLDOWN)) {
                this.cooldown = jsonElement.get(COOLDOWN).getAsInt();
            }
            if (jsonElement.has(KNOCK)) {
                this.knockback = jsonElement.get(KNOCK).getAsFloat();
            }
            if (jsonElement.has(KNOCK_UP)) {
                this.knockup = jsonElement.get(KNOCK_UP).getAsBoolean();
            }
            if (jsonElement.has(POTION)) {
                class_2960 MobEffectID = class_2960.method_12829((String)jsonElement.get(POTION).getAsString());
                this.onHitMobEffect = (class_6880)class_7923.field_41174.method_55841(MobEffectID).get();
            }
            return this;
        }
    }
}

