/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.IOnProjectileHit;
import com.brutalbosses.entity.PosUtil;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.capability.BossCapEntity;
import com.brutalbosses.entity.capability.BossCapability;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1617;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4051;

public abstract class SimpleRangedAttackGoal
extends class_1352 {
    protected final class_1308 mob;
    protected class_1309 target;
    protected int attackTime = -1;
    protected double speedModifier;
    protected int seeTime;
    protected int attackIntervalMin;
    protected int attackIntervalMax;
    protected float attackRadiusSqr;
    protected final BossCapability cap;
    protected final RangedParams params;
    private final List<class_1676> projectileEntities = new ArrayList<class_1676>();
    private boolean isChargingUp = false;
    private final class_4051 playerAoeFinder;

    public SimpleRangedAttackGoal(class_1308 mob, IAIParams params) {
        this.mob = mob;
        this.cap = ((BossCapEntity)mob).getBossCap();
        this.params = (RangedParams)params;
        this.speedModifier = 1.0;
        this.attackIntervalMin = this.params.interval - 10;
        this.attackIntervalMax = this.params.interval + 10;
        this.attackRadiusSqr = this.params.distance * this.params.distance;
        this.playerAoeFinder = class_4051.method_36625().method_18418((double)this.params.distance);
        this.attackTime = ((RangedParams)params).interval / 2;
    }

    protected abstract class_2960 getID();

    public boolean method_6264() {
        class_1309 target = this.mob.method_5968();
        if (target != null && target.method_5805()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        target = this.mob.method_6065();
        if (target != null && target.method_5805()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public boolean method_6266() {
        return this.method_6264();
    }

    public void method_6270() {
        this.target = null;
        this.seeTime = 0;
        for (class_1676 Projectile : this.projectileEntities) {
            Projectile.method_5650(class_1297.class_5529.field_26999);
        }
        this.projectileEntities.clear();
        this.attackTime = this.params.interval / 2;
    }

    public void method_6268() {
        double distSqr = this.mob.method_5649(this.target.method_23317(), this.target.method_23318(), this.target.method_23321());
        boolean canSee = this.mob.method_5985().method_6369((class_1297)this.target);
        this.seeTime = canSee ? ++this.seeTime : 0;
        this.mob.method_5988().method_6226((class_1297)this.target, 30.0f, 30.0f);
        if (!this.projectileEntities.isEmpty()) {
            for (int i = 0; i < this.projectileEntities.size(); ++i) {
                class_1676 Projectile = this.projectileEntities.get(i);
                if (Projectile == null) continue;
                if (!Projectile.method_5805()) {
                    this.projectileEntities.remove(i);
                    --i;
                    continue;
                }
                this.positionProjectile(Projectile, i + 1);
            }
        }
        if (--this.attackTime == 0) {
            class_1657 closest;
            if (!canSee || distSqr > (double)this.attackRadiusSqr + 2.0) {
                this.attackTime = 10;
                return;
            }
            if (this.projectileEntities.isEmpty()) {
                this.isChargingUp = true;
            }
            if (this.isChargingUp && this.projectileEntities.size() < this.params.count) {
                this.mob.method_5942().method_6340();
                int nextCount = this.projectileEntities.size() + 1;
                this.projectileEntities.add(this.createProjectile(nextCount));
                if (this.params.count > 1) {
                    this.mob.method_37908().method_43128(null, this.mob.method_23317(), this.mob.method_23318(), this.mob.method_23321(), class_3417.field_15013, this.mob.method_5634(), 0.3f, 2.0f);
                }
                if (nextCount == this.params.count) {
                    if (this.mob instanceof class_1617) {
                        ((class_1617)this.mob).method_7138(class_1617.class_1618.field_7377);
                    }
                    this.isChargingUp = false;
                    this.attackTime = 5 * this.params.count;
                } else {
                    if (this.mob instanceof class_1617) {
                        ((class_1617)this.mob).method_7138(class_1617.class_1618.field_7381);
                    }
                    this.attackTime = 5;
                }
                return;
            }
            if (this.params.count > 1 && this.projectileEntities.size() % 2 == 0 && (closest = this.mob.method_37908().method_18460((class_1297)this.mob, (double)this.params.distance)) != null) {
                this.target = closest;
            }
            class_1676 Projectile = this.projectileEntities.remove(this.projectileEntities.size() - 1);
            if (this.params.aoe) {
                Projectile.method_5650(class_1297.class_5529.field_26999);
                List players = this.mob.method_37908().method_18466(class_1657.class, this.playerAoeFinder, (class_1309)this.mob, this.mob.method_5829().method_1009((double)this.params.distance, 15.0, (double)this.params.distance));
                boolean containedTarget = false;
                for (class_1657 Player : players) {
                    class_1676 aoe = this.createProjectile(1);
                    aoe.method_5814(Projectile.method_23317(), Projectile.method_23318(), Projectile.method_23321());
                    this.doRangedAttack(aoe, (class_1309)Player);
                    if (Player != this.target) continue;
                    containedTarget = true;
                }
                if (!containedTarget) {
                    class_1676 aoe = this.createProjectile(1);
                    aoe.method_5814(Projectile.method_23317(), Projectile.method_23318(), Projectile.method_23321());
                    this.doRangedAttack(aoe, this.target);
                }
            } else {
                this.doRangedAttack(Projectile, this.target);
            }
            if (!this.projectileEntities.isEmpty()) {
                this.attackTime = 10;
                return;
            }
            float relativeAttackDist = (float)(Math.sqrt(distSqr) / (double)this.params.distance);
            this.attackTime = class_3532.method_15375((float)((1.0f + BrutalBosses.rand.nextFloat() * 0.5f) * (relativeAttackDist * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin))) - 5 * this.params.count;
        } else if (this.attackTime < 0) {
            float relativeAttackDist = (float)(Math.sqrt(distSqr) / (double)this.params.distance);
            this.attackTime = class_3532.method_15375((float)((1.0f + BrutalBosses.rand.nextFloat() * 0.5f) * (relativeAttackDist * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin))) - Math.min(5 * this.params.count, this.attackIntervalMin - 5);
        }
    }

    protected abstract class_1676 createProjectile();

    protected abstract void doRangedAttack(class_1676 var1, class_1309 var2);

    protected class_1676 createProjectile(int number) {
        class_1676 Projectile = this.createProjectile();
        this.positionProjectile(Projectile, number);
        Projectile.field_5960 = true;
        Projectile.method_5875(true);
        Projectile.method_7432((class_1297)this.mob);
        if (Projectile instanceof IOnProjectileHit) {
            ((IOnProjectileHit)Projectile).setMaxLifeTime(this.mob.method_37908().method_8510() + 1200L);
        }
        this.mob.method_37908().method_8649((class_1297)Projectile);
        return Projectile;
    }

    protected void positionProjectile(class_1676 Projectile, int number) {
        if (this.params.count == 1) {
            class_2350 dir = PosUtil.getFacing(this.mob.method_19538(), this.target.method_19538()).method_10170();
            Projectile.method_5814(this.mob.method_23317() + (double)dir.method_10160().method_10148() * 0.5, this.mob.method_23318() + (double)this.mob.method_5751() - 0.5, this.mob.method_23321() + (double)dir.method_10160().method_10165() * 0.5);
            return;
        }
        class_2350 dir = PosUtil.getFacing(this.mob.method_19538(), this.target.method_19538()).method_10170();
        class_243 center = new class_243(this.mob.method_23317(), this.mob.method_23318() - 0.5 + (double)(this.mob.method_5751() * this.cap.getBossType().getVisualScale()), this.mob.method_23321());
        double y = 0.75 * Math.cos(Math.toRadians(360.0 / (double)(this.params.count + 1) * (double)number));
        double xzRatio = 0.75 * Math.sin(Math.toRadians(360.0 / (double)(this.params.count + 1) * (double)number));
        class_243 offSet = new class_243(xzRatio * (double)dir.method_10148(), -y, xzRatio * (double)dir.method_10165());
        center = center.method_1019(offSet);
        center = center.method_1019(new class_243((double)dir.method_10160().method_10148() * 0.5, 0.0, (double)dir.method_10160().method_10165() * 0.5));
        Projectile.method_5814(center.field_1352, center.field_1351, center.field_1350);
    }

    public static class RangedParams
    extends IAIParams.DefaultParams {
        protected int count = 1;
        protected int interval = 50;
        protected int distance = 15;
        protected boolean aoe = false;
        protected float speed = 1.0f;
        private static final String PROJECTILE_COUNT = "projectile_count";
        private static final String PROJECTILE_INTERVAL = "projectile_interval";
        private static final String PROJECTILE_DISTANCE = "projectile_distance";
        private static final String PROJECTILE_AOE = "projectile_aoe";
        private static final String PROJECTILE_SPEED = "projectile_speed";

        public RangedParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(PROJECTILE_COUNT)) {
                this.count = jsonElement.get(PROJECTILE_COUNT).getAsInt();
            }
            if (jsonElement.has(PROJECTILE_INTERVAL)) {
                this.interval = jsonElement.get(PROJECTILE_INTERVAL).getAsInt();
            }
            if (jsonElement.has(PROJECTILE_DISTANCE)) {
                this.distance = jsonElement.get(PROJECTILE_DISTANCE).getAsInt();
            }
            if (jsonElement.has(PROJECTILE_AOE)) {
                this.aoe = jsonElement.get(PROJECTILE_AOE).getAsBoolean();
            }
            if (jsonElement.has(PROJECTILE_SPEED)) {
                this.speed = jsonElement.get(PROJECTILE_SPEED).getAsFloat();
            }
            return this;
        }
    }
}

