/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.config.CommonConfiguration;
import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.BossTypeManager;
import com.brutalbosses.entity.capability.BossCapEntity;
import com.cupboard.util.BlockSearch;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2621;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_5425;

public class BossSpawnHandler {
    private static ConcurrentLinkedQueue<class_3545<class_2338, BossType>> spawns = new ConcurrentLinkedQueue();

    public static void onChestPlaced(class_5425 world, class_2621 chest) {
        List possibleBosses = (List)BossTypeManager.instance.lootTableSpawnEntries.get((Object)chest.field_12037.method_29177());
        if (possibleBosses != null && !possibleBosses.isEmpty()) {
            if (BrutalBosses.rand.nextInt(100) > ((CommonConfiguration)BrutalBosses.config.getCommonConfig()).globalBossSpawnChance) {
                return;
            }
            if (BossSpawnHandler.spawnedRecentlyClose(chest.method_11016())) {
                return;
            }
            BossType bossType = (BossType)possibleBosses.get(BrutalBosses.rand.nextInt(possibleBosses.size()));
            if (bossType == null || bossType.getID().method_12832().equals("dummyboss")) {
                return;
            }
            BossSpawnHandler.spawnBoss(world, chest.method_11016(), bossType, chest);
        } else if (((CommonConfiguration)BrutalBosses.config.getCommonConfig()).printChestLoottable) {
            BrutalBosses.LOGGER.info("Chest with Loottable: " + String.valueOf(chest.field_12037) + " not associated with any boss spawn");
        }
    }

    private static boolean spawnedRecentlyClose(class_2338 pos) {
        for (class_3545<class_2338, BossType> data : spawns) {
            if (!(Math.sqrt(((class_2338)data.method_15442()).method_10262((class_2382)pos)) < (double)((CommonConfiguration)BrutalBosses.config.getCommonConfig()).minDistance)) continue;
            return true;
        }
        return false;
    }

    public static void spawnBoss(class_5425 world, class_2338 pos, BossType bossType, class_2621 chest) {
        try {
            class_2338 spawnPos;
            class_1308 boss;
            spawns.add((class_3545<class_2338, BossType>)new class_3545((Object)pos, (Object)bossType));
            if (spawns.size() > 20) {
                spawns.poll();
            }
            if ((boss = bossType.createBossEntity((class_1937)world.method_8410())) == null) {
                return;
            }
            if (chest != null) {
                class_2960 lootTable = chest.field_12037.method_29177();
                BrutalBosses.LOGGER.debug("Spawning " + String.valueOf(bossType.getID()) + " at " + String.valueOf(pos) + " at " + chest.method_5476().getString() + " with:" + String.valueOf(lootTable));
            }
            if ((spawnPos = BossSpawnHandler.findSpawnPosForBoss(world, (class_1297)boss, pos)) == null) {
                boss.method_5650(class_1297.class_5529.field_26999);
                return;
            }
            boss.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
            if (chest != null) {
                ((BossCapEntity)boss).getBossCap().setLootTable(chest.field_12037.method_29177());
            }
            ((BossCapEntity)boss).getBossCap().setSpawnPos(pos);
            if (!boss.method_31481()) {
                world.method_8649((class_1297)boss);
            }
        }
        catch (Exception spawnException) {
            BrutalBosses.LOGGER.error("Boss: " + String.valueOf(bossType.getID()) + " failed to spawn! Error:", (Throwable)spawnException);
        }
    }

    public static class_2338 findSpawnPosForBoss(class_5425 world, class_1297 boss, class_2338 pos) {
        class_2338 spawnPos = BlockSearch.findAround((class_1922)world, (class_2338)pos, (int)15, (int)10, (int)1, (w, p) -> {
            if (w.method_8320(p.method_10074()).method_26215()) {
                return false;
            }
            for (int x = class_3532.method_15375((float)((-boss.method_17681() + 1.0f) / 2.0f)); x <= class_3532.method_15386((float)((boss.method_17681() - 1.0f) / 2.0f)); ++x) {
                for (int z = class_3532.method_15375((float)((-boss.method_17681() + 1.0f) / 2.0f)); z <= class_3532.method_15386((float)((boss.method_17681() - 1.0f) / 2.0f)); ++z) {
                    for (int y = 0; y <= class_3532.method_15386((float)boss.method_17682()); ++y) {
                        if (w.method_8320(p.method_10069(x, y, z)).method_26215()) continue;
                        return false;
                    }
                }
            }
            return true;
        });
        return spawnPos;
    }

    public static void spawnRandomBoss(class_3218 world, class_2338 pos) {
        ArrayList<BossType> list = new ArrayList<BossType>(BossTypeManager.instance.bosses.values());
        BossType bossType = (BossType)list.get(BrutalBosses.rand.nextInt(list.size()));
        BossSpawnHandler.spawnBoss((class_5425)world, pos, bossType, null);
    }
}

