/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.networking;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.components.GraveComponent;
import com.b1n_ry.yigd.config.ClaimPriority;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathInfoManager;
import com.b1n_ry.yigd.data.GraveStatus;
import com.b1n_ry.yigd.networking.LightGraveData;
import com.b1n_ry.yigd.networking.LightPlayerData;
import com.b1n_ry.yigd.networking.packets.DeleteGraveC2SPacket;
import com.b1n_ry.yigd.networking.packets.GraveOverviewRequestC2SPacket;
import com.b1n_ry.yigd.networking.packets.GraveOverviewS2CPacket;
import com.b1n_ry.yigd.networking.packets.GraveSelectionRequestC2SPacket;
import com.b1n_ry.yigd.networking.packets.GraveSelectionS2CPacket;
import com.b1n_ry.yigd.networking.packets.LockGraveC2SPacket;
import com.b1n_ry.yigd.networking.packets.PlayerSelectionS2CPacket;
import com.b1n_ry.yigd.networking.packets.RequestCompassC2SPacket;
import com.b1n_ry.yigd.networking.packets.RequestKeyC2SPacket;
import com.b1n_ry.yigd.networking.packets.RestoreGraveC2SPacket;
import com.b1n_ry.yigd.networking.packets.RobGraveC2SPacket;
import com.b1n_ry.yigd.networking.packets.SyncConfigS2CPacket;
import com.b1n_ry.yigd.networking.packets.UpdateConfigC2SPacket;
import com.b1n_ry.yigd.util.DropRule;
import com.b1n_ry.yigd.util.GraveCompassHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9296;
import net.minecraft.server.MinecraftServer;

public class ServerPacketHandler {
    public static void registerReceivers() {
        ServerPlayNetworking.registerGlobalReceiver(RestoreGraveC2SPacket.TYPE, (payload, context) -> {
            YigdConfig config = YigdConfig.getConfig();
            class_3222 player = context.player();
            if (!Permissions.check((class_1297)player, (String)"yigd.command.restore", (int)config.commandConfig.restorePermissionLevel)) {
                player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.permission_fail"));
                return;
            }
            UUID graveId = payload.graveId();
            boolean itemsInGrave = payload.itemsInGrave();
            boolean itemsDeleted = payload.itemsDeleted();
            boolean itemsKept = payload.itemsKept();
            boolean itemsDropped = payload.itemsDropped();
            MinecraftServer server = player.field_13995;
            server.execute(() -> {
                Optional<GraveComponent> maybeComponent = DeathInfoManager.INSTANCE.getGrave(graveId);
                maybeComponent.ifPresentOrElse(component -> {
                    class_3222 restoringPlayer;
                    class_9296 owner = component.getOwner();
                    UUID uuid = owner.comp_2411().orElse(null);
                    String playerName = owner.comp_2410().orElse(null);
                    class_3222 class_32222 = uuid != null ? server.method_3760().method_14602(uuid) : (restoringPlayer = playerName != null ? server.method_3760().method_14566(playerName) : null);
                    if (restoringPlayer == null) {
                        player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.restore.fail.offline_player"));
                        return;
                    }
                    component.applyToPlayer(restoringPlayer, restoringPlayer.method_51469(), restoringPlayer.method_19538(), true, dropRule -> switch (dropRule) {
                        default -> throw new MatchException(null, null);
                        case DropRule.KEEP -> itemsKept;
                        case DropRule.DESTROY -> itemsDeleted;
                        case DropRule.DROP -> itemsDropped;
                        case DropRule.PUT_IN_GRAVE -> itemsInGrave;
                    });
                    if (itemsInGrave) {
                        component.setStatus(GraveStatus.CLAIMED);
                        component.removeGraveBlock();
                    }
                    player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.restore.success"));
                }, () -> player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.restore.fail")));
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(RobGraveC2SPacket.TYPE, (payload, context) -> {
            YigdConfig config = YigdConfig.getConfig();
            class_3222 player = context.player();
            if (!Permissions.check((class_1297)player, (String)"yigd.command.rob", (int)config.commandConfig.robPermissionLevel)) {
                player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.permission_fail"));
                return;
            }
            UUID graveId = payload.graveId();
            boolean itemsInGrave = payload.itemsInGrave();
            boolean itemsDeleted = payload.itemsDeleted();
            boolean itemsKept = payload.itemsKept();
            boolean itemsDropped = payload.itemsDropped();
            MinecraftServer server = player.field_13995;
            server.execute(() -> {
                Optional<GraveComponent> maybeComponent = DeathInfoManager.INSTANCE.getGrave(graveId);
                maybeComponent.ifPresentOrElse(component -> {
                    component.applyToPlayer(player, player.method_51469(), player.method_19538(), false, dropRule -> switch (dropRule) {
                        default -> throw new MatchException(null, null);
                        case DropRule.KEEP -> itemsKept;
                        case DropRule.DESTROY -> itemsDeleted;
                        case DropRule.DROP -> itemsDropped;
                        case DropRule.PUT_IN_GRAVE -> itemsInGrave;
                    });
                    if (itemsInGrave) {
                        component.setStatus(GraveStatus.CLAIMED);
                        component.removeGraveBlock();
                    }
                    player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.rob.success"));
                }, () -> player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.rob.fail")));
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(DeleteGraveC2SPacket.TYPE, (payload, context) -> {
            YigdConfig config = YigdConfig.getConfig();
            class_3222 player = context.player();
            if (!Permissions.check((class_1297)player, (String)"yigd.command.delete", (int)config.commandConfig.deletePermissionLevel)) {
                player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.permission_fail"));
                return;
            }
            UUID graveId = payload.graveId();
            MinecraftServer server = player.field_13995;
            server.execute(() -> {
                class_1269 deleted = DeathInfoManager.INSTANCE.delete(graveId);
                DeathInfoManager.INSTANCE.method_80();
                String translatable = switch (deleted) {
                    case class_1269.field_5812 -> "text.yigd.command.delete.success";
                    case class_1269.field_5811 -> "text.yigd.command.delete.pass";
                    case class_1269.field_5814 -> "text.yigd.command.delete.fail";
                    default -> "If you see this, congratulations. You've broken YIGD";
                };
                player.method_43496((class_2561)class_2561.method_43471((String)translatable));
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(LockGraveC2SPacket.TYPE, (payload, context) -> {
            YigdConfig config = YigdConfig.getConfig();
            class_3222 player = context.player();
            if (!Permissions.check((class_1297)player, (String)"yigd.command.locking", (int)config.commandConfig.unlockPermissionLevel)) {
                player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.permission_fail"));
                return;
            }
            UUID graveId = payload.graveId();
            boolean lockState = payload.locked();
            MinecraftServer server = player.field_13995;
            server.execute(() -> {
                Optional<GraveComponent> component = DeathInfoManager.INSTANCE.getGrave(graveId);
                component.ifPresentOrElse(grave -> grave.setLocked(lockState), () -> player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.lock.fail")));
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(RequestKeyC2SPacket.TYPE, (payload, context) -> {
            YigdConfig config = YigdConfig.getConfig();
            class_3222 player = context.player();
            if (!config.extraFeatures.graveKeys.enabled || !config.extraFeatures.graveKeys.obtainableFromGui) {
                player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.permission_fail"));
                return;
            }
            UUID graveId = payload.graveId();
            MinecraftServer server = player.field_13995;
            server.execute(() -> {
                Optional<GraveComponent> component = DeathInfoManager.INSTANCE.getGrave(graveId);
                component.ifPresentOrElse(grave -> {
                    class_1799 key = new class_1799((class_1935)Yigd.GRAVE_KEY_ITEM);
                    Yigd.GRAVE_KEY_ITEM.bindStackToGrave(graveId, grave.getOwner(), key);
                    player.method_7270(key);
                }, () -> player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.obtain_key.fail")));
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(RequestCompassC2SPacket.TYPE, (payload, context) -> {
            YigdConfig config = YigdConfig.getConfig();
            class_3222 player = context.player();
            if (!config.extraFeatures.graveCompass.cloneRecoveryCompassWithGUI) {
                player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.permission_fail"));
                return;
            }
            UUID graveId = payload.graveId();
            MinecraftServer server = player.field_13995;
            server.execute(() -> {
                Optional<GraveComponent> component = DeathInfoManager.INSTANCE.getGrave(graveId);
                component.ifPresentOrElse(grave -> GraveCompassHelper.giveCompass(player, graveId, grave.getPos(), grave.getWorldRegistryKey()), () -> player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.obtain_compass.fail")));
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(GraveOverviewRequestC2SPacket.TYPE, (payload, context) -> {
            YigdConfig config = YigdConfig.getConfig();
            class_3222 player = context.player();
            if (!Permissions.check((class_1297)player, (String)"yigd.command.view_self", (int)config.commandConfig.viewSelfPermissionLevel)) {
                player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.permission_fail"));
                return;
            }
            UUID graveId = payload.graveId();
            Optional<GraveComponent> component = DeathInfoManager.INSTANCE.getGrave(graveId);
            component.ifPresentOrElse(grave -> ServerPacketHandler.sendGraveOverviewPacket(player, grave), () -> player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.view_self.fail")));
        });
        ServerPlayNetworking.registerGlobalReceiver(GraveSelectionRequestC2SPacket.TYPE, (payload, context) -> {
            YigdConfig config = YigdConfig.getConfig();
            class_3222 player = context.player();
            if (!Permissions.check((class_1297)player, (String)"yigd.command.view_user", (int)config.commandConfig.viewUserPermissionLevel)) {
                player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.permission_fail"));
                return;
            }
            class_9296 profile = payload.profile();
            List<GraveComponent> components = DeathInfoManager.INSTANCE.getBackupData(profile);
            ArrayList<LightGraveData> lightGraveData = new ArrayList<LightGraveData>();
            for (GraveComponent component : components) {
                lightGraveData.add(component.toLightData());
            }
            ServerPacketHandler.sendGraveSelectionPacket(player, profile, lightGraveData);
        });
        ServerPlayNetworking.registerGlobalReceiver(UpdateConfigC2SPacket.TYPE, (payload, context) -> {
            class_3222 player = context.player();
            ClaimPriority claimPriority = payload.claiming();
            ClaimPriority robPriority = payload.robbing();
            UUID playerId = player.method_5667();
            Yigd.CLAIM_PRIORITIES.put(playerId, claimPriority);
            Yigd.ROB_PRIORITIES.put(playerId, robPriority);
            Yigd.LOGGER.info("Priority overwritten for player {}. Claiming: {} / Robbing: {}", new Object[]{player.method_7334().getName(), claimPriority.name(), robPriority.name()});
        });
    }

    public static void sendGraveOverviewPacket(class_3222 player, GraveComponent component) {
        YigdConfig config = YigdConfig.getConfig();
        YigdConfig.CommandConfig commandConfig = YigdConfig.getConfig().commandConfig;
        boolean canRestore = Permissions.check((class_1297)player, (String)"yigd.command.restore", (int)commandConfig.restorePermissionLevel);
        boolean canRob = Permissions.check((class_1297)player, (String)"yigd.command.rob", (int)commandConfig.robPermissionLevel);
        boolean canDelete = Permissions.check((class_1297)player, (String)"yigd.command.delete", (int)commandConfig.deletePermissionLevel);
        boolean canUnlock = Permissions.check((class_1297)player, (String)"yigd.command.locking", (int)commandConfig.unlockPermissionLevel);
        boolean obtainableKeys = config.extraFeatures.graveKeys.enabled && config.extraFeatures.graveKeys.obtainableFromGui;
        boolean obtainableCompass = config.extraFeatures.graveCompass.cloneRecoveryCompassWithGUI && player.method_31548().method_18861(class_1802.field_38747) > 0;
        ServerPlayNetworking.send((class_3222)player, (class_8710)new GraveOverviewS2CPacket(component, canRestore, canRob, canDelete, canUnlock, obtainableKeys, obtainableCompass));
    }

    public static void sendGraveSelectionPacket(class_3222 player, class_9296 ofUser, List<LightGraveData> data) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new GraveSelectionS2CPacket(data, ofUser));
    }

    public static void sendPlayerSelectionPacket(class_3222 player, List<LightPlayerData> data) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new PlayerSelectionS2CPacket(data));
    }

    public static void sendConfigSyncPacket(class_3222 player) {
        YigdConfig config = YigdConfig.getConfig();
        ServerPlayNetworking.send((class_3222)player, (class_8710)new SyncConfigS2CPacket(config.graveConfig.retrieveMethods.onBreak, config.graveRendering.useGlowingEffect, config.graveRendering.glowingDistance, config.extraFeatures.deathSightEnchant.range));
    }
}

