/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.bettertrims;

import com.bawnorton.configurable.ConfigurableMain;
import com.bawnorton.configurable.bettertrims.Config;
import com.bawnorton.configurable.generated.GeneratedConfigLoader;
import com.bawnorton.configurable.libs.gson.FieldNamingStrategy;
import com.bawnorton.configurable.libs.gson.Gson;
import com.bawnorton.configurable.libs.gson.GsonBuilder;
import com.bawnorton.configurable.libs.gson.JsonElement;
import com.bawnorton.configurable.libs.gson.JsonObject;
import com.bawnorton.configurable.libs.gson.JsonPrimitive;
import com.bawnorton.configurable.libs.gson.JsonSyntaxException;
import com.bawnorton.configurable.libs.gson.stream.JsonWriter;
import com.bawnorton.configurable.libs.parsers.json.JsonReader;
import com.bawnorton.configurable.libs.parsers.json.gson.GsonReader;
import com.bawnorton.configurable.libs.parsers.json.gson.GsonWriter;
import com.bawnorton.configurable.platform.Platform;
import com.bawnorton.configurable.ref.Reference;
import com.bawnorton.configurable.ref.gson.ReferenceSerializer;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;

public final class ConfigLoader
implements GeneratedConfigLoader<Config> {
    private static final Path configPath = Platform.getConfigDir().resolve("configurable/bettertrims.json5");
    private static final Path legacyConfigPath = Platform.getConfigDir().resolve("configurable/bettertrims.json");
    private static final Map<String, Field> FIELDS_BY_KEY_PATH = new HashMap<String, Field>();
    private static final Gson GSON = ConfigLoader.createGson();

    private static Gson createGson() {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Reference.class, (Object)new ReferenceSerializer());
        ConfigurableMain.getTypeAdapters((String)"bettertrims", (String)"main").forEach((arg_0, arg_1) -> ((GsonBuilder)builder).registerTypeHierarchyAdapter(arg_0, arg_1));
        FieldNamingStrategy namingStrategy = ConfigurableMain.getFieldNamingStrategy((String)"bettertrims", (String)"main");
        builder.setFieldNamingStrategy(namingStrategy);
        ConfigLoader.recordNestedKeyPaths(Config.class, "", namingStrategy, FIELDS_BY_KEY_PATH::put);
        return builder.create();
    }

    private static void recordNestedKeyPaths(Class<?> clazz, String keyPath, FieldNamingStrategy namingStrategy, BiConsumer<String, Field> setter) {
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getName().equals("CONFIGURABLE_COMMENT")) continue;
            String fieldPath = keyPath + namingStrategy.translateName(field);
            setter.accept(fieldPath, field);
            if (field.getType().equals(Reference.class)) continue;
            ConfigLoader.recordNestedKeyPaths(field.getType(), "%s.".formatted(fieldPath), namingStrategy, setter);
        }
    }

    public Config loadConfig(UnaryOperator<String> datafixer) {
        try {
            boolean usingLegacyConfig = false;
            Path loadingPath = configPath;
            if (Files.exists(legacyConfigPath, new LinkOption[0])) {
                loadingPath = legacyConfigPath;
                usingLegacyConfig = true;
            }
            if (!Files.exists(loadingPath, new LinkOption[0])) {
                Files.createDirectories(loadingPath.getParent(), new FileAttribute[0]);
                Files.createFile(loadingPath, new FileAttribute[0]);
                return new Config();
            }
            try {
                GsonReader reader = new GsonReader(JsonReader.json5((Reader)Files.newBufferedReader(loadingPath)));
                JsonObject config = (JsonObject)GSON.fromJson((com.bawnorton.configurable.libs.gson.stream.JsonReader)reader, JsonObject.class);
                Config parsed = this.parseConfig(config, true);
                if (usingLegacyConfig) {
                    ConfigurableMain.LOGGER.info("Migrating legacy config \"bettertrims\"");
                    Files.deleteIfExists(legacyConfigPath);
                    this.saveConfig(parsed);
                }
                ConfigurableMain.LOGGER.info("Successfully loaded config \"bettertrims\"");
                return parsed;
            }
            catch (JsonSyntaxException e) {
                ConfigurableMain.LOGGER.error("Failed to parse \"bettertrims\" config file, using default", (Throwable)e);
            }
        }
        catch (IOException | RuntimeException e) {
            ConfigurableMain.LOGGER.error("Failed to load \"bettertrims\" config file, using default", (Throwable)e);
        }
        return new Config();
    }

    public void saveConfig(Config config) {
        try (StringWriter stringWriter = new StringWriter();){
            Field[] fields;
            com.bawnorton.configurable.libs.parsers.json.JsonWriter writer = com.bawnorton.configurable.libs.parsers.json.JsonWriter.json5((Writer)stringWriter);
            writer.beginObject();
            for (Field field : fields = Config.class.getDeclaredFields()) {
                this.writeField(field, config, writer);
            }
            writer.endObject();
            writer.flush();
            Files.writeString(configPath, (CharSequence)stringWriter.toString(), StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            ConfigurableMain.LOGGER.error("Failed to write \"bettertrims\" config file", (Throwable)e);
        }
    }

    private void writeField(Field field, Object instance, com.bawnorton.configurable.libs.parsers.json.JsonWriter writer) throws IOException {
        try {
            boolean isRef = field.getType().equals(Reference.class);
            if (isRef) {
                this.writeRefField(field, instance, writer);
            } else {
                this.writeNestedField(field, field.get(instance), writer);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new IOException(e);
        }
    }

    private void writeRefField(Field field, Object instance, com.bawnorton.configurable.libs.parsers.json.JsonWriter writer) throws IOException, ReflectiveOperationException {
        Reference ref = (Reference)field.get(instance);
        if (ref.hasComment()) {
            writer.blockComment(ref.getComment());
        }
        writer.name(GSON.fieldNamingStrategy().translateName(field));
        JsonElement elemnt = GSON.toJsonTree((Object)ref, field.getGenericType());
        GSON.toJson(elemnt, (JsonWriter)new GsonWriter(writer));
    }

    private void writeNestedField(Field field, Object instance, com.bawnorton.configurable.libs.parsers.json.JsonWriter writer) throws IOException, ReflectiveOperationException {
        Field[] nestedFields;
        try {
            Field commentField = instance.getClass().getDeclaredField("CONFIGURABLE_COMMENT");
            String comment = (String)commentField.get(instance);
            if (comment != null && !comment.isEmpty()) {
                writer.blockComment(comment);
            }
        }
        catch (NoSuchFieldException commentField) {
            // empty catch block
        }
        writer.name(GSON.fieldNamingStrategy().translateName(field));
        writer.beginObject();
        for (Field nestedField : nestedFields = instance.getClass().getDeclaredFields()) {
            if (nestedField.getName().equals("CONFIGURABLE_COMMENT")) continue;
            nestedField.setAccessible(true);
            this.writeField(nestedField, instance, writer);
        }
        writer.endObject();
    }

    public String serializeConfig(Config config) {
        return GSON.toJson((Object)config);
    }

    public Config deserializeConfig(String serializedConfig) {
        return this.parseConfig((JsonObject)GSON.fromJson(serializedConfig, JsonObject.class), false);
    }

    private Config parseConfig(JsonObject configJson, boolean set) {
        ArrayList<String> stack = new ArrayList<String>();
        Config config = new Config();
        this.parseNested(stack, configJson, config, set);
        return config;
    }

    private void parseNested(List<String> stack, JsonObject nestedJson, Config config, boolean set) {
        Set keys = nestedJson.keySet();
        for (String key : keys) {
            JsonElement element = nestedJson.get(key);
            if (element.isJsonObject()) {
                stack.add(key);
                this.parseNested(stack, element.getAsJsonObject(), config, set);
                stack.remove(stack.size() - 1);
                continue;
            }
            if (element.isJsonNull()) {
                this.parseReference(key, null, stack, config, set);
                continue;
            }
            if (!element.isJsonPrimitive()) continue;
            this.parseReference(key, element.getAsJsonPrimitive(), stack, config, set);
        }
    }

    private void parseReference(String key, JsonPrimitive value, List<String> parents, Config config, boolean set) {
        block13: {
            Class<?> configClass = config.getClass();
            Object keyPath = "";
            if (!parents.isEmpty()) {
                keyPath = String.join((CharSequence)".", parents) + ".";
            }
            keyPath = (String)keyPath + key;
            Field target = FIELDS_BY_KEY_PATH.get(keyPath);
            Object instance = config;
            try {
                if (!parents.isEmpty()) {
                    Object parentKeyPath = parents.get(0);
                    Field parentField = FIELDS_BY_KEY_PATH.get(parentKeyPath);
                    for (int i = 0; i < parents.size(); ++i) {
                        if (i > 0) {
                            parentKeyPath = (String)parentKeyPath + "." + parents.get(i);
                            parentField = FIELDS_BY_KEY_PATH.get(parentKeyPath);
                        }
                        try {
                            instance = parentField.get(instance);
                            continue;
                        }
                        catch (ReflectiveOperationException e) {
                            ConfigurableMain.LOGGER.error("Field: \"%s\" could not be set.".formatted(keyPath), (Throwable)e);
                        }
                    }
                }
            }
            catch (RuntimeException ignored) {
                ConfigurableMain.LOGGER.warn("Field: \"%s\" could not be found.".formatted(keyPath));
                return;
            }
            try {
                Reference reference = (Reference)target.get(instance);
                Class expected = reference.getType();
                try {
                    Object refValue = this.getRefValue(value, expected);
                    if (set) {
                        reference.set(refValue);
                        break block13;
                    }
                    reference.setMemento(refValue);
                }
                catch (ClassCastException | IllegalArgumentException e) {
                    ConfigurableMain.LOGGER.warn("Field: \"%s\" of type \"%s\" could not be set to \"%s\". Falling back to default.".formatted(keyPath, expected, value.toString()));
                }
            }
            catch (IllegalAccessException e) {
                ConfigurableMain.LOGGER.error("Field: \"%s\" could not be set. Falling back to default".formatted(keyPath), (Throwable)e);
            }
        }
    }

    private Object getRefValue(JsonPrimitive value, Class<?> expected) {
        if (value == null) {
            return null;
        }
        return GSON.getAdapter(expected).fromJsonTree((JsonElement)value);
    }
}

