/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.mixin.attributes.celestial;

import com.bawnorton.bettertrims.effect.CelestialEffect;
import com.bawnorton.bettertrims.extend.LivingEntityExtender;
import com.bawnorton.bettertrims.registry.content.TrimEffects;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1937;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements LivingEntityExtender {
    @Shadow
    public abstract double method_45325(class_6880<class_1320> var1);

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @ModifyReturnValue(method={"getMovementSpeed()F"}, at={@At(value="RETURN")})
    protected float applyCelestialToMovementSpeed(float original) {
        return original + (float)this.bettertrims$getCelestialLevel() * this.bettertrims$getCelestial().map(CelestialEffect::getMovementSpeed).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @ModifyReturnValue(method={"applyArmorToDamage"}, at={@At(value="RETURN")})
    protected float applyCelestialToDamage(float original) {
        return original * (1.0f - (float)this.bettertrims$getCelestialLevel() * this.bettertrims$getCelestial().map(CelestialEffect::getDamageResistance).orElse(Float.valueOf(0.0f)).floatValue());
    }

    @Unique
    protected float bettertrims$applyCelestialToAttackDamage(float original) {
        return original + (float)this.bettertrims$getCelestialLevel() * this.bettertrims$getCelestial().map(CelestialEffect::getAttackDamage).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Unique
    protected float bettertrims$applyCelestialToAttackSpeed(float original) {
        return original + (float)this.bettertrims$getCelestialLevel() * this.bettertrims$getCelestial().map(CelestialEffect::getAttackSpeed).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    @Unique
    public int bettertrims$applyCelestialToAttackCooldown(int original) {
        return (int)((float)original - (float)this.bettertrims$getCelestialLevel() / this.bettertrims$getCelestial().map(CelestialEffect::getAttackSpeed).orElse(Float.valueOf(1.0f)).floatValue());
    }

    @Unique
    protected int bettertrims$getCelestialLevel() {
        Optional<CelestialEffect> effectOptional = this.bettertrims$getCelestial();
        return effectOptional.map(effect -> (int)this.method_45325(effect.getEntityAttribute())).orElse(0);
    }

    @Unique
    protected Optional<CelestialEffect> bettertrims$getCelestial() {
        if (this.method_37908().method_8530()) {
            return Optional.of(TrimEffects.GOLD);
        }
        if (this.method_37908().method_23886()) {
            return Optional.of(TrimEffects.SILVER);
        }
        if (this.method_37908().method_27983().equals(class_1937.field_25180)) {
            return Optional.of(TrimEffects.GLOWSTONE);
        }
        if (this.method_37908().method_27983().equals(class_1937.field_25181)) {
            return Optional.of(TrimEffects.STARRITE);
        }
        return Optional.empty();
    }
}

