/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.effect;

import com.bawnorton.bettertrims.BetterTrims;
import com.bawnorton.bettertrims.effect.TrimEffect;
import com.bawnorton.bettertrims.effect.attribute.AttributeSettings;
import com.bawnorton.bettertrims.effect.attribute.TrimAttribute;
import com.bawnorton.bettertrims.registry.content.TrimEntityAttributes;
import com.bawnorton.bettertrims.registry.content.TrimStatusEffects;
import com.bawnorton.configurable.Configurable;
import com.bawnorton.configurable.Image;
import com.bawnorton.configurable.OptionType;
import com.bawnorton.configurable.Yacl;
import com.google.common.collect.EvictingQueue;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_6862;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

@Configurable(value="echo_shard", yacl=@Yacl(type={OptionType.GAME_RESTART}, image=@Image(value="minecraft:textures/item/echo_shard.png"), collapsed=true))
public final class EchoShardTrimEffect
extends TrimEffect {
    private final Map<UUID, EvictingQueue<Echo>> entityEchoes = new HashMap<UUID, EvictingQueue<Echo>>();
    @Configurable
    public static boolean enabled = true;

    public EchoShardTrimEffect(class_6862<class_1792> materials) {
        super(materials);
    }

    @Override
    protected void addAttributes(Consumer<TrimAttribute> adder) {
        adder.accept(TrimAttribute.leveled(() -> TrimEntityAttributes.ECHOING));
    }

    @Override
    protected boolean isEnabled() {
        return enabled;
    }

    public void createEcho(class_1309 entity, class_243 pos, float pitch, float yaw, float health) {
        if (entity.method_6059(TrimStatusEffects.DAMPENED)) {
            return;
        }
        Echo echo = new Echo(pos, pitch, yaw, health);
        int echoingLevel = (int)entity.method_45325(TrimEntityAttributes.ECHOING);
        if (echoingLevel <= 0) {
            return;
        }
        int echoCount = echoingLevel * AttributeSettings.Echoing.echoDuration * 20;
        EvictingQueue queue = this.entityEchoes.computeIfAbsent(entity.method_5667(), uuid -> EvictingQueue.create((int)echoCount));
        int maxSize = queue.remainingCapacity() + queue.size();
        if (maxSize != echoCount) {
            EvictingQueue newQueue = EvictingQueue.create((int)echoCount);
            newQueue.addAll((Collection)queue);
            this.entityEchoes.put(entity.method_5667(), (EvictingQueue<Echo>)newQueue);
            queue = newQueue;
        }
        queue.add((Object)echo);
    }

    @Override
    public class_2487 writeNbt(class_1309 entity, class_2487 nbt) {
        EvictingQueue<Echo> queue = this.entityEchoes.get(entity.method_5667());
        if (queue == null) {
            return nbt;
        }
        class_2499 echoes = new class_2499();
        for (Echo echo : queue) {
            DataResult encoded = Echo.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)echo);
            encoded.ifSuccess(arg_0 -> echoes.add(arg_0)).ifError(error -> BetterTrims.LOGGER.error("Failed to encode echo: {}", error));
        }
        nbt.method_10566("echoes", (class_2520)echoes);
        return nbt;
    }

    @Override
    public void readNbt(class_1309 entity, class_2487 nbt) {
        if (!nbt.method_10545("echoes")) {
            return;
        }
        class_2499 echoes = nbt.method_10554("echoes", 10);
        for (class_2520 echoElement : echoes) {
            DataResult decoded = Echo.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)echoElement);
            decoded.ifSuccess(echo -> this.createEcho(entity, echo.pos(), echo.pitch(), echo.yaw(), echo.health())).ifError(error -> BetterTrims.LOGGER.error("Failed to decode echo: {}", error));
        }
    }

    public EvictingQueue<Echo> getEchoes(class_1309 instance) {
        return this.entityEchoes.get(instance.method_5667());
    }

    public record Echo(class_243 pos, float pitch, float yaw, float health) {
        public static final Codec<Echo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_243.field_38277.fieldOf("pos").forGetter(Echo::pos), (App)Codec.FLOAT.fieldOf("pitch").forGetter(Echo::pitch), (App)Codec.FLOAT.fieldOf("yaw").forGetter(Echo::yaw), (App)Codec.FLOAT.fieldOf("health").forGetter(Echo::health)).apply((Applicative)instance, Echo::new));
        public static final class_9139<ByteBuf, Echo> PACKET_CODEC = class_9139.method_56905((class_9139)class_9135.field_48558.method_56432(class_243::new, class_243::method_46409), Echo::pos, (class_9139)class_9135.field_48552, Echo::pitch, (class_9139)class_9135.field_48552, Echo::yaw, (class_9139)class_9135.field_48552, Echo::health, Echo::new);
    }
}

