/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.effect;

import com.bawnorton.bettertrims.effect.TrimEffect;
import com.bawnorton.bettertrims.effect.attribute.AttributeSettings;
import com.bawnorton.bettertrims.effect.attribute.TrimAttribute;
import com.bawnorton.bettertrims.registry.content.TrimEntityAttributes;
import com.bawnorton.configurable.Configurable;
import com.bawnorton.configurable.Image;
import com.bawnorton.configurable.OptionType;
import com.bawnorton.configurable.Yacl;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

@Configurable(value="copper", yacl=@Yacl(type={OptionType.GAME_RESTART}, image=@Image(value="minecraft:textures/item/copper_ingot.png"), collapsed=true))
public final class CopperTrimEffect
extends TrimEffect {
    private final Object2ObjectMap<class_1309, Set<class_2338>> electrified = new Object2ObjectOpenHashMap();
    @Configurable
    public static boolean enabled = true;

    public CopperTrimEffect(class_6862<class_1792> materials) {
        super(materials);
    }

    @Override
    protected void addAttributes(Consumer<TrimAttribute> adder) {
        adder.accept(TrimAttribute.leveled(() -> TrimEntityAttributes.ELECTRIFYING));
    }

    @Override
    protected boolean isEnabled() {
        return enabled;
    }

    public Object2ObjectMap<class_1309, Set<class_2338>> getElectrified() {
        return this.electrified;
    }

    public Optional<class_1309> whoElectrified(class_2338 pos) {
        for (Object2ObjectMap.Entry entry : this.electrified.object2ObjectEntrySet()) {
            class_1309 entity = (class_1309)entry.getKey();
            if (entity.method_31481()) {
                this.electrified.remove((Object)entity);
                return Optional.empty();
            }
            Set electrified = (Set)entry.getValue();
            if (!electrified.contains(pos)) continue;
            return Optional.of(entity);
        }
        return Optional.empty();
    }

    public void clearElectrified(class_1297 entity) {
        if (entity instanceof class_1309) {
            this.electrified.remove((Object)entity);
        }
    }

    @Nullable
    public ElectrifyingInfo electrifyingInfo(class_1309 entity) {
        if (entity.method_45325(TrimEntityAttributes.ELECTRIFYING) <= 0.0) {
            this.clearElectrified((class_1297)entity);
            return null;
        }
        class_1937 world = entity.method_37908();
        if (world == null) {
            return null;
        }
        class_243 pos = entity.method_19538();
        class_2338 blockPos = class_2338.method_49638((class_2374)pos);
        if (!world.method_22351(blockPos)) {
            return null;
        }
        double electrifying = entity.method_45325(TrimEntityAttributes.ELECTRIFYING);
        double maxDist = electrifying * (double)AttributeSettings.Electrifying.radius;
        Predicate<class_243> isWall = vec3d -> {
            boolean waterlogged;
            class_2338 wallPos = class_2338.method_49638((class_2374)vec3d);
            class_2680 state = world.method_8320(wallPos);
            class_3610 fluidState = state.method_26227();
            boolean water = fluidState.method_15767(class_3486.field_15517);
            boolean bl = waterlogged = water && state.method_28500((class_2769)class_2741.field_12508).orElse(false) != false;
            if (waterlogged) {
                return !wallPos.equals((Object)class_2338.method_49638((class_2374)pos));
            }
            return !water;
        };
        return new ElectrifyingInfo(world, pos, maxDist, isWall);
    }

    public record ElectrifyingInfo(class_1937 world, class_243 pos, double maxDist, Predicate<class_243> isWall) {
    }
}

