/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.networking;

import com.bawnorton.bettertrims.effect.EchoShardTrimEffect;
import com.bawnorton.bettertrims.extend.ModifiedTimeHolder;
import com.bawnorton.bettertrims.networking.packet.s2c.EchoTriggeredS2CPacket;
import com.bawnorton.bettertrims.networking.packet.s2c.EntityEchoedS2CPacket;
import com.bawnorton.bettertrims.networking.packet.s2c.StatusEffectDurationModifiedS2CPacket;
import com.bawnorton.bettertrims.registry.content.TrimSoundEvents;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_746;

public final class ClientNetworking {
    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver(StatusEffectDurationModifiedS2CPacket.PACKET_ID, ClientNetworking::handleStatusEffectDurationModified);
        ClientPlayNetworking.registerGlobalReceiver(EchoTriggeredS2CPacket.PACKET_ID, ClientNetworking::handleEchoTriggered);
        ClientPlayNetworking.registerGlobalReceiver(EntityEchoedS2CPacket.PACKET_ID, ClientNetworking::handleEntityEchoed);
    }

    private static void handleStatusEffectDurationModified(StatusEffectDurationModifiedS2CPacket packet, ClientPlayNetworking.Context context) {
        class_746 player = context.player();
        class_1293 effectInstance = player.method_6112(packet.effect());
        if (effectInstance == null) {
            return;
        }
        ((ModifiedTimeHolder)effectInstance).bettertrims$setModifiedTime(packet.modifiedTime());
    }

    private static void handleEchoTriggered(EchoTriggeredS2CPacket packet, ClientPlayNetworking.Context context) {
        EchoShardTrimEffect.Echo echo = packet.echo();
        class_746 player = context.player();
        class_243 pos = echo.pos();
        class_638 world = context.client().field_1687;
        for (int i = 5; i > 0; --i) {
            float pitch = (float)i * 0.1f;
            CompletableFuture.delayedExecutor(50L * (long)i, TimeUnit.MILLISECONDS).execute(() -> context.client().execute(() -> world.method_8396((class_1657)player, class_2338.method_49638((class_2374)pos), TrimSoundEvents.ECHO_REWIND, class_3419.field_15248, 2.0f, pitch)));
        }
    }

    private static void handleEntityEchoed(EntityEchoedS2CPacket packet, ClientPlayNetworking.Context context) {
        EchoShardTrimEffect.Echo echo = packet.echo();
        class_638 world = context.client().field_1687;
        if (world == null) {
            return;
        }
        class_243 oldPos = packet.priorPos();
        class_243 pos = echo.pos();
        class_5819 random = world.method_8409();
        for (int i = 0; i < 50; ++i) {
            float dx = 2.0f * random.method_43057() - 1.0f;
            float dy = 2.0f * random.method_43057() - 1.0f;
            float dz = 2.0f * random.method_43057() - 1.0f;
            world.method_8406((class_2394)class_2398.field_50247, pos.field_1352 + (double)dx, pos.field_1351 + (double)dy, pos.field_1350 + (double)dz, 0.0, 0.0, 0.0);
            world.method_8406((class_2394)class_2398.field_50247, oldPos.field_1352 + (double)dx, oldPos.field_1351 + (double)dy, oldPos.field_1350 + (double)dz, 0.0, 0.0, 0.0);
        }
    }
}

