/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.mixin.attributes.electrifying;

import com.bawnorton.bettertrims.effect.CopperTrimEffect;
import com.bawnorton.bettertrims.registry.content.TrimEffects;
import com.bawnorton.bettertrims.util.FloodFill;
import com.bawnorton.bettertrims.util.Plane;
import com.llamalad7.mixinextras.injector.ModifyReceiver;
import it.unimi.dsi.fastutil.Pair;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4066;
import net.minecraft.class_5574;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={class_638.class})
public abstract class ClientWorldMixin {
    @ModifyReceiver(method={"tickEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/EntityList;forEach(Ljava/util/function/Consumer;)V")})
    private class_5574 applyElectrifying(class_5574 instance, Consumer<class_1297> action) {
        instance.method_31791(entity -> {
            if (!(entity instanceof class_1309)) {
                return;
            }
            class_1309 livingEntity = (class_1309)entity;
            CopperTrimEffect.ElectrifyingInfo info = TrimEffects.COPPER.electrifyingInfo(livingEntity);
            if (info == null) {
                return;
            }
            class_5819 random = info.world().method_8409();
            HashSet<Pair<class_243, class_2350>> walls = new HashSet<Pair<class_243, class_2350>>();
            HashSet<class_243> edges = new HashSet<class_243>();
            FloodFill.hollow(info.pos(), info.maxDist(), new HashSet<class_243>(), walls, edges, info.isWall());
            edges.forEach(edge -> {
                float offsetX = random.method_43057() - 0.5f;
                float offsetY = random.method_43057() - 0.5f;
                float offsetZ = random.method_43057() - 0.5f;
                class_2338 edgeBlockPos = class_2338.method_49638((class_2374)edge);
                float fluidHeight = (float)edgeBlockPos.method_10264() + info.world().method_8316(edgeBlockPos).method_20785();
                this.bettertrims$spawnSpark(random, info.world(), edge.field_1352 + (double)offsetX, fluidHeight + offsetY, edge.field_1350 + (double)offsetZ);
            });
            walls.forEach(pair -> {
                class_243 wall = (class_243)pair.first();
                class_2350 direction = (class_2350)pair.right();
                class_2338 wallPos = class_2338.method_49638((class_2374)wall);
                class_2680 state = info.world().method_8320(wallPos);
                class_265 collisionShape = state.method_26218((class_1922)info.world(), wallPos).method_1096((double)wallPos.method_10263(), (double)wallPos.method_10264(), (double)wallPos.method_10260());
                List boundingBoxes = collisionShape.method_1090();
                if (boundingBoxes.isEmpty()) {
                    class_2338 underWall = wallPos.method_10074();
                    Plane plane = Plane.fromBlockPos(underWall, direction.method_10153());
                    Vector3d randPoint = plane.getRandPointOnPlane();
                    float offsetX = random.method_43057() - 0.5f;
                    float offsetZ = random.method_43057() - 0.5f;
                    float fluidHeight = info.world().method_8316(underWall).method_20785();
                    this.bettertrims$spawnSpark(random, info.world(), randPoint.x + (double)offsetX, randPoint.y + (double)fluidHeight, randPoint.z + (double)offsetZ);
                } else {
                    boundingBoxes.forEach(box -> {
                        Plane plane = Plane.fromSideOfBox(box, direction.method_10153());
                        Vector3d randPoint = plane.getRandPointOnPlane();
                        this.bettertrims$spawnSpark(random, info.world(), randPoint.x, randPoint.y, randPoint.z);
                    });
                }
            });
        });
        return instance;
    }

    @Unique
    private void bettertrims$spawnSpark(class_5819 random, class_1937 world, double x, double y, double z) {
        int threshold = 10 + ((class_4066)class_310.method_1551().field_1690.method_42475().method_41753()).method_7362() * 10;
        if (random.method_43048(threshold) != 0) {
            return;
        }
        float dx = random.method_43057() / 2.0f - 0.25f;
        float dy = random.method_43057() / 2.0f - 0.25f;
        float dz = random.method_43057() / 2.0f - 0.25f;
        world.method_8406((class_2394)class_2398.field_29644, x, y, z, (double)dx, (double)dy, (double)dz);
    }
}

