/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.bundleapi.component.type;

import com.github.theredbrain.bundleapi.BundleAPI;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_5632;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9334;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.Nullable;

public record CustomBundleContentsComponent(Content content, Fraction occupancy, int size_multiplier) implements class_5632
{
    public static final CustomBundleContentsComponent DEFAULT = new CustomBundleContentsComponent(List.of(), 1);
    public static final Codec<CustomBundleContentsComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Content.CODEC.fieldOf("content").forGetter(component -> component.content), (App)Codec.INT.optionalFieldOf("size_multiplier", (Object)1).forGetter(component -> component.size_multiplier)).apply((Applicative)instance, CustomBundleContentsComponent::new));
    public static final class_9139<class_9129, CustomBundleContentsComponent> PACKET_CODEC = class_9139.method_56435(Content.PACKET_CODEC, component -> component.content, (class_9139)class_9135.field_48550, component -> component.size_multiplier, CustomBundleContentsComponent::new);
    private static final Fraction NESTED_BUNDLE_OCCUPANCY = Fraction.getFraction((int)1, (int)16);

    CustomBundleContentsComponent(List<class_1799> stacks, Fraction occupancy, int size_multiplier) {
        this(new Content(stacks), occupancy, size_multiplier);
    }

    CustomBundleContentsComponent(List<class_1799> stacks, int size_multiplier) {
        this(new Content(stacks), CustomBundleContentsComponent.calculateOccupancy(stacks, size_multiplier), size_multiplier);
    }

    public CustomBundleContentsComponent(Content content, int size_multiplier) {
        this(content, CustomBundleContentsComponent.calculateOccupancy(content.stacks, size_multiplier), size_multiplier);
    }

    public CustomBundleContentsComponent(int size_multiplier) {
        this(Content.DEFAULT, size_multiplier);
    }

    public static Builder builder() {
        return new Builder(DEFAULT);
    }

    private static Fraction calculateOccupancy(List<class_1799> stacks, int size_multiplier) {
        Fraction fraction = Fraction.ZERO;
        for (class_1799 itemStack : stacks) {
            fraction = fraction.add(CustomBundleContentsComponent.getOccupancy(itemStack, size_multiplier).multiplyBy(Fraction.getFraction((int)itemStack.method_7947(), (int)1)));
        }
        return fraction;
    }

    static Fraction getOccupancy(class_1799 stack, int size_multiplier) {
        CustomBundleContentsComponent customBundleContentsComponent = (CustomBundleContentsComponent)stack.method_57824(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT);
        if (customBundleContentsComponent != null) {
            return NESTED_BUNDLE_OCCUPANCY.add(customBundleContentsComponent.getOccupancy());
        }
        List list = (List)stack.method_57825(class_9334.field_49624, List.of());
        return !list.isEmpty() ? Fraction.ONE : Fraction.getFraction((int)1, (int)(stack.method_7914() * size_multiplier));
    }

    public class_1799 get(int index) {
        return this.content.stacks.get(index);
    }

    public Stream<class_1799> stream() {
        return this.content.stacks.stream().map(class_1799::method_7972);
    }

    public Iterable<class_1799> iterate() {
        return this.content.stacks;
    }

    public Iterable<class_1799> iterateCopy() {
        return Lists.transform(this.content.stacks, class_1799::method_7972);
    }

    public int size() {
        return this.content.stacks.size();
    }

    public int sizeMultiplier() {
        return this.size_multiplier;
    }

    public Fraction getOccupancy() {
        return this.occupancy;
    }

    public boolean isEmpty() {
        return this.content.stacks.isEmpty();
    }

    public record Content(List<class_1799> stacks) {
        public static final Content DEFAULT = new Content(List.of());
        public static final Codec<Content> CODEC = class_1799.field_24671.listOf().xmap(Content::new, component -> component.stacks);
        public static final class_9139<class_9129, Content> PACKET_CODEC = class_1799.field_48349.method_56433(class_9135.method_56363()).method_56432(Content::new, content -> content.stacks);

        public Content(List<class_1799> stacks) {
            this.stacks = new ArrayList<class_1799>(stacks);
        }
    }

    public static class Builder {
        private Content content;
        private Fraction occupancy;
        private int size_multiplier;

        public Builder(CustomBundleContentsComponent base) {
            this.content = new Content(base.content.stacks);
            this.occupancy = base.occupancy;
            this.size_multiplier = base.size_multiplier;
        }

        public Builder clear() {
            this.content.stacks.clear();
            this.occupancy = Fraction.ZERO;
            return this;
        }

        private int addInternal(class_1799 stack) {
            if (!stack.method_7946()) {
                return -1;
            }
            for (int i = 0; i < this.content.stacks.size(); ++i) {
                if (!class_1799.method_31577((class_1799)this.content.stacks.get(i), (class_1799)stack) || this.content.stacks.get(i).method_7947() >= this.content.stacks.get(i).method_7914()) continue;
                return i;
            }
            return -1;
        }

        private int getMaxAllowed(class_1799 stack) {
            Fraction fraction = Fraction.ONE.subtract(this.occupancy);
            return Math.max(fraction.divideBy(CustomBundleContentsComponent.getOccupancy(stack, this.size_multiplier)).intValue(), 0);
        }

        public int add(class_1799 stack) {
            if (!stack.method_7960() && stack.method_7909().method_31568()) {
                int i = Math.min(stack.method_7947(), this.getMaxAllowed(stack));
                if (i == 0) {
                    return 0;
                }
                this.occupancy = this.occupancy.add(CustomBundleContentsComponent.getOccupancy(stack, this.size_multiplier).multiplyBy(Fraction.getFraction((int)i, (int)1)));
                int j = this.addInternal(stack);
                if (j != -1) {
                    int count;
                    class_1799 itemStack = this.content.stacks.remove(j);
                    int maxCount = itemStack.method_7914();
                    int countDiff = maxCount - (count = itemStack.method_7947());
                    if (i <= countDiff) {
                        class_1799 itemStack2 = itemStack.method_46651(itemStack.method_7947() + i);
                        stack.method_7934(i);
                        this.content.stacks.add(0, itemStack2);
                    } else {
                        class_1799 itemStack2 = itemStack.method_46651(itemStack.method_7947() + countDiff);
                        this.content.stacks.add(0, itemStack2);
                        class_1799 itemStack3 = stack.method_46651(i - countDiff);
                        this.content.stacks.add(0, itemStack3);
                        stack.method_7934(i);
                    }
                } else {
                    this.content.stacks.add(0, stack.method_7971(i));
                }
                return i;
            }
            return 0;
        }

        public int add(class_1735 slot, class_1657 player) {
            class_1799 itemStack = slot.method_7677();
            int i = this.getMaxAllowed(itemStack);
            return this.add(slot.method_32753(itemStack.method_7947(), i, player));
        }

        @Nullable
        public class_1799 removeFirst() {
            if (this.content.stacks.isEmpty()) {
                return null;
            }
            class_1799 itemStack = this.content.stacks.remove(0).method_7972();
            this.occupancy = this.occupancy.subtract(CustomBundleContentsComponent.getOccupancy(itemStack, this.size_multiplier).multiplyBy(Fraction.getFraction((int)itemStack.method_7947(), (int)1)));
            return itemStack;
        }

        public Fraction getOccupancy() {
            return this.occupancy;
        }

        public Builder size_multiplier(int size_multiplier) {
            this.size_multiplier = size_multiplier;
            return this;
        }

        public CustomBundleContentsComponent build() {
            return new CustomBundleContentsComponent(List.copyOf(this.content.stacks), this.occupancy, this.size_multiplier);
        }
    }
}

