/*
 * Decompiled with CFR 0.152.
 */
package fabric.witcher_medallions.items;

import com.google.common.collect.Multimap;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketEnums;
import fabric.witcher_medallions.items.MedallionBaseItem_Fabric;
import fabric.witcher_medallions.items.gecko.WitcherMedallionRenderer;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_583;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;
import witcher_medallions.WitcherMedallions_Main;
import witcher_medallions.items.ActivatedMedallionCommonItem;
import witcher_medallions.registry.WitcherMedallions_Items;
import witcher_medallions.utils.MiscUtil;

public class ActivatedMedallionBaseItem
extends MedallionBaseItem_Fabric
implements ActivatedMedallionCommonItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final String id;
    private final class_124 tooltipColor;
    private final class_2960 SIGN_INTENSITY = class_2960.method_60655((String)"witcher_rpg", (String)"sign_intensity");
    private final class_2960 GENERIC_ATTACK = class_2960.method_60656((String)"generic.attack_damage");
    private final class_2960 ADRENALINE_GAIN = class_2960.method_60655((String)"witcher_rpg", (String)"adrenaline_modifier");
    private final class_2960 GENERIC_ATTACK_SPEED = class_2960.method_60656((String)"generic.attack_speed");
    private final class_2960 KNOCKBACK_RESISTANCE = class_2960.method_60656((String)"generic.knockback_resistance");
    private final class_2960 SPELL_HASTE = class_2960.method_60655((String)"spell_power", (String)"haste");
    private final class_2960 GENERIC_SPEED = class_2960.method_60656((String)"generic.movement_speed");
    private final class_2960 WITCHER_TOXICITY = class_2960.method_60655((String)"tcots_witcher", (String)"generic.witcher_toxicity");

    public ActivatedMedallionBaseItem(class_1792.class_1793 settings, String id, class_124 tooltipColor) {
        super(settings);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
        this.id = id;
        this.tooltipColor = tooltipColor;
    }

    @Override
    public Object getRenderer() {
        return new WitcherMedallionRenderer(this.getId(), false);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void render(class_1799 stack, SlotReference slotReference, class_583<? extends class_1309> contextModel, class_4587 matrices, class_4597 vertexConsumers, int light, class_1309 entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
    }

    protected String getTooltip() {
        return "tooltip.witcher_medallions." + this.id + "_medallion_tooltip";
    }

    protected class_124 getTooltipColor() {
        return this.tooltipColor;
    }

    public void method_7851(@NotNull class_1799 stack, @NotNull class_1792.class_9635 context, List<class_2561> tooltip, @NotNull class_1836 type) {
        tooltip.add((class_2561)class_2561.method_43471((String)(this.getTooltip() + "_1")).method_27692(this.getTooltipColor()));
        tooltip.add((class_2561)class_2561.method_43471((String)(this.getTooltip() + "_2")).method_27692(this.getTooltipColor()));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public TrinketEnums.DropRule getDropRule(class_1799 stack, SlotReference slot, class_1309 entity) {
        if (WitcherMedallions_Main.CONFIG.medallionsHaveSoulbound()) {
            return TrinketEnums.DropRule.KEEP;
        }
        return TrinketEnums.DropRule.DEFAULT;
    }

    public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
        this.method_7888(stack, entity.method_37908(), (class_1297)entity, slot.index(), true);
    }

    public void method_7888(@NotNull class_1799 stack, @NotNull class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (entity.method_37908().field_9236) {
            return;
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (player.witcherMedallionsMod$getHasStrongMagicNear()) {
                this.triggerAnim(entity, stack, "strong");
            } else if (player.witcherMedallionsMod$getHasMagicMobNear()) {
                this.triggerAnim(entity, stack, "swing");
            } else {
                this.triggerAnim(entity, stack, "idle");
            }
        } else {
            this.triggerAnim(entity, stack, "idle");
        }
    }

    public Multimap<class_6880<class_1320>, class_1322> getModifiers(class_1799 stack, SlotReference slot, class_1309 entity, class_2960 slotIdentifier) {
        Multimap modifiers = super.getModifiers(stack, slot, entity, slotIdentifier);
        if (FabricLoader.getInstance().isModLoaded("witcher_rpg")) {
            if (stack.method_31574(WitcherMedallions_Items.Witcher_WolfMedallion()) || stack.method_31574(WitcherMedallions_Items.Witcher_AncientWolfMedallion())) {
                MiscUtil.addMultiplyAttributeTrinket((Multimap<class_6880<class_1320>, class_1322>)modifiers, this.SIGN_INTENSITY, "wolf-sign", 0.05);
                MiscUtil.addMultiplyAttributeTrinket((Multimap<class_6880<class_1320>, class_1322>)modifiers, this.GENERIC_ATTACK, "wolf-damage", 0.02);
            } else if (stack.method_31574(WitcherMedallions_Items.Witcher_CatMedallion())) {
                MiscUtil.addMultiplyAttributeTrinket((Multimap<class_6880<class_1320>, class_1322>)modifiers, this.ADRENALINE_GAIN, "cat-adrenaline", 0.04);
                MiscUtil.addMultiplyAttributeTrinket((Multimap<class_6880<class_1320>, class_1322>)modifiers, this.GENERIC_ATTACK_SPEED, "cat-speed", 0.02);
            } else if (stack.method_31574(WitcherMedallions_Items.Witcher_BearMedallion())) {
                MiscUtil.addMultiplyAttributeTrinket((Multimap<class_6880<class_1320>, class_1322>)modifiers, this.ADRENALINE_GAIN, "bear-adrenaline", 0.05);
                MiscUtil.addMultiplyAttributeTrinket((Multimap<class_6880<class_1320>, class_1322>)modifiers, this.KNOCKBACK_RESISTANCE, "bear-resistance", 0.05);
            } else if (stack.method_31574(WitcherMedallions_Items.Witcher_GriffinMedallion())) {
                MiscUtil.addMultiplyAttributeTrinket((Multimap<class_6880<class_1320>, class_1322>)modifiers, this.SIGN_INTENSITY, "griffin-power", 0.1);
                MiscUtil.addMultiplyAttributeTrinket((Multimap<class_6880<class_1320>, class_1322>)modifiers, this.SPELL_HASTE, "griffin-haste", 0.02);
            } else if (stack.method_31574(WitcherMedallions_Items.Witcher_ViperMedallion())) {
                MiscUtil.addMultiplyAttributeTrinket((Multimap<class_6880<class_1320>, class_1322>)modifiers, this.GENERIC_SPEED, "viper-swiftness", 0.02);
                MiscUtil.addMultiplyAttributeTrinket((Multimap<class_6880<class_1320>, class_1322>)modifiers, this.GENERIC_ATTACK_SPEED, "viper-speed", 0.05);
            } else if (stack.method_31574(WitcherMedallions_Items.Witcher_ManticoreMedallion())) {
                if (FabricLoader.getInstance().isModLoaded("tcots_witcher")) {
                    MiscUtil.addAdditionAttributeTrinket((Multimap<class_6880<class_1320>, class_1322>)modifiers, this.WITCHER_TOXICITY, "manticore-toxicity", 10.0);
                } else {
                    MiscUtil.addMultiplyAttributeTrinket((Multimap<class_6880<class_1320>, class_1322>)modifiers, this.SIGN_INTENSITY, "manticore-magic", 0.02);
                }
                MiscUtil.addMultiplyAttributeTrinket((Multimap<class_6880<class_1320>, class_1322>)modifiers, this.ADRENALINE_GAIN, "manticore-adrenaline", 0.05);
            }
        } else if (FabricLoader.getInstance().isModLoaded("tcots_witcher") && stack.method_31574(WitcherMedallions_Items.Witcher_ManticoreMedallion())) {
            MiscUtil.addAdditionAttributeTrinket((Multimap<class_6880<class_1320>, class_1322>)modifiers, this.WITCHER_TOXICITY, "manticore-toxicity", 10.0);
        }
        return modifiers;
    }
}

