/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.client.fluid.fabric;

import com.teamresourceful.resourcefullib.client.fluid.data.ClientFluidProperties;
import com.teamresourceful.resourcefullib.client.fluid.registry.ResourcefulClientFluidRegistry;
import com.teamresourceful.resourcefullib.common.fluid.data.FluidData;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4588;
import org.jetbrains.annotations.Nullable;

public class ResourcefulFluidRenderHandler
implements FluidRenderHandler {
    protected final class_2960 id;
    protected ClientFluidProperties properties;
    private Function<class_2960, class_1058> spriteCache = id -> {
        throw new IllegalStateException("TextureAtlas not loaded");
    };
    protected class_1058[] sprites;

    private ResourcefulFluidRenderHandler(class_2960 id2) {
        this.id = id2;
        this.sprites = new class_1058[2];
    }

    private ClientFluidProperties properties() {
        if (this.properties == null) {
            this.properties = ResourcefulClientFluidRegistry.get(this.id);
        }
        return this.properties;
    }

    public static void register(class_2960 id, FluidData data) {
        class_3609 still = data.still().get();
        class_3609 flowing = data.flowing().get();
        if (still == null && flowing == null) {
            return;
        }
        FluidRenderHandlerRegistry.INSTANCE.register((class_3611)still, (FluidRenderHandler)new ResourcefulFluidRenderHandler(id));
        FluidRenderHandlerRegistry.INSTANCE.register((class_3611)flowing, (FluidRenderHandler)new ResourcefulFluidRenderHandler(id));
    }

    public class_1058[] getFluidSprites(@Nullable class_1920 view, @Nullable class_2338 pos, class_3610 state) {
        if (this.sprites == null) {
            class_2960 overlay = this.properties().overlay(view, pos, state);
            this.sprites = new class_1058[overlay == null ? 2 : 3];
            this.sprites[0] = this.spriteCache.apply(this.properties().still(view, pos, state));
            this.sprites[1] = this.spriteCache.apply(this.properties().flowing(view, pos, state));
            if (overlay != null) {
                this.sprites[2] = this.spriteCache.apply(overlay);
            }
        }
        return this.sprites;
    }

    public void reloadTextures(class_1059 textureAtlas) {
        this.sprites = null;
        this.spriteCache = arg_0 -> ((class_1059)textureAtlas).method_4608(arg_0);
    }

    public int getFluidColor(@Nullable class_1920 view, @Nullable class_2338 pos, class_3610 state) {
        return this.properties().tintColor(view, pos, state);
    }

    public void renderFluid(class_2338 pos, class_1920 world, class_4588 vertexConsumer, class_2680 blockState, class_3610 fluidState) {
        if (!this.properties().renderFluid(pos, world, vertexConsumer, blockState, fluidState, this.spriteCache)) {
            super.renderFluid(pos, world, vertexConsumer, blockState, fluidState);
        }
    }
}

