/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.mss.world.structures;

import com.finndog.mss.modinit.MSSStructures;
import com.finndog.mss.utils.GeneralUtils;
import com.finndog.mss.world.structures.GenericJigsawStructure;
import com.finndog.mss.world.structures.codecs.YRangeAllowance;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3542;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5434;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6122;
import net.minecraft.class_6626;
import net.minecraft.class_6880;
import net.minecraft.class_7151;
import net.minecraft.class_9822;

public class GenericNetherJigsawStructure
extends GenericJigsawStructure {
    public static final MapCodec<GenericNetherJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GenericNetherJigsawStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)YRangeAllowance.CODEC.optionalFieldOf("y_allowance").forGetter(structure -> structure.yAllowance), (App)class_6122.field_31540.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Codec.BOOL.fieldOf("cannot_spawn_in_liquid").orElse((Object)false).forGetter(structure -> structure.cannotSpawnInLiquid), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius), (App)class_2960.field_25139.listOf().fieldOf("pools_that_ignore_boundaries").orElse(new ArrayList()).xmap(HashSet::new, ArrayList::new).forGetter(structure -> structure.poolsThatIgnoreBoundaries), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.intRange((int)0, (int)100).optionalFieldOf("ledge_offset_y").forGetter(structure -> structure.ledgeOffsetY), (App)class_3542.method_28140(LAND_SEARCH_DIRECTION::values).fieldOf("land_search_direction").forGetter(structure -> structure.searchDirection), (App)Codec.BOOL.fieldOf("use_bounding_box_hack").orElse((Object)false).forGetter(structure -> structure.useBoundingBoxHack), (App)class_9822.field_52239.optionalFieldOf("liquid_settings", (Object)class_5434.field_52235).forGetter(structure -> structure.liquidSettings)).apply((Applicative)instance, GenericNetherJigsawStructure::new));
    public final Optional<Integer> ledgeOffsetY;
    public final LAND_SEARCH_DIRECTION searchDirection;

    public GenericNetherJigsawStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, int size, Optional<YRangeAllowance> yAllowance, class_6122 startHeight, boolean cannotSpawnInLiquid, Optional<Integer> biomeRadius, HashSet<class_2960> poolsThatIgnoreBoundaries, Optional<Integer> maxDistanceFromCenter, Optional<Integer> ledgeOffsetY, LAND_SEARCH_DIRECTION searchDirection, boolean useBoundingBoxHack, class_9822 liquidSettings) {
        super(config, startPool, size, yAllowance, startHeight, Optional.empty(), cannotSpawnInLiquid, Optional.empty(), Optional.empty(), biomeRadius, poolsThatIgnoreBoundaries, maxDistanceFromCenter, Optional.empty(), useBoundingBoxHack, liquidSettings);
        this.ledgeOffsetY = ledgeOffsetY;
        this.searchDirection = searchDirection;
    }

    @Override
    protected void postLayoutAdjustments(class_6626 structurePiecesBuilder, class_3195.class_7149 context, int offsetY, class_2338 blockpos, int topClipOff, int bottomClipOff, List<class_3790> pieces) {
        GeneralUtils.centerAllPieces(blockpos, pieces);
        class_2919 random = new class_2919((class_5819)new class_5820(0L));
        random.method_12663(context.comp_567(), context.comp_568().field_9181, context.comp_568().field_9180);
        class_2338 placementPos = this.searchDirection == LAND_SEARCH_DIRECTION.HIGHEST_LAND ? GeneralUtils.getHighestLand(context.comp_562(), context.comp_564(), structurePiecesBuilder.method_38721(), context.comp_569(), !this.cannotSpawnInLiquid) : GeneralUtils.getLowestLand(context.comp_562(), context.comp_564(), structurePiecesBuilder.method_38721(), context.comp_569(), !this.cannotSpawnInLiquid);
        if (placementPos.method_10264() >= GeneralUtils.getMaxTerrainLimit(context.comp_562()) || placementPos.method_10264() <= context.comp_562().method_16398() + 1) {
            int yDiff = context.comp_562().method_16398() + this.ledgeOffsetY.orElse(0) - pieces.get(0).method_14935().method_35416();
            pieces.forEach(piece -> piece.method_14922(0, yDiff, 0));
        } else {
            int yDiff = placementPos.method_10264() + this.ledgeOffsetY.orElse(0) - pieces.get(0).method_14935().method_35416();
            pieces.forEach(piece -> piece.method_14922(0, yDiff, 0));
        }
        pieces.forEach(piece -> piece.method_14922(0, offsetY, 0));
    }

    @Override
    public class_7151<?> method_41618() {
        return MSSStructures.GENERIC_NETHER_JIGSAW_STRUCTURE.get();
    }

    public static enum LAND_SEARCH_DIRECTION implements class_3542
    {
        HIGHEST_LAND("HIGHEST_LAND"),
        LOWEST_LAND("LOWEST_LAND");

        private final String name;
        private static final Map<String, LAND_SEARCH_DIRECTION> BY_NAME;

        private LAND_SEARCH_DIRECTION(String name) {
            this.name = name;
        }

        public static LAND_SEARCH_DIRECTION byName(String name) {
            return BY_NAME.get(name.toUpperCase(Locale.ROOT));
        }

        public String method_15434() {
            return this.name;
        }

        static {
            BY_NAME = (Map)class_156.method_654((Object)Maps.newHashMap(), hashMap -> {
                LAND_SEARCH_DIRECTION[] var1;
                for (LAND_SEARCH_DIRECTION type : var1 = LAND_SEARCH_DIRECTION.values()) {
                    hashMap.put(type.name, type);
                }
            });
        }
    }
}

