/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.defaultoptions.keys;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.blay09.mods.balm.api.client.keymappings.KeyModifier;
import net.blay09.mods.defaultoptions.DefaultOptions;
import net.blay09.mods.defaultoptions.PlatformBindings;
import net.blay09.mods.defaultoptions.api.DefaultOptionsCategory;
import net.blay09.mods.defaultoptions.api.DefaultOptionsHandler;
import net.blay09.mods.defaultoptions.api.DefaultOptionsLoadStage;
import net.blay09.mods.defaultoptions.keys.DefaultKeyMapping;
import net.blay09.mods.defaultoptions.mixin.KeyMappingAccessor;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;

public class KeyMappingDefaultsHandler
implements DefaultOptionsHandler {
    private static final Pattern KEY_PATTERN = Pattern.compile("key_([^:]+):([^:]+)(?::(.+)?)?");
    private static final Map<String, DefaultKeyMapping> defaultKeys = new HashMap<String, DefaultKeyMapping>();
    private static final List<String> knownKeys = new ArrayList<String>();

    private File getDefaultOptionsFile() {
        return new File(DefaultOptions.getDefaultOptionsFolder(), "keybindings.txt");
    }

    @Override
    public String getId() {
        return "keymappings";
    }

    @Override
    public DefaultOptionsCategory getCategory() {
        return DefaultOptionsCategory.KEYS;
    }

    @Override
    public DefaultOptionsLoadStage getLoadStage() {
        return DefaultOptionsLoadStage.POST_LOAD;
    }

    @Override
    public void saveCurrentOptions() {
        class_310.method_1551().field_1690.method_1640();
    }

    @Override
    public void saveCurrentOptionsAsDefault() {
        try (PrintWriter writer = new PrintWriter(new FileWriter(new File(DefaultOptions.getDefaultOptionsFolder(), "keybindings.txt")));){
            for (class_304 keyMapping : class_310.method_1551().field_1690.field_1839) {
                Set<KeyModifier> keyModifiers = PlatformBindings.INSTANCE.getKeyModifiers(keyMapping);
                writer.println("key_" + keyMapping.method_1431() + ":" + keyMapping.method_1428() + ":" + keyModifiers.stream().map(Enum::name).collect(Collectors.joining(",")));
            }
        }
        catch (Exception e) {
            DefaultOptions.logger.error("Failed to save default key mappings", (Throwable)e);
        }
        this.loadDefaults();
    }

    @Override
    public boolean hasDefaults() {
        return this.getDefaultOptionsFile().exists();
    }

    @Override
    public boolean shouldLoadDefaults() {
        return true;
    }

    @Override
    public void loadDefaults() {
        File knownKeysFile;
        block22: {
            defaultKeys.clear();
            knownKeys.clear();
            File defaultKeysFile = new File(DefaultOptions.getDefaultOptionsFolder(), "keybindings.txt");
            if (defaultKeysFile.exists()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(defaultKeysFile));
                    block16: while (true) {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            Matcher matcher;
                            if (line.isEmpty() || !(matcher = KEY_PATTERN.matcher(line)).matches()) continue;
                            try {
                                String[] keyModifierNames = matcher.group(3) != null ? matcher.group(3).split(",") : new String[]{};
                                Set<KeyModifier> modifiers = Arrays.stream(keyModifierNames).map(KeyModifier::valueOf).collect(Collectors.toSet());
                                defaultKeys.put(matcher.group(1), new DefaultKeyMapping(class_3675.method_15981((String)matcher.group(2)), modifiers));
                                continue block16;
                            }
                            catch (Exception e) {
                                DefaultOptions.logger.error("Error loading default key binding for {}", (Object)line, (Object)e);
                            }
                        }
                        break block22;
                        {
                            continue block16;
                            break;
                        }
                        break;
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (Exception e) {
                    DefaultOptions.logger.error("Error loading default key bindings", (Throwable)e);
                }
            }
        }
        if ((knownKeysFile = new File(DefaultOptions.getMinecraftDataDir(), "knownkeys.txt")).exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(knownKeysFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    knownKeys.add(line);
                }
            }
            catch (Exception e) {
                DefaultOptions.logger.error("Error loading known key bindings", (Throwable)e);
            }
        }
        DefaultOptions.logger.info("Found {} default keys and {} known keys", (Object)defaultKeys.size(), (Object)knownKeys.size());
        for (class_304 keyMapping : class_310.method_1551().field_1690.field_1839) {
            if (!defaultKeys.containsKey(keyMapping.method_1431())) continue;
            DefaultKeyMapping defaultKeyMapping = defaultKeys.get(keyMapping.method_1431());
            ((KeyMappingAccessor)keyMapping).setDefaultKey(defaultKeyMapping.input());
            PlatformBindings.INSTANCE.setDefaultKeyModifiers(keyMapping, defaultKeyMapping.modifiers());
            if (knownKeys.contains(keyMapping.method_1431())) continue;
            Set<KeyModifier> defaultKeyModifiers = PlatformBindings.INSTANCE.getDefaultKeyModifiers(keyMapping);
            PlatformBindings.INSTANCE.setKeyModifiers(keyMapping, defaultKeyModifiers);
            keyMapping.method_1422(keyMapping.method_1429());
            knownKeys.add(keyMapping.method_1431());
        }
        class_304.method_1426();
    }

    @Override
    public void saveAdditional() {
        try (PrintWriter writer = new PrintWriter(new FileWriter(new File(DefaultOptions.getMinecraftDataDir(), "knownkeys.txt")));){
            for (String key : knownKeys) {
                writer.println(key);
            }
        }
        catch (IOException e) {
            DefaultOptions.logger.error("Error saving known key bindings", (Throwable)e);
        }
    }
}

