/*
 * Decompiled with CFR 0.152.
 */
package net.witcher_rpg.mixin;

import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5132;
import net.minecraft.class_6880;
import net.minecraft.class_8103;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.witcher_rpg.effect.Effects;
import net.witcher_rpg.entity.attribute.WitcherAttributes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin {
    @Inject(method={"createLivingAttributes"}, at={@At(value="RETURN")})
    private static void witcher$createLivingAttributes(CallbackInfoReturnable<class_5132.class_5133> cir) {
        ((class_5132.class_5133)cir.getReturnValue()).method_26867(WitcherAttributes.AARD_INTENSITY).method_26867(WitcherAttributes.ADRENALINE_MODIFIER).method_26867(WitcherAttributes.AXII_INTENSITY).method_26867(WitcherAttributes.IGNI_INTENSITY).method_26867(WitcherAttributes.QUEN_INTENSITY).method_26867(WitcherAttributes.YRDEN_INTENSITY).method_26867(WitcherAttributes.SIGN_INTENSITY);
    }

    @Inject(at={@At(value="HEAD")}, method={"isBlocking"}, cancellable=true)
    private void witcherBlockingMechanics(CallbackInfoReturnable<Boolean> info) {
        class_3222 player;
        class_1309 player2 = (class_1309)this;
        if (player2 instanceof class_3222 && (player = (class_3222)player2) instanceof SpellCasterEntity) {
            SpellCasterEntity caster = (SpellCasterEntity)player;
            class_6880.class_6883 spellEntryDefensiveMechanics = SpellRegistry.from((class_1937)player.method_37908()).method_55841(class_2960.method_60655((String)"witcher_rpg", (String)"defensive_witcher_mechanics")).orElse(null);
            Spell spellDefensiveMechanics = (Spell)spellEntryDefensiveMechanics.comp_349();
            class_6880.class_6883 spellEntryWhirl = SpellRegistry.from((class_1937)player.method_37908()).method_55841(class_2960.method_60655((String)"witcher_rpg", (String)"whirl")).orElse(null);
            Spell spellWhirl = (Spell)spellEntryWhirl.comp_349();
            Spell spell = caster.getCurrentSpell();
            if (spell != null && Objects.equals(caster.getCurrentSpell(), spellDefensiveMechanics)) {
                info.setReturnValue((Object)true);
            }
            if (spell != null && Objects.equals(caster.getCurrentSpell(), spellWhirl)) {
                info.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;applyDamage(Lnet/minecraft/entity/damage/DamageSource;F)V")})
    private void applyQuenHealBeforeDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 damagedTarget = (class_1309)this;
        if (damagedTarget.method_31747() && damagedTarget.method_6059(Effects.QUEN_ACTIVE.registryEntry) && !source.method_48789(class_8103.field_42242)) {
            damagedTarget.method_6025(amount / 2.0f);
        }
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;applyDamage(Lnet/minecraft/entity/damage/DamageSource;F)V")})
    private void decreaseAdrenalineAmplifierOnDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 damagedTarget = (class_1309)this;
        if (damagedTarget.method_31747() && damagedTarget.method_6059(Effects.ADRENALINE_GAIN.registryEntry)) {
            int adrenaline_effect_amplifier = damagedTarget.method_6112(Effects.ADRENALINE_GAIN.registryEntry).method_5578();
            int adrenaline_effect_duration = damagedTarget.method_6112(Effects.ADRENALINE_GAIN.registryEntry).method_5584();
            float adrenaline_attribute_player = (float)(damagedTarget.method_45325(WitcherAttributes.ADRENALINE_MODIFIER) - 100.0);
            float random = new Random().nextFloat(100.0f);
            if (adrenaline_effect_amplifier != 0) {
                if (random > adrenaline_attribute_player) {
                    damagedTarget.method_6016(Effects.ADRENALINE_GAIN.registryEntry);
                    damagedTarget.method_6092(new class_1293(Effects.ADRENALINE_GAIN.registryEntry, adrenaline_effect_duration, adrenaline_effect_amplifier - 1, false, false, true));
                }
            } else {
                damagedTarget.method_6016(Effects.ADRENALINE_GAIN.registryEntry);
            }
        }
    }
}

