/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.tickers.entity_tickers;

import einstein.subtle_effects.configs.ModEntityConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.tickers.entity_tickers.EntityTicker;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.SparkType;
import net.minecraft.class_1688;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class MinecartSparksTicker
extends EntityTicker<class_1688> {
    private static final class_243[] WHEEL_POSITIONS = new class_243[]{new class_243(-1.0, 0.0, 1.0), new class_243(1.0, 0.0, 1.0), new class_243(-1.0, 0.0, -1.0), new class_243(1.0, 0.0, -1.0)};
    private int derailedTicks;
    private int sparksTimer;
    private int sparksCount;
    private class_243 deltaMovement;

    public MinecartSparksTicker(class_1688 entity) {
        super(entity);
        this.deltaMovement = entity.method_18798();
    }

    @Override
    public void entityTick() {
        class_243 currentDeltaMovement = ((class_1688)this.entity).method_18798();
        if (currentDeltaMovement.method_10216() == 0.0 && currentDeltaMovement.method_10215() == 0.0) {
            return;
        }
        this.deltaMovement = currentDeltaMovement;
        if (ModConfigs.ENTITIES.minecartSparksDisplayType == ModEntityConfigs.MinecartSparksDisplayType.DEFAULT) {
            this.spawnSparks(10);
            return;
        }
        class_2338 pos = ((class_1688)this.entity).method_24515();
        class_2338 belowPos = pos.method_10074();
        if (this.level.method_8320(belowPos).method_26164(class_3481.field_15463)) {
            pos = belowPos;
        }
        if (class_2241.method_9479((class_1937)this.level, (class_2338)pos)) {
            if (this.derailedTicks >= 10) {
                this.sparksTimer = 40;
                this.sparksCount = 20;
            } else if (this.derailedTicks >= 5) {
                this.sparksTimer = 20;
                this.sparksCount = 5;
            }
            this.derailedTicks = 0;
        } else {
            ++this.derailedTicks;
        }
        if (this.sparksTimer > 0) {
            --this.sparksTimer;
            this.spawnSparks(this.sparksCount);
            return;
        }
        this.sparksCount = 0;
    }

    private void spawnSparks(int count) {
        count = (int)((float)count * ((Float)ModConfigs.ENTITIES.minecartSparksDensity.get()).floatValue());
        double wHalf = ((class_1688)this.entity).method_17681() / 2.0f;
        for (class_243 vec3 : WHEEL_POSITIONS) {
            double xSize = wHalf * vec3.field_1352;
            double zSize = wHalf * vec3.field_1350;
            boolean isXNeg = this.deltaMovement.method_10216() < 0.0;
            boolean isZNeg = this.deltaMovement.method_10215() < 0.0;
            boolean isFrontX = isXNeg == vec3.field_1352 < 0.0;
            boolean isFrontZ = isZNeg == vec3.field_1350 < 0.0;
            double x = ((class_1688)this.entity).method_23317() + (xSize + (this.deltaMovement.method_10216() != 0.0 ? (isFrontX ? -0.03 : 0.3) * (double)(isXNeg ? -1 : 1) : 0.0));
            double z = ((class_1688)this.entity).method_23321() + (zSize + (this.deltaMovement.method_10215() != 0.0 ? (isFrontZ ? -0.03 : 0.3) * (double)(isZNeg ? -1 : 1) : 0.0));
            for (int i = 0; i < count / (isFrontX || isFrontZ ? 2 : 1); ++i) {
                double xSpeed = isFrontX ? 0.0 : (double)class_3532.method_15344((class_5819)this.random, (float)0.1f, (float)0.2f) * (-this.deltaMovement.method_10216() * 1.5);
                double zSpeed = isFrontZ ? 0.0 : (double)class_3532.method_15344((class_5819)this.random, (float)0.1f, (float)0.2f) * (-this.deltaMovement.method_10215() * 1.5);
                this.level.method_8406((class_2394)SparkParticle.create(SparkType.METAL, this.random), x + MathUtil.nextNonAbsDouble(this.random, isFrontX ? 0.1 : 0.05), ((class_1688)this.entity).method_23318(), z + MathUtil.nextNonAbsDouble(this.random, isFrontZ ? 0.1 : 0.05), xSpeed, xSpeed != 0.0 || zSpeed != 0.0 ? (double)class_3532.method_15344((class_5819)this.random, (float)0.1f, (float)0.2f) : 0.0, zSpeed);
            }
        }
    }
}

