/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.tickers.entity_tickers;

import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.compat.CompatHelper;
import einstein.subtle_effects.compat.ItemBordersCompat;
import einstein.subtle_effects.configs.entities.ItemRarityConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModEntityTickers;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.option.IntegerParticleOptions;
import einstein.subtle_effects.platform.Services;
import einstein.subtle_effects.tickers.entity_tickers.EntityTicker;
import einstein.subtle_effects.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.fzzyhmstrs.fzzy_config.validation.minecraft.ValidatedIngredient;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedColor;
import net.minecraft.class_124;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_2394;
import net.minecraft.class_2561;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class ItemRarityTicker
extends EntityTicker<class_1542> {
    private static final class_5251 WHITE_TEXT = class_5251.method_27718((class_124)class_124.field_1068);
    private static final class_6862<class_2874> DIMENSIONS = class_6862.method_40092((class_5321)class_7924.field_41241, (class_2960)SubtleEffects.loc("no_item_rarities"));
    private final List<class_5251> nameColors = new ArrayList<class_5251>();
    private final class_1799 stack = ((class_1542)this.entity).method_6983();
    private final boolean isCommon = this.stack.method_7932() == class_1814.field_8906;

    public ItemRarityTicker(class_1542 entity) {
        super(entity, true);
        this.getItemNameColors();
        if (this.isCommon && ModConfigs.ENTITIES.itemRarity.particlesDisplayType == ItemRarityConfigs.DisplayType.NOT_COMMON && this.nameColors.size() == 1 && this.nameColors.getFirst().equals((Object)WHITE_TEXT)) {
            this.nameColors.clear();
        }
    }

    private void getItemNameColors() {
        class_5251 rarityColor;
        if (this.level.method_40134().method_40220(DIMENSIONS)) {
            return;
        }
        if (!ModConfigs.ENTITIES.itemRarity.colorOverrides.isEmpty()) {
            for (Map.Entry entry : ModConfigs.ENTITIES.itemRarity.colorOverrides.entrySet()) {
                if (!((ValidatedIngredient.IngredientProvider)entry.getKey()).provide().method_8093(this.stack)) continue;
                this.nameColors.add(class_5251.method_27717((int)((ValidatedColor.ColorHolder)entry.getValue()).argb()));
                if (ModConfigs.ENTITIES.itemRarity.mixedColorName) continue;
                break;
            }
            if (ModConfigs.ENTITIES.itemRarity.particleColorType == ItemRarityConfigs.ParticleColorType.ONLY_COLOR_OVERRIDES) {
                return;
            }
        }
        if (ModConfigs.ENTITIES.itemRarity.particleColorType == ItemRarityConfigs.ParticleColorType.NAME_COLOR) {
            boolean usesSingleColor;
            class_2561 hoverName = this.stack.method_7964();
            class_5251 baseColor = hoverName.method_10866().method_10973();
            ArrayList<class_5251> colors = new ArrayList<class_5251>(hoverName.method_10855().stream().map(component -> component.method_10866().method_10973()).filter(Objects::nonNull).toList());
            boolean bl = usesSingleColor = colors.isEmpty() || !ModConfigs.ENTITIES.itemRarity.mixedColorName;
            if (baseColor != null) {
                colors.add(baseColor);
            }
            if (usesSingleColor) {
                class_5251 color;
                Object object = baseColor != null ? baseColor : (color = !colors.isEmpty() ? (class_5251)colors.getFirst() : null);
                if (!(color == null || this.isCommon && color.equals((Object)WHITE_TEXT))) {
                    this.nameColors.add(color);
                    return;
                }
            } else {
                this.nameColors.addAll(colors);
                return;
            }
        }
        if (ModConfigs.ENTITIES.itemRarity.useItemBorder && CompatHelper.IS_ITEM_BORDERS_LOADED.get().booleanValue()) {
            class_5251 borderColor = ItemBordersCompat.getManualBorderColor(this.level, this.stack);
            if (borderColor != null) {
                this.nameColors.add(borderColor);
                return;
            }
            List<class_5251> componentColors = ItemBordersCompat.getNBTBorderColor(this.stack);
            if (!componentColors.isEmpty()) {
                this.nameColors.addAll(componentColors);
                return;
            }
        }
        if ((rarityColor = Services.PARTICLE_HELPER.getRarityColor(this.stack.method_7932())) != null) {
            this.nameColors.add(rarityColor);
            return;
        }
        SubtleEffects.LOGGER.warn("Failed to get item display name color for item: {}", (Object)this.stack.method_7954());
        this.nameColors.add(WHITE_TEXT);
    }

    @Override
    public void entityTick() {
        if (this.nameColors.isEmpty()) {
            return;
        }
        if (ModEntityTickers.shouldSpawn(this.random, ModConfigs.ENTITIES.itemRarity.particleDensity)) {
            this.level.method_8406((class_2394)new IntegerParticleOptions(ModParticles.ITEM_RARITY.get(), (this.nameColors.size() > 1 ? this.nameColors.get(this.random.method_43048(this.nameColors.size())) : this.nameColors.getFirst()).method_27716()), ((class_1542)this.entity).method_23322(1.0), ((class_1542)this.entity).method_23318(), ((class_1542)this.entity).method_23325(1.0), 0.0, MathUtil.nextDouble(this.random, 0.02), 0.0);
        }
    }
}

