/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.tickers;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.init.ModSounds;
import einstein.subtle_effects.particle.option.IntegerParticleOptions;
import einstein.subtle_effects.tickers.Ticker;
import einstein.subtle_effects.tickers.TickerManager;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4770;
import net.minecraft.class_5819;

public class FlameGeyserTicker
extends Ticker {
    public static final List<class_2338> ACTIVE_GEYSERS = new ArrayList<class_2338>();
    public static final List<class_2338> INACTIVE_GEYSERS = new ArrayList<class_2338>();
    public static final List<class_2248> VALID_BLOCKS = List.of(class_2246.field_10515, class_2246.field_23869, class_2246.field_22090);
    private final class_2394 particle;
    private final class_1937 level;
    private final class_2338 pos;
    private final class_5819 random;
    private final int lifeTime;
    private int age;

    public FlameGeyserTicker(class_1937 level, class_2338 pos, class_5819 random) {
        this.level = level;
        this.pos = pos;
        this.random = random;
        this.particle = level.method_23753(pos).method_40225(class_1972.field_22076) ? class_2398.field_22246 : class_2398.field_11240;
        this.lifeTime = this.getTickDelay((Integer)ModConfigs.ENVIRONMENT.flameGeyserActiveTime.get());
        ACTIVE_GEYSERS.add(pos);
    }

    @Override
    public void tick() {
        ++this.age;
        if (this.age >= this.lifeTime) {
            this.remove();
            return;
        }
        if (Util.isChunkLoaded(this.level, this.pos.method_10263(), this.pos.method_10260()) && FlameGeyserTicker.checkLocation(this.level, this.pos, false)) {
            if (this.age == 1) {
                this.level.method_8406((class_2394)new IntegerParticleOptions(ModParticles.GEYSER_HOLE.get(), this.lifeTime), (double)this.pos.method_10263() + 0.5, (double)this.pos.method_10264() + 1.001, (double)this.pos.method_10260() + 0.5, 0.0, 0.0, 0.0);
            }
            if (this.age % 5 == 0) {
                Util.playClientSound(this.pos, ModSounds.GEYSER_WHOOSH.get(), class_3419.field_15245, ((Float)ModConfigs.ENVIRONMENT.flameGeyserSoundVolume.get()).floatValue(), this.random.method_43057() * 0.7f + 0.3f);
            }
            for (int i = 0; i < 10; ++i) {
                this.level.method_8406(this.particle, (double)this.pos.method_10263() + 0.5 + MathUtil.nextNonAbsDouble(this.random, 0.1), (double)this.pos.method_10264() + 1.0625, (double)this.pos.method_10260() + 0.5 + MathUtil.nextNonAbsDouble(this.random, 0.1), MathUtil.nextNonAbsDouble(this.random, 0.01, 0.05), class_3532.method_15366((class_5819)this.random, (double)0.3, (double)0.35), MathUtil.nextNonAbsDouble(this.random, 0.01, 0.05));
            }
            return;
        }
        this.remove();
    }

    public static boolean checkLocation(class_1937 level, class_2338 pos, boolean checkAbove) {
        class_2338 abovePos;
        if (VALID_BLOCKS.contains(level.method_8320(pos).method_26204()) && FlameGeyserTicker.isNotFaceSturdyOrFluidEmpty(level, abovePos = pos.method_10084())) {
            if (checkAbove) {
                for (int i = 1; i < 5; ++i) {
                    if (FlameGeyserTicker.isNotFaceSturdyOrFluidEmpty(level, abovePos.method_10079(class_2350.field_11036, i))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isNotFaceSturdyOrFluidEmpty(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        return !state.method_26206((class_1922)level, pos, class_2350.field_11033) && !(state.method_26204() instanceof class_4770) && level.method_8316(pos).method_15769();
    }

    @Override
    public void remove() {
        super.remove();
        ACTIVE_GEYSERS.remove(this.pos);
        INACTIVE_GEYSERS.add(this.pos);
        TickerManager.schedule(this.getTickDelay((Integer)ModConfigs.ENVIRONMENT.flameGeyserInactiveTime.get()), () -> INACTIVE_GEYSERS.remove(this.pos));
    }

    private int getTickDelay(int max) {
        return max >= 300 ? class_3532.method_15395((class_5819)this.random, (int)(max - 200), (int)max) : max;
    }
}

