/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import einstein.subtle_effects.configs.ModBlockConfigs;
import einstein.subtle_effects.configs.ReplacedParticlesDisplayType;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.tickers.TickerManager;
import einstein.subtle_effects.util.FrustumGetter;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleAccessor;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.Util;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import net.minecraft.class_4604;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_746;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class})
public class LevelRendererMixin
implements FrustumGetter {
    @Shadow
    @Nullable
    private class_638 field_4085;
    @Shadow
    private class_4604 field_27740;
    @Shadow
    @Final
    private class_310 field_4088;

    @WrapOperation(method={"renderSnowAndRain"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/LevelRenderer;RAIN_LOCATION:Lnet/minecraft/resources/ResourceLocation;")})
    private class_2960 replaceRainTexture(Operation<class_2960> original) {
        if (ModConfigs.ENVIRONMENT.biomeColorRain) {
            return Util.COLORLESS_RAIN_TEXTURE;
        }
        return (class_2960)original.call(new Object[0]);
    }

    @WrapOperation(method={"renderSnowAndRain"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/VertexConsumer;setColor(FFFF)Lcom/mojang/blaze3d/vertex/VertexConsumer;")})
    private class_4588 renderSnowAndRain(class_4588 instance, float red, float green, float blue, float alpha, Operation<class_4588> original, @Local class_1959 biome, @Local class_1959.class_1963 precipitation) {
        if (precipitation == class_1959.class_1963.field_9382 && ModConfigs.ENVIRONMENT.biomeColorRain) {
            int waterColor = biome.method_8687();
            return instance.method_22915((float)(waterColor >> 16) / 255.0f, (float)(waterColor >> 8) / 255.0f, (float)waterColor / 255.0f, alpha);
        }
        return (class_4588)original.call(new Object[]{instance, Float.valueOf(red), Float.valueOf(green), Float.valueOf(blue), Float.valueOf(alpha)});
    }

    @Inject(method={"levelEvent"}, at={@At(value="TAIL")})
    private void levelEvent(int type, class_2338 pos, int data, CallbackInfo ci) {
        if (this.field_4085 == null) {
            return;
        }
        class_5819 random = this.field_4085.method_8409();
        class_2680 state = this.field_4085.method_8320(pos);
        class_746 player = this.field_4088.field_1724;
        switch (type) {
            case 1029: {
                if (!ModConfigs.BLOCKS.anvilBreakParticles) break;
                this.field_4085.method_31595(pos, state);
                break;
            }
            case 1030: {
                if (!ModConfigs.BLOCKS.anvilUseParticles) break;
                for (int i = 0; i < 3; ++i) {
                    TickerManager.schedule(8 * i, () -> ParticleSpawnUtil.spawnHammeringWorkstationParticles(pos, random, (class_1937)this.field_4085));
                }
                break;
            }
            case 1042: {
                ParticleSpawnUtil.spawnGrindstoneUsedParticles((class_1937)this.field_4085, pos, state, random);
                break;
            }
            case 1044: {
                if (!ModConfigs.BLOCKS.smithingTableUseParticles) break;
                ParticleSpawnUtil.spawnHammeringWorkstationParticles(pos, random, (class_1937)this.field_4085);
                break;
            }
            case 1503: {
                TickerManager.scheduleNext(() -> ParticleSpawnUtil.spawnEnderEyePlacementParticles(pos, random, (class_1937)this.field_4085, Util.getEyeColorHolder((class_1937)this.field_4085, pos).toInt()));
            }
        }
    }

    @WrapOperation(method={"levelEvent"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/ParticleUtils;spawnParticlesOnBlockFaces(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/particles/ParticleOptions;Lnet/minecraft/util/valueproviders/IntProvider;)V")})
    private void cancelOrReplaceCopperParticles(class_1937 level, class_2338 pos, class_2394 particle, class_6017 count, Operation<Void> original, @Local(argsOnly=true, ordinal=0) int type) {
        class_2680 state = level.method_8320(pos);
        class_5819 random = level.method_8409();
        if (type == 3005) {
            if (ModConfigs.ITEMS.axeScrapeParticlesDisplayType != ReplacedParticlesDisplayType.DEFAULT) {
                LevelRendererMixin.subtleEffects$spawnCopperParticles(level, pos, count, state, random);
            }
            return;
        }
        if (type == 3004) {
            if (ModConfigs.ITEMS.axeWaxOffParticlesDisplayType != ReplacedParticlesDisplayType.DEFAULT) {
                LevelRendererMixin.subtleEffects$spawnCopperParticles(level, pos, count, state, random);
            }
            return;
        }
        original.call(new Object[]{level, pos, particle, count});
    }

    @Unique
    private static void subtleEffects$spawnCopperParticles(class_1937 level, class_2338 pos, class_6017 count, class_2680 state, class_5819 random) {
        ParticleSpawnUtil.spawnParticlesAroundShape((class_2394)class_2398.field_29643, level, pos, state, count.method_35008(random), () -> new class_243(MathUtil.nextNonAbsDouble(random, 0.5), MathUtil.nextNonAbsDouble(random, 0.5), MathUtil.nextNonAbsDouble(random, 0.5)), 0.125f);
    }

    @WrapWithCondition(method={"levelEvent"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V")})
    private boolean shouldSpawnEndPortalFrameSmoke(class_638 level, class_2394 options, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, @Local(argsOnly=true, ordinal=0) int type) {
        if (type == 1503) {
            return ModConfigs.BLOCKS.enderEyePlacedParticlesDisplayType != ModBlockConfigs.EnderEyePlacedParticlesDisplayType.DOTS;
        }
        return true;
    }

    @WrapOperation(method={"levelEvent"}, at={@At(value="FIELD", target="Lnet/minecraft/core/particles/ParticleTypes;LARGE_SMOKE:Lnet/minecraft/core/particles/SimpleParticleType;")})
    private class_2400 replaceSmoke(Operation<class_2400> original) {
        if (ModConfigs.BLOCKS.steam.lavaFizzSteam) {
            return ModParticles.STEAM.get();
        }
        return (class_2400)original.call(new Object[0]);
    }

    @WrapOperation(method={"levelEvent"}, at={@At(value="FIELD", target="Lnet/minecraft/core/particles/ParticleTypes;CLOUD:Lnet/minecraft/core/particles/SimpleParticleType;")})
    private class_2400 replaceCloud(Operation<class_2400> original) {
        if (ModConfigs.BLOCKS.steam.spongeDryingOutSteam) {
            return ModParticles.STEAM.get();
        }
        return (class_2400)original.call(new Object[0]);
    }

    @ModifyReturnValue(method={"addParticleInternal(Lnet/minecraft/core/particles/ParticleOptions;ZZDDDDDD)Lnet/minecraft/client/particle/Particle;"}, at={@At(value="RETURN", ordinal=0)})
    private class_703 spawnForcedParticle(class_703 particle) {
        if (particle != null) {
            ((ParticleAccessor)particle).subtleEffects$force();
        }
        return particle;
    }

    @Override
    public class_4604 subtleEffects$getCullingFrustum() {
        return this.field_27740;
    }
}

