/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1508;
import net.minecraft.class_1510;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.casting.SpellCasterClient;
import net.spell_engine.internals.delivery.Beam;
import net.spell_engine.utils.VectorHelper;
import org.jetbrains.annotations.Nullable;

public class TargetHelper {
    public static class_243 locationFromRayCast(class_1297 caster, float range) {
        class_243 look;
        class_243 end;
        class_243 start = caster.method_33571();
        class_3965 hit = TargetHelper.raycastObstacle(caster, start, end = start.method_1019(look = caster.method_5828(1.0f).method_1029().method_1021((double)range)));
        if (hit.method_17783() == class_239.class_240.field_1332) {
            return hit.method_17784();
        }
        return end;
    }

    public static class_1297 targetFromRaycast(class_1297 caster, float range, Predicate<class_1297> predicate) {
        class_238 searchAABB;
        class_243 look;
        class_243 end;
        class_243 start = caster.method_33571();
        class_3966 hitResult = class_1675.method_18075((class_1297)caster, (class_243)start, (class_243)(end = start.method_1019(look = caster.method_5828(1.0f).method_1029().method_1021((double)range))), (class_238)(searchAABB = caster.method_5829().method_1009((double)range, (double)range, (double)range)), target -> !target.method_7325() && target.method_5863() && predicate.test((class_1297)target), (double)(range * range));
        if (hitResult != null && (hitResult.method_17784() == null || TargetHelper.raycastObstacleFree(caster, start, hitResult.method_17784()))) {
            return hitResult.method_17782();
        }
        return null;
    }

    public static List<class_1297> targetsFromRaycast(class_1297 caster, float range, Predicate<class_1297> predicate) {
        class_243 start = caster.method_33571();
        class_243 look = caster.method_5828(1.0f).method_1029().method_1021((double)range);
        class_243 end = start.method_1019(look);
        class_238 searchAABB = caster.method_5829().method_1009((double)range, (double)range, (double)range);
        List<EntityHit> entitiesHit = TargetHelper.raycastMultiple(caster, start, end, searchAABB, target -> !target.method_7325() && target.method_5863() && predicate.test((class_1297)target), range * range);
        return entitiesHit.stream().filter(hit -> hit.position() == null || TargetHelper.raycastObstacleFree(caster, start, hit.position())).sorted(new Comparator<EntityHit>(){

            @Override
            public int compare(EntityHit hit1, EntityHit hit2) {
                if (hit1.squaredDistanceToSource == hit2.squaredDistanceToSource) {
                    return 0;
                }
                return hit1.squaredDistanceToSource < hit2.squaredDistanceToSource ? -1 : 1;
            }
        }).map(hit -> hit.entity).toList();
    }

    @Nullable
    private static List<EntityHit> raycastMultiple(class_1297 sourceEntity, class_243 min, class_243 max, class_238 searchBox, Predicate<class_1297> predicate, double squaredDistance) {
        class_1937 world = sourceEntity.method_37908();
        double e = squaredDistance;
        ArrayList<EntityHit> entities = new ArrayList<EntityHit>();
        class_243 vec3d = null;
        for (class_1297 entity : world.method_8333(sourceEntity, searchBox, predicate)) {
            class_243 hitPosition;
            double f;
            class_238 box2 = entity.method_5829().method_1014((double)entity.method_5871());
            Optional raycastResult = box2.method_992(min, max);
            if (box2.method_1006(min)) {
                if (!(e >= 0.0)) continue;
                vec3d = raycastResult.orElse(min);
                entities.add(new EntityHit(entity, vec3d, 0.0));
                e = 0.0;
                continue;
            }
            if (!raycastResult.isPresent() || !((f = min.method_1025(hitPosition = (class_243)raycastResult.get())) < e) && e != 0.0) continue;
            if (entity.method_5668() == sourceEntity.method_5668()) {
                if (e != 0.0) continue;
                vec3d = hitPosition;
                entities.add(new EntityHit(entity, vec3d, entity.method_5858(sourceEntity)));
                continue;
            }
            vec3d = hitPosition;
            entities.add(new EntityHit(entity, vec3d, entity.method_5858(sourceEntity)));
        }
        return entities;
    }

    public static List<class_1297> targetsFromArea(class_1297 caster, float range, Spell.Target.Area area, @Nullable Predicate<class_1297> predicate) {
        class_243 origin = caster.method_33571();
        return TargetHelper.targetsFromArea(caster, origin, range, area, predicate);
    }

    public static List<class_1297> targetsFromArea(class_1297 centerEntity, class_243 origin, float range, Spell.Target.Area area, @Nullable Predicate<class_1297> predicate) {
        float horizontal = range * area.horizontal_range_multiplier;
        float vertical = range * area.vertical_range_multiplier;
        class_238 box = centerEntity.method_5829().method_1009((double)(horizontal + 0.5f), (double)(vertical + 0.5f), (double)(horizontal + 0.5f));
        float squaredDistance = range * range;
        class_243 look = centerEntity.method_5720();
        float angle = area.angle_degrees / 2.0f;
        return centerEntity.method_37908().method_8333(centerEntity, box, target -> {
            class_243 targetCenter = target.method_19538().method_1031(0.0, (double)(target.method_17682() / 2.0f), 0.0);
            class_243 distanceVector = VectorHelper.distanceVector(origin, target.method_5829());
            return !target.method_7325() && target.method_5863() && (predicate == null || predicate.test((class_1297)target)) && (range > 1.0f ? targetCenter.method_1025(origin) <= (double)squaredDistance : distanceVector.method_1033() <= (double)range) && (angle <= 0.0f || VectorHelper.angleBetween(look, targetCenter.method_1020(origin)) <= (double)angle || VectorHelper.angleBetween(look, distanceVector) <= (double)angle) && (range < 1.0f || TargetHelper.raycastObstacleFree(centerEntity, origin, targetCenter) || TargetHelper.raycastObstacleFree(centerEntity, origin, origin.method_1019(distanceVector)));
        });
    }

    public static boolean isInLineOfSight(class_1297 attacker, class_1297 target) {
        class_243 origin = attacker.method_33571();
        class_243 targetCenter = target.method_19538().method_1031(0.0, (double)(target.method_17682() / 2.0f), 0.0);
        class_243 distanceVector = VectorHelper.distanceVector(origin, target.method_5829());
        return TargetHelper.raycastObstacleFree(attacker, origin, targetCenter) || TargetHelper.raycastObstacleFree(attacker, origin, origin.method_1019(distanceVector));
    }

    private static class_3965 raycastObstacle(class_1297 entity, class_243 start, class_243 end) {
        return entity.method_37908().method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity));
    }

    private static boolean raycastObstacleFree(class_1297 entity, class_243 start, class_243 end) {
        class_3965 hit = TargetHelper.raycastObstacle(entity, start, end);
        return hit.method_17783() != class_239.class_240.field_1332;
    }

    public static boolean isTargetedByPlayer(class_1297 entity, class_1657 player) {
        if (entity.method_37908().field_9236 && player instanceof SpellCasterClient) {
            SpellCasterClient casterClient = (SpellCasterClient)player;
            List<class_1297> targets = casterClient.getCurrentTargets();
            if (entity instanceof class_1510) {
                class_1510 dragon = (class_1510)entity;
                for (class_1508 part : dragon.method_5690()) {
                    if (!targets.contains(part)) continue;
                    return true;
                }
                return false;
            }
            return targets.contains(entity);
        }
        return false;
    }

    public static Beam.Position castBeam(class_1309 caster, class_243 direction, float max) {
        class_243 start = SpellHelper.launchPoint(caster);
        class_243 end = start.method_1019(direction.method_1021((double)max));
        float length = max;
        boolean hitBlock = false;
        class_3965 hit = caster.method_37908().method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)caster));
        if (hit.method_17783() == class_239.class_240.field_1332) {
            hitBlock = true;
            end = hit.method_17784();
            length = (float)start.method_1022(hit.method_17784());
        }
        return new Beam.Position(start, end, length, hitBlock);
    }

    @Nullable
    public static class_243 findSolidBelow(class_1297 entity, class_243 position, class_1937 world, float height) {
        class_3965 hit = world.method_17742(new class_3959(position, position.method_1031(0.0, (double)height, 0.0), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity));
        if (hit.method_17783() == class_239.class_240.field_1332) {
            return hit.method_17784();
        }
        return null;
    }

    @Nullable
    public static class_243 findSolidBlockBelow(class_1297 entity, class_243 position, class_1937 world, float height) {
        class_3965 hit = world.method_17742(new class_3959(position, position.method_1031(0.0, (double)height, 0.0), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity));
        if (hit.method_17783() == class_239.class_240.field_1332) {
            class_3965 blockHit = hit;
            return new class_243(position.method_10216(), (double)((float)blockHit.method_17777().method_10264() + 1.0f), position.method_10215());
        }
        return null;
    }

    @Nullable
    public static class_243 findTeleportDestination(class_1309 entity, class_243 look, float distance, int clearanceY) {
        class_1937 world = entity.method_37908();
        class_243 start = entity.method_33571();
        class_243 end = start.method_1019(look.method_1021((double)distance));
        class_3965 hit = world.method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)entity));
        class_243 hitPosition = null;
        if (hit.method_17783() == class_239.class_240.field_1333) {
            hitPosition = end;
        }
        if (hit.method_17783() == class_239.class_240.field_1332 && hit.method_17777() != null) {
            hitPosition = hit.method_17784();
        }
        if (hitPosition != null) {
            class_243 inverseLook = look.method_1021(-1.0);
            class_243 paddedHitPosition = hitPosition.method_1019(inverseLook.method_1021(0.5));
            double hitDistance = start.method_1022(paddedHitPosition);
            float reverted = 0.0f;
            while ((double)reverted < hitDistance) {
                class_2338 blockPos = new class_2338((int)paddedHitPosition.method_10216(), (int)paddedHitPosition.method_10214(), (int)paddedHitPosition.method_10215());
                if (TargetHelper.isSafeWithClearance(world, blockPos, clearanceY)) {
                    return paddedHitPosition;
                }
                reverted += 1.0f;
                paddedHitPosition = paddedHitPosition.method_1019(inverseLook);
            }
        }
        return null;
    }

    private static boolean isSafeWithClearance(class_1937 world, class_2338 blockPos, int clearanceY) {
        if (TargetHelper.isSafeTeleportDestination(world, blockPos)) {
            boolean clearanceSafe = true;
            for (int i = 0; i < clearanceY; ++i) {
                class_2338 clearancePos = blockPos.method_10086(i);
                if (TargetHelper.isSafeTeleportDestination(world, clearancePos)) continue;
                clearanceSafe = false;
                break;
            }
            return clearanceSafe;
        }
        return false;
    }

    private static boolean isSafeTeleportDestination(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return !state.method_51367() && !state.method_26228((class_1922)world, pos);
    }

    private record EntityHit(class_1297 entity, class_243 position, double squaredDistanceToSource) {
    }
}

