/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class PatternMatching {
    public static final String TAG_PREFIX = "#";
    public static final String REGEX_PREFIX = "~";
    public static final String NEGATIVE_PREFIX = "!";

    public static <T> boolean matches(class_6880<T> entry, class_5321<class_2378<T>> registryKey, @Nullable String pattern) {
        if (pattern == null) {
            return true;
        }
        if (pattern.startsWith(TAG_PREFIX)) {
            class_6862 tag = class_6862.method_40092(registryKey, (class_2960)class_2960.method_60654((String)pattern.substring(1)));
            return entry.method_40220(tag);
        }
        String id = ((class_5321)entry.method_40230().get()).method_29177().toString();
        if (pattern.startsWith(REGEX_PREFIX)) {
            return PatternMatching.regexMatches(id, pattern.substring(1));
        }
        if (pattern.startsWith(NEGATIVE_PREFIX)) {
            if ((pattern = pattern.substring(1)).isEmpty()) {
                return false;
            }
            return !id.equals(pattern);
        }
        return id.equals(pattern);
    }

    public static boolean regexMatches(String subject, String regex) {
        if (subject == null) {
            return false;
        }
        if (regex == null || regex.isEmpty() || regex.equals("*")) {
            return true;
        }
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(subject);
        return matcher.find();
    }
}

