/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.rpg_series.tags;

import java.util.LinkedHashMap;
import java.util.Locale;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.spell_engine.api.item.Equipment;

public class RPGSeriesItemTags {
    public static final String NAMESPACE = "rpg_series";

    public static class LootTiers {
        public static final int DEFAULT_TIERS = 10;
        public static final String FOLDER = "loot_tier";

        public static class_6862<class_1792> get(int tier, LootCategory category) {
            return class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)LootTiers.id(tier, category));
        }

        public static class_2960 id(int tier, LootCategory category) {
            String name = category.toString().toLowerCase(Locale.ROOT);
            return class_2960.method_60655((String)RPGSeriesItemTags.NAMESPACE, (String)("loot_tier/tier_" + tier + "_" + name));
        }
    }

    public static enum LootCategory {
        WEAPONS,
        ARMORS,
        ACCESSORIES,
        RELICS;

    }

    public static class LootThemes {
        public static final String FOLDER = "loot_theme";
        public static final LinkedHashMap<LootTheme, class_6862<class_1792>> ALL = new LinkedHashMap();

        public static class_6862<class_1792> get(String theme) {
            return class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)LootThemes.id(theme.toLowerCase(Locale.ROOT)));
        }

        public static class_2960 id(LootTheme theme) {
            return LootThemes.id(theme.toString().toLowerCase(Locale.ROOT));
        }

        public static class_2960 id(String theme) {
            return class_2960.method_60655((String)RPGSeriesItemTags.NAMESPACE, (String)("loot_theme/" + theme));
        }

        static {
            for (LootTheme theme : LootTheme.values()) {
                class_2960 id = LootThemes.id(theme.toString().toLowerCase(Locale.ROOT));
                class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)id);
                ALL.put(theme, (class_6862<class_1792>)tag);
            }
        }
    }

    public static enum LootTheme {
        DRAGON,
        AETHER,
        GOLDEN_WEAPON;

    }

    public static class Archetype {
        public static final String FOLDER = "archetype";
        public static final LinkedHashMap<RoleArchetype, class_6862<class_1792>> TAGS = new LinkedHashMap();

        public static class_2960 id(RoleArchetype archetype) {
            return class_2960.method_60655((String)RPGSeriesItemTags.NAMESPACE, (String)("archetype/" + archetype.toString().toLowerCase(Locale.ROOT) + "_weapon"));
        }

        public static String tagString(RoleArchetype archetype) {
            return "#" + String.valueOf(Archetype.id(archetype));
        }

        public static class_6862<class_1792> tag(RoleArchetype archetype) {
            return TAGS.get((Object)archetype);
        }

        public static RoleArchetype classify(Equipment.WeaponType category) {
            switch (category) {
                case DAMAGE_STAFF: 
                case DAMAGE_WAND: 
                case SPELL_SCYTHE: 
                case SPELL_BLADE: {
                    return RoleArchetype.MAGIC_DAMAGE;
                }
                case HEALING_STAFF: 
                case HEALING_WAND: {
                    return RoleArchetype.HEALING;
                }
                case SHORT_BOW: 
                case LONG_BOW: 
                case RAPID_CROSSBOW: 
                case HEAVY_CROSSBOW: {
                    return RoleArchetype.RANGED_DAMAGE;
                }
                case CLAYMORE: 
                case MACE: 
                case HAMMER: 
                case SPEAR: 
                case DAGGER: 
                case SICKLE: 
                case DOUBLE_AXE: 
                case GLAIVE: {
                    return RoleArchetype.MELEE_DAMAGE;
                }
                case SHIELD: {
                    return RoleArchetype.DEFENSE;
                }
            }
            return null;
        }

        static {
            for (RoleArchetype archetype : RoleArchetype.values()) {
                class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Archetype.id(archetype));
                TAGS.put(archetype, (class_6862<class_1792>)tag);
            }
        }
    }

    public static enum RoleArchetype {
        MELEE_DAMAGE,
        RANGED_DAMAGE,
        MAGIC_DAMAGE,
        DEFENSE,
        HEALING;

    }

    public static class ArmorType {
        public static final String FOLDER = "armor_type";
        public static final LinkedHashMap<ArmorMetaType, class_6862<class_1792>> ALL = new LinkedHashMap();

        public static class_2960 id(ArmorMetaType category) {
            return class_2960.method_60655((String)RPGSeriesItemTags.NAMESPACE, (String)("armor_type/" + category.toString().toLowerCase(Locale.ROOT)));
        }

        public static class_6862<class_1792> get(ArmorMetaType category) {
            return ALL.get((Object)category);
        }

        static {
            for (ArmorMetaType category : ArmorMetaType.values()) {
                class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)ArmorType.id(category));
                ALL.put(category, (class_6862<class_1792>)tag);
            }
        }
    }

    public static enum ArmorMetaType {
        MELEE,
        MAGIC,
        ARCHERY;

    }

    public static class WeaponType {
        public static final String FOLDER = "weapon_type";
        public static final LinkedHashMap<Equipment.WeaponType, class_6862<class_1792>> ALL = new LinkedHashMap();

        public static class_6862<class_1792> get(Equipment.WeaponType category) {
            return ALL.get((Object)category);
        }

        static {
            for (Equipment.WeaponType category : Equipment.WeaponType.values()) {
                class_2960 id = class_2960.method_60655((String)RPGSeriesItemTags.NAMESPACE, (String)("weapon_type/" + category.toString().toLowerCase(Locale.ROOT)));
                class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)id);
                ALL.put(category, (class_6862<class_1792>)tag);
            }
        }
    }
}

