/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals.target;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_7924;
import net.spell_engine.api.entity.SpellEntityPredicates;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.target.EntityRelations;
import net.spell_engine.utils.PatternMatching;
import net.spell_engine.utils.TargetHelper;
import org.jetbrains.annotations.Nullable;

public class SpellTarget {
    public static SearchResult findTargets(class_1657 caster, Spell currentSpell, SearchResult previous, boolean filterInvalidTargets) {
        Spell.Target.Aim aim;
        List<Object> targets = List.of();
        List<class_1297> previousTargets = previous.entities;
        class_243 location = null;
        if (currentSpell == null || currentSpell.impacts == null) {
            return new SearchResult(targets, location);
        }
        boolean fallbackToPreviousTargets = false;
        FocusMode focusMode = SpellHelper.focusMode(currentSpell);
        Spell.Target.Type targetType = currentSpell.target.type;
        float range = SpellHelper.getRange(caster, currentSpell) * caster.method_55693();
        Predicate<class_1297> selectionPredicate = target -> {
            Optional<Intent> deliveryIntent = SpellHelper.deliveryIntent(currentSpell);
            boolean intentAllows = deliveryIntent.isPresent() ? EntityRelations.actionAllowed(focusMode, deliveryIntent.get(), (class_1309)caster, target) : false;
            for (Spell.Impact impact : currentSpell.impacts) {
                Intent intent = SpellHelper.impactIntent(impact.action);
                boolean newValue = impact.action.apply_to_caster ? target == caster : EntityRelations.actionAllowed(focusMode, intent, (class_1309)caster, target);
                intentAllows = intentAllows || newValue;
            }
            return !filterInvalidTargets || intentAllows;
        };
        switch (targetType) {
            case NONE: {
                break;
            }
            case CASTER: {
                targets = List.of(caster);
                break;
            }
            case AIM: {
                fallbackToPreviousTargets = currentSpell.target.aim.sticky;
                class_1297 target2 = TargetHelper.targetFromRaycast((class_1297)caster, range, selectionPredicate);
                if (target2 != null) {
                    targets = List.of(target2);
                    break;
                }
                targets = List.of();
                break;
            }
            case BEAM: {
                targets = TargetHelper.targetsFromRaycast((class_1297)caster, range, selectionPredicate);
                break;
            }
            case AREA: {
                targets = TargetHelper.targetsFromArea((class_1297)caster, range, currentSpell.target.area, selectionPredicate);
                Spell.Target.Area area = currentSpell.target.area;
                if (area == null || !area.include_caster) break;
                targets.add(caster);
            }
        }
        if (fallbackToPreviousTargets && targets.isEmpty()) {
            targets = previousTargets.stream().filter(entity -> TargetHelper.isInLineOfSight((class_1297)caster, entity) && !entity.method_31481()).toList();
        }
        if ((aim = currentSpell.target.aim) != null) {
            if (aim.use_caster_as_fallback && targets.isEmpty()) {
                targets = List.of(caster);
            }
            if (!aim.required && targets.isEmpty()) {
                location = TargetHelper.locationFromRayCast((class_1297)caster, range);
            }
        }
        return new SearchResult(targets, location);
    }

    public static boolean evaluate(class_1297 testedEntity, @Nullable class_1297 otherEntity, @Nullable Spell.TargetCondition condition) {
        class_1309 livingEntity;
        float healthPercent;
        if (condition == null) {
            return true;
        }
        if (testedEntity instanceof class_1309 && ((healthPercent = (livingEntity = (class_1309)testedEntity).method_6032() / livingEntity.method_6063()) < condition.health_percent_above || healthPercent > condition.health_percent_below)) {
            return false;
        }
        if (condition.entity_type != null && !PatternMatching.matches(testedEntity.method_5864().method_40124(), class_7924.field_41266, condition.entity_type)) {
            return false;
        }
        if (condition.entity_predicate_id != null) {
            SpellEntityPredicates.Entry predicate = SpellEntityPredicates.get(condition.entity_predicate_id);
            if (predicate == null) {
                return false;
            }
            SpellEntityPredicates.Input args = new SpellEntityPredicates.Input(testedEntity, otherEntity, condition.entity_predicate_param);
            if (!predicate.predicate().test(args)) {
                return false;
            }
        }
        return true;
    }

    public record SearchResult(List<class_1297> entities, @Nullable class_243 location) {
        public static SearchResult empty() {
            return new SearchResult(List.of(), null);
        }

        public static SearchResult of(List<class_1297> entities) {
            return new SearchResult(entities, null);
        }

        public static SearchResult of(class_1297 entity) {
            return new SearchResult(List.of(entity), null);
        }

        public static SearchResult of(class_243 location) {
            return new SearchResult(List.of(), location);
        }
    }

    public static enum FocusMode {
        DIRECT,
        AREA;

    }

    public static enum Intent {
        HELPFUL,
        HARMFUL;

    }
}

