/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals.target;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1530;
import net.minecraft.class_1588;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6025;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.compat.MultipartEntityCompat;
import net.spell_engine.config.ServerConfig;
import net.spell_engine.internals.target.EntityRelation;
import net.spell_engine.internals.target.SpellTarget;
import org.jetbrains.annotations.Nullable;

public class EntityRelations {
    private static Map<class_6862<class_1299<?>>, EntityRelation> RELATION_TAG_CACHE = null;
    private static final Map<String, TeamMatcher> TEAM_MATCHERS = new LinkedHashMap<String, TeamMatcher>();
    private static final boolean[][] TABLE_OF_ULTIMATE_JUSTICE;

    public static EntityRelation getRelation(class_1309 attacker, class_1297 target) {
        Object tameable;
        class_1309 owner;
        ServerConfig config = SpellEngineMod.config;
        if (attacker == target) {
            return config.player_relation_to_self_and_pets;
        }
        if ((target = MultipartEntityCompat.coalesce(target)) instanceof class_6025 && (owner = (tameable = (class_6025)target).method_35057()) != null) {
            return EntityRelations.getRelation(attacker, (class_1297)owner);
        }
        if (target instanceof class_1530) {
            return EntityRelation.NEUTRAL;
        }
        for (TeamMatcher matcher : TEAM_MATCHERS.values()) {
            TeamRelation relation = matcher.getRelation((class_1297)attacker, target);
            if (relation == null) continue;
            return relation.areTeammates() ? (relation.friendlyFireAllowed() ? config.player_relation_to_teammates : EntityRelation.ALLY) : EntityRelation.HOSTILE;
        }
        class_6880 targetTypeEntry = class_7923.field_41177.method_47983((Object)target.method_5864());
        class_2960 id = ((class_5321)targetTypeEntry.method_40230().get()).method_29177();
        EntityRelation mappedRelation = config.player_relations.get(id.toString());
        if (mappedRelation != null) {
            return mappedRelation;
        }
        for (Map.Entry<class_6862<class_1299<?>>, EntityRelation> entry : EntityRelations.getRelationTagsCache().entrySet()) {
            if (!targetTypeEntry.method_40220(entry.getKey())) continue;
            return entry.getValue();
        }
        if (target instanceof class_1296) {
            return EntityRelation.coalesce(config.player_relation_to_passives, EntityRelation.HOSTILE);
        }
        if (target instanceof class_1588) {
            return EntityRelation.coalesce(config.player_relation_to_hostiles, EntityRelation.HOSTILE);
        }
        return EntityRelation.coalesce(config.player_relation_to_other, EntityRelation.HOSTILE);
    }

    private static Map<class_6862<class_1299<?>>, EntityRelation> getRelationTagsCache() {
        if (RELATION_TAG_CACHE == null) {
            RELATION_TAG_CACHE = new HashMap();
            for (Map.Entry<String, EntityRelation> entrySet : SpellEngineMod.config.player_relation_tags.entrySet()) {
                String tagString = entrySet.getKey();
                EntityRelation relation = entrySet.getValue();
                class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)class_2960.method_60654((String)tagString));
                RELATION_TAG_CACHE.put(tag, relation);
            }
        }
        return RELATION_TAG_CACHE;
    }

    public static void registerTeamMatcher(String name, TeamMatcher matcher) {
        TEAM_MATCHERS.put(name, matcher);
    }

    public static boolean actionAllowed(SpellTarget.FocusMode focusMode, SpellTarget.Intent intent, class_1309 attacker, class_1297 target) {
        EntityRelation relation = EntityRelations.getRelation(attacker, target);
        int row = 0;
        if (intent == SpellTarget.Intent.HELPFUL) {
            row += 2;
        }
        if (focusMode == SpellTarget.FocusMode.AREA) {
            ++row;
        }
        int column = 0;
        switch (relation) {
            case ALLY: {
                column = 0;
                break;
            }
            case FRIENDLY: {
                column = 1;
                break;
            }
            case NEUTRAL: {
                column = 2;
                break;
            }
            case HOSTILE: {
                column = 3;
                break;
            }
            case MIXED: {
                column = 4;
            }
        }
        return TABLE_OF_ULTIMATE_JUSTICE[row][column];
    }

    public static boolean allowedToHurt(class_1297 e1, class_1297 e2) {
        class_268 abstractTeam = e1.method_5781();
        class_268 abstractTeam2 = e2.method_5781();
        if (abstractTeam == null) {
            return true;
        }
        return !abstractTeam.method_1206((class_270)abstractTeam2) || abstractTeam.method_1205();
    }

    static {
        EntityRelations.registerTeamMatcher("vanilla", (entity1, entity2) -> {
            class_268 team1 = entity1.method_5781();
            class_268 team2 = entity2.method_5781();
            if (team1 == null || team2 == null) {
                return null;
            }
            boolean friendlyFire = team1.method_1205();
            return new TeamRelation(entity1.method_5722(entity2), friendlyFire);
        });
        TABLE_OF_ULTIMATE_JUSTICE = new boolean[][]{{false, true, true, true, true}, {false, false, false, true, true}, {true, true, true, false, true}, {true, true, false, false, true}};
    }

    public static interface TeamMatcher {
        @Nullable
        public TeamRelation getRelation(class_1297 var1, class_1297 var2);
    }

    public record TeamRelation(boolean areTeammates, boolean friendlyFireAllowed) {
    }
}

