/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals.delivery;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellTriggers;
import net.spell_engine.internals.arrow.ArrowExtension;
import net.spell_engine.internals.delivery.SpellStash;
import net.spell_engine.internals.target.SpellTarget;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;

public class SpellStashHelper {
    public static void init() {
        ServerLifecycleEvents.SERVER_STARTING.register(SpellStashHelper::link);
    }

    private static void link(MinecraftServer minecraftServer) {
        class_5455.class_6890 manager = minecraftServer.method_30611();
        class_2378 registry = manager.method_30530(SpellRegistry.KEY);
        registry.method_40270().forEach(entry -> {
            Spell spell = (Spell)entry.comp_349();
            class_2960 id = ((class_5321)entry.method_40230().get()).method_29177();
            if (spell.deliver.type == Spell.Delivery.Type.STASH_EFFECT) {
                if (spell.deliver.stash_effect == null) {
                    System.err.println("Spell Engine: Stash spell linking error! Spell:" + String.valueOf(id) + " is missing `stash_effect`!");
                    return;
                }
                Spell.Delivery.StashEffect stashEffect = spell.deliver.stash_effect;
                if (stashEffect.id == null || stashEffect.id.isEmpty()) {
                    System.err.println("Spell Engine: Stash spell linking error! Spell:" + String.valueOf(id) + " is missing `stash_effect.id`!");
                    return;
                }
                List<Spell.Trigger> trigger = stashEffect.triggers;
                if (trigger == null || trigger.isEmpty()) {
                    System.err.println("Spell Engine: Stash spell linking error! Spell:" + String.valueOf(id) + " is missing `stash_effect.trigger`!");
                    return;
                }
                class_2960 effectId = class_2960.method_60654((String)stashEffect.id);
                class_1291 statusEffect = (class_1291)class_7923.field_41174.method_10223(effectId);
                if (statusEffect == null) {
                    System.err.println("Spell Engine: Stash spell linking error! Spell:" + String.valueOf(id) + " found no status effect for `stash_effect.id`: " + stashEffect.id);
                    return;
                }
                SpellStash.configure(statusEffect, (class_6880<Spell>)entry, stashEffect.triggers, stashEffect.impact_mode, stashEffect.consume);
            }
        });
    }

    public static void useStashes(SpellTriggers.Event event) {
        class_1657 caster = event.player;
        class_1937 world = caster.method_37908();
        HashMap<class_1293, Integer> updateEffectStacks = new HashMap<class_1293, Integer>();
        Map activeEffects = Map.copyOf(caster.method_6088());
        for (Map.Entry entry : activeEffects.entrySet()) {
            class_1291 effect = (class_1291)((class_6880)entry.getKey()).comp_349();
            class_1293 stack = (class_1293)entry.getValue();
            block5: for (SpellStash.Entry stash : ((SpellStash)effect).getStashedSpells()) {
                class_6880<Spell> spellEntry = stash.spell();
                for (Spell.Trigger trigger : stash.triggers()) {
                    if (spellEntry == null || trigger == null || !SpellTriggers.evaluateTrigger(spellEntry, trigger, event)) continue;
                    int consume = stash.consume();
                    Integer stacksAvailable = updateEffectStacks.getOrDefault(stack, stack.method_5578());
                    if (stacksAvailable + 1 < consume) continue;
                    switch (stash.impactMode()) {
                        case PERFORM: {
                            class_1297 target = event.target(trigger);
                            class_1297 aoeSource = event.aoeSource(trigger);
                            Spell spell = (Spell)stash.spell().comp_349();
                            SpellPower.Result power = SpellPower.getSpellPower((SpellSchool)spell.school, (class_1309)event.player);
                            SpellHelper.ImpactContext impactContext = new SpellHelper.ImpactContext(1.0f, 1.0f, null, power, SpellTarget.FocusMode.DIRECT, 0);
                            impactContext = target != null ? impactContext.position(target.method_19538()) : (aoeSource != null ? impactContext.position(aoeSource.method_19538()) : impactContext.position(caster.method_19538()));
                            SpellHelper.performImpacts(world, (class_1309)caster, target, aoeSource, spellEntry, ((Spell)spellEntry.comp_349()).impacts, impactContext);
                            break;
                        }
                        case TRANSFER: {
                            ArrowExtension arrow = event.arrow;
                            if (arrow == null || ((Spell)spellEntry.comp_349()).arrow_perks == null) break;
                            arrow.applyArrowPerks(spellEntry);
                        }
                    }
                    if (consume == 0) continue block5;
                    updateEffectStacks.put(stack, stacksAvailable - consume);
                    continue block5;
                }
            }
        }
        for (Map.Entry entry : updateEffectStacks.entrySet()) {
            class_1293 instance = (class_1293)entry.getKey();
            Integer newAmplifier = (Integer)entry.getValue();
            class_6880 effect = instance.method_5579();
            caster.method_6016(effect);
            if (newAmplifier < 0) continue;
            caster.method_6092(new class_1293(effect, instance.method_5584(), newAmplifier.intValue(), instance.method_5591(), instance.method_5581(), instance.method_5592()));
        }
    }
}

