/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_engine.api.spell.registry.SpellRegistry;
import org.jetbrains.annotations.Nullable;

public class SpellContainerSource {
    public static final List<Entry> sources = new ArrayList<Entry>();
    public static final Entry MAIN_HAND = SpellContainerSource.entry("main_hand", (player, sourceName) -> {
        class_1799 heldItemStack = player.method_6047();
        ArrayList<SourcedContainer> sources = new ArrayList<SourcedContainer>();
        SpellContainerSource.addSourceIfValid(heldItemStack, sources, sourceName);
        return sources;
    });
    public static final Entry OFF_HAND = new Entry("off_hand", (player, sourceName) -> {
        class_1799 offhandStack = player.method_6079();
        ArrayList<SourcedContainer> sources = new ArrayList<SourcedContainer>();
        SpellContainerSource.addSourceIfValid(offhandStack, sources, sourceName);
        return sources;
    }, player -> player.method_6079());
    public static final Entry EQUIPMENT = new Entry("equipment", (player, sourceName) -> {
        ArrayList<SourcedContainer> sources = new ArrayList<SourcedContainer>();
        if (SpellEngineMod.config.spell_container_from_equipment) {
            for (class_1799 slot : player.method_31548().field_7548) {
                SpellContainerSource.addSourceIfValid(slot, sources, sourceName);
            }
        }
        return sources;
    }, player -> List.of((class_1799)player.method_31548().field_7548.get(0), (class_1799)player.method_31548().field_7548.get(1), (class_1799)player.method_31548().field_7548.get(2), (class_1799)player.method_31548().field_7548.get(3)));

    public static SpellContainer activeContainerOf(class_1657 player) {
        return ((Owner)player).getSpellContainers().activeContainer;
    }

    public static List<class_6880<Spell>> activeSpellsOf(class_1657 player) {
        return ((Owner)player).getSpellContainers().actives;
    }

    public static List<class_6880<Spell>> passiveSpellsOf(class_1657 player) {
        return ((Owner)player).getSpellContainers().passives;
    }

    public static Result getSpellsOf(class_1657 player) {
        return ((Owner)player).getSpellContainers();
    }

    public static void setDirty(class_1657 player, Entry source) {
        SpellContainerSource.setDirty(player, source.name());
    }

    public static void setDirty(class_1657 player, String source) {
        ((Owner)player).spellContainerCache().remove(source);
    }

    private static Entry entry(String name, Source source) {
        return SpellContainerSource.entry(name, source, null);
    }

    private static Entry entry(String name, Source source, @Nullable DirtyChecker dirtyChecker) {
        Entry newEntry = new Entry(name, source, dirtyChecker);
        sources.add(newEntry);
        return newEntry;
    }

    private static void addSourceIfValid(class_1799 fromItemStack, List<SourcedContainer> sources, String name) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(fromItemStack);
        if (container != null && container.isValid()) {
            sources.add(new SourcedContainer(name, fromItemStack, container));
        }
    }

    public static void addSource(Entry entry) {
        sources.add(entry);
    }

    public static void addSource(Entry entry, @Nullable String after) {
        boolean added = false;
        if (after != null) {
            int index = -1;
            for (int i = 0; i < sources.size(); ++i) {
                if (!sources.get(i).name().equals(after)) continue;
                index = i;
                break;
            }
            if (index != -1) {
                sources.add(index + 1, entry);
                added = true;
            }
        }
        if (!added) {
            sources.add(entry);
        }
    }

    public static void init() {
        if (SpellEngineMod.config.spell_container_from_offhand) {
            SpellContainerSource.addSource(OFF_HAND);
        }
        if (SpellEngineMod.config.spell_container_from_equipment) {
            SpellContainerSource.addSource(EQUIPMENT);
        }
    }

    public static void update(class_1657 player) {
        Owner owner = (Owner)player;
        ArrayList<SourcedContainer> allContainers = new ArrayList<SourcedContainer>();
        boolean updated = false;
        if (SpellEngineMod.config.spell_container_caching) {
            for (Entry entry : sources) {
                if (owner.spellContainerCache().containsKey(entry.name())) {
                    allContainers.addAll((Collection)owner.spellContainerCache().get(entry.name()));
                    continue;
                }
                freshContainers = entry.source().getSpellContainers(player, entry.name());
                allContainers.addAll(freshContainers);
                owner.spellContainerCache().put(entry.name(), freshContainers);
                updated = true;
            }
        } else {
            for (Entry entry : sources) {
                freshContainers = entry.source().getSpellContainers(player, entry.name());
                allContainers.addAll(freshContainers);
            }
            updated = true;
        }
        if (updated) {
            class_1799 heldItemStack = player.method_6047();
            SpellContainer heldContainer = SpellContainerHelper.containerFromItemStack(heldItemStack);
            SpellContainer activeContainer = SpellContainer.EMPTY;
            List<class_6880<Spell>> activeSpells = List.of();
            if (heldContainer != null && heldContainer.is_proxy()) {
                MergeResult merged = SpellContainerSource.mergedContainerSources(allContainers, heldContainer.is_proxy(), heldContainer.content(), Spell.Type.ACTIVE, player.method_37908());
                activeContainer = merged.container();
                activeSpells = merged.spells();
            }
            List<class_6880<Spell>> passiveSpells = SpellContainerSource.mergedContainerSources(allContainers, null, Spell.Type.PASSIVE, player.method_37908());
            ((Owner)player).setSpellContainers(new Result(activeContainer, activeSpells, passiveSpells, allContainers));
        }
    }

    public static List<class_6880<Spell>> mergedContainerSources(List<SourcedContainer> sources, @Nullable SpellContainer.ContentType contentType, Spell.Type type, class_1937 world) {
        if (sources.isEmpty()) {
            return List.of();
        }
        ArrayList<class_6880<Spell>> spells = new ArrayList<class_6880<Spell>>();
        class_2378<Spell> registry = SpellRegistry.from(world);
        for (SourcedContainer source : sources) {
            SpellContainer spellContainer = source.container();
            if (type == Spell.Type.ACTIVE && source.name.equals("off_hand") && !SpellEngineMod.config.spell_container_from_offhand_any && !spellContainer.slotMatches(class_1304.field_6171.method_15434()) || !spellContainer.contentMatches(contentType)) continue;
            for (String idString : spellContainer.spell_ids()) {
                class_2960 id = class_2960.method_60654((String)idString);
                class_6880.class_6883 spell = registry.method_55841(id).orElse(null);
                if (spell == null || ((Spell)spell.comp_349()).type != type) continue;
                spells.add((class_6880<Spell>)spell);
            }
        }
        HashSet<class_6880<Spell>> toRemove = new HashSet<class_6880<Spell>>();
        for (class_6880 class_68802 : spells) {
            Spell spell = (Spell)class_68802.comp_349();
            String tag = spell.group;
            if (tag == null) continue;
            for (class_6880<Spell> other : spells) {
                class_2960 otherId;
                class_2960 spellId = ((class_5321)class_68802.method_40230().get()).method_29177();
                if (spellId.equals((Object)(otherId = ((class_5321)other.method_40230().get()).method_29177())) || !tag.equals(((Spell)other.comp_349()).group)) continue;
                if (((Spell)class_68802.comp_349()).tier == ((Spell)other.comp_349()).tier && ((Spell)class_68802.comp_349()).sub_tier > ((Spell)other.comp_349()).sub_tier) {
                    toRemove.add(other);
                }
                if (((Spell)class_68802.comp_349()).tier <= ((Spell)other.comp_349()).tier) continue;
                toRemove.add(other);
            }
        }
        spells.removeAll(toRemove);
        return spells;
    }

    public static MergeResult mergedContainerSources(List<SourcedContainer> sources, boolean proxy, @Nullable SpellContainer.ContentType contentType, Spell.Type type, class_1937 world) {
        if (sources.isEmpty()) {
            return MergeResult.EMPTY;
        }
        List<class_6880<Spell>> spells = SpellContainerSource.mergedContainerSources(sources, contentType, type, world);
        LinkedHashSet<String> spellIds = new LinkedHashSet<String>();
        for (class_6880<Spell> spell : spells) {
            spellIds.add(((class_5321)spell.method_40230().get()).method_29177().toString());
        }
        SpellContainer.ContentType finalContentType = contentType != null ? contentType : SpellContainer.ContentType.MAGIC;
        SpellContainer container = new SpellContainer(finalContentType, proxy, null, 0, new ArrayList<String>(spellIds));
        return new MergeResult(container, spells);
    }

    @Nullable
    public static SourcedContainer getFirstSourceOfSpell(class_2960 spellId, class_1657 player) {
        Result result = ((Owner)player).getSpellContainers();
        for (SourcedContainer source : result.sources()) {
            if (!SpellContainerSource.contains(source.container(), spellId)) continue;
            return source;
        }
        return null;
    }

    private static boolean contains(SpellContainer container, class_2960 spellId) {
        return container != null && container.spell_ids().contains(spellId.toString());
    }

    public static interface Owner {
        public Map<String, List<SourcedContainer>> spellContainerCache();

        public void setSpellContainers(Result var1);

        public Result getSpellContainers();
    }

    public record Result(SpellContainer activeContainer, List<class_6880<Spell>> actives, List<class_6880<Spell>> passives, List<SourcedContainer> sources) {
        public static final Result EMPTY = new Result(SpellContainer.EMPTY, List.of(), List.of(), List.of());
    }

    public record Entry(String name, Source source, @Nullable DirtyChecker checker) {
    }

    public static interface Source {
        public List<SourcedContainer> getSpellContainers(class_1657 var1, String var2);
    }

    public static interface DirtyChecker {
        public Object current(class_1657 var1);
    }

    public record SourcedContainer(String name, class_1799 itemStack, SpellContainer container) {
    }

    public record MergeResult(SpellContainer container, List<class_6880<Spell>> spells) {
        public static final MergeResult EMPTY = new MergeResult(SpellContainer.EMPTY, List.of());
    }
}

