/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals;

import com.google.common.base.Suppliers;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.effect.EntityImmunity;
import net.spell_engine.api.effect.StatusEffectClassification;
import net.spell_engine.api.entity.SpellEntity;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.event.SpellEvents;
import net.spell_engine.api.spell.event.SpellHandlers;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.api.tags.SpellEngineEntityTags;
import net.spell_engine.entity.ConfigurableKnockback;
import net.spell_engine.entity.SpellCloud;
import net.spell_engine.entity.SpellProjectile;
import net.spell_engine.fx.ParticleHelper;
import net.spell_engine.internals.Ammo;
import net.spell_engine.internals.SpellCooldownManager;
import net.spell_engine.internals.SpellTriggers;
import net.spell_engine.internals.arrow.ArrowHelper;
import net.spell_engine.internals.casting.SpellBatcher;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCastSyncHelper;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.internals.container.SpellContainerSource;
import net.spell_engine.internals.target.EntityRelations;
import net.spell_engine.internals.target.SpellTarget;
import net.spell_engine.utils.AnimationHelper;
import net.spell_engine.utils.AttributeModifierUtil;
import net.spell_engine.utils.ItemCooldownManagerExtension;
import net.spell_engine.utils.PatternMatching;
import net.spell_engine.utils.SoundHelper;
import net.spell_engine.utils.TargetHelper;
import net.spell_engine.utils.VectorHelper;
import net.spell_engine.utils.WorldScheduler;
import net.spell_power.api.SpellDamageSource;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import org.jetbrains.annotations.Nullable;

public class SpellHelper {
    public static float launchPointOffsetDefault = 0.5f;
    private static final float knockbackDefaultStrength = 0.4f;

    public static SpellCast.Attempt attemptCasting(class_1657 player, class_1799 itemStack, class_2960 spellId) {
        return SpellHelper.attemptCasting(player, itemStack, spellId, true);
    }

    public static SpellCast.Attempt attemptCasting(class_1657 player, class_1799 itemStack, class_2960 spellId, boolean checkAmmo) {
        Ammo.Result ammoResult;
        SpellCasterEntity caster = (SpellCasterEntity)player;
        class_6880.class_6883 spellEntry = SpellRegistry.from(player.method_37908()).method_55841(spellId).orElse(null);
        if (spellEntry == null) {
            return SpellCast.Attempt.none();
        }
        Spell spell = (Spell)spellEntry.comp_349();
        if (caster.getCooldownManager().isCoolingDown(spellId)) {
            return SpellCast.Attempt.failOnCooldown(new SpellCast.Attempt.OnCooldownInfo());
        }
        if (checkAmmo && !(ammoResult = Ammo.ammoForSpell(player, spell, itemStack)).satisfied()) {
            return SpellCast.Attempt.failMissingItem(new SpellCast.Attempt.MissingItemInfo(ammoResult.item()));
        }
        return SpellCast.Attempt.success();
    }

    public static float hasteAffectedValue(float value, float haste) {
        return value / haste;
    }

    public static float hasteAffectedValue(class_1309 caster, SpellSchool school, float value) {
        return SpellHelper.hasteAffectedValue(caster, school, value, null);
    }

    public static float hasteAffectedValue(class_1309 caster, SpellSchool school, float value, class_1799 provisionedWeapon) {
        float haste = SpellPower.getHaste((class_1309)caster, (SpellSchool)school);
        return SpellHelper.hasteAffectedValue(value, haste);
    }

    public static float getRange(class_1657 player, Spell spell) {
        if (spell.range_mechanic != null) {
            switch (spell.range_mechanic) {
                case MELEE: {
                    return (float)player.method_55755() + spell.range;
                }
            }
        }
        return spell.range;
    }

    public static float getCastDuration(class_1309 caster, Spell spell) {
        return SpellHelper.getCastDuration(caster, spell, null);
    }

    public static float getCastDuration(class_1309 caster, Spell spell, class_1799 provisionedWeapon) {
        if (spell.active != null && spell.active.cast == null) {
            return 0.0f;
        }
        return SpellHelper.hasteAffectedValue(caster, spell.school, spell.active.cast.duration, provisionedWeapon);
    }

    public static SpellCast.Duration getCastTimeDetails(class_1309 caster, Spell spell) {
        if (spell.active == null) {
            return SpellCast.Duration.EMPTY;
        }
        float haste = spell.active.cast.haste_affected ? SpellPower.getHaste((class_1309)caster, (SpellSchool)spell.school) : 1.0f;
        float duration = SpellHelper.hasteAffectedValue(spell.active.cast.duration, haste);
        return new SpellCast.Duration(haste, Math.round(duration * 20.0f));
    }

    public static float getCooldownDuration(class_1309 caster, Spell spell) {
        return SpellHelper.getCooldownDuration(caster, spell, null);
    }

    public static float getCooldownDuration(class_1309 caster, Spell spell, class_1799 provisionedWeapon) {
        float duration = spell.cost.cooldown.duration;
        if (duration > 0.0f && SpellEngineMod.config.haste_affects_cooldown && spell.cost.cooldown.haste_affected) {
            duration = SpellHelper.hasteAffectedValue(caster, spell.school, spell.cost.cooldown.duration, provisionedWeapon);
        }
        return duration;
    }

    public static boolean isChanneled(Spell spell) {
        return SpellHelper.channelValueMultiplier(spell) != 0.0f;
    }

    public static boolean isInstant(Spell spell) {
        if (spell.active == null) {
            return true;
        }
        return spell.active.cast.duration == 0.0f;
    }

    public static float channelValueMultiplier(Spell spell) {
        if (spell.active == null) {
            return 0.0f;
        }
        int ticks = spell.active.cast.channel_ticks;
        if (ticks <= 0) {
            return 0.0f;
        }
        return (float)ticks / 20.0f;
    }

    public static void startCasting(class_1657 player, class_2960 spellId, float speed, int length) {
        class_6880.class_6883 spellEntry = SpellRegistry.from(player.method_37908()).method_55841(spellId).orElse(null);
        if (spellEntry == null) {
            return;
        }
        Spell spell = (Spell)spellEntry.comp_349();
        if (spell.active == null) {
            return;
        }
        class_1799 itemStack = player.method_6047();
        SpellCast.Attempt attempt = SpellHelper.attemptCasting(player, itemStack, spellId);
        if (!attempt.isSuccess()) {
            return;
        }
        SpellCast.Process process = new SpellCast.Process((class_6880<Spell>)spellEntry, itemStack.method_7909(), speed, length, player.method_37908().method_8510());
        SpellCastSyncHelper.setCasting(player, process);
        SoundHelper.playSound(player.method_37908(), (class_1297)player, spell.active.cast.start_sound);
    }

    public static void performSpell(class_1937 world, class_1657 player, class_6880<Spell> spellEntry, SpellTarget.SearchResult targetResult, SpellCast.Action action, float progress) {
        if (player.method_7325()) {
            return;
        }
        Spell spell = (Spell)spellEntry.comp_349();
        class_2960 spellId = ((class_5321)spellEntry.method_40230().get()).method_29177();
        class_1799 heldItemStack = player.method_6047();
        SpellContainerSource.SourcedContainer spellSource = SpellContainerSource.getFirstSourceOfSpell(spellId, player);
        if (spellSource == null) {
            return;
        }
        SpellCast.Attempt attempt = SpellHelper.attemptCasting(player, heldItemStack, spellId);
        if (!attempt.isSuccess()) {
            return;
        }
        SpellCasterEntity caster = (SpellCasterEntity)player;
        List<class_1297> targets = targetResult.entities();
        float castingSpeed = caster.getCurrentCastingSpeed();
        progress = Math.max(Math.min(progress, 1.0f), 0.0f);
        float channelMultiplier = 1.0f;
        int channelTickIndex = 0;
        int incrementChannelTicks = 0;
        boolean shouldPerformImpact = true;
        com.google.common.base.Supplier trackingPlayers = Suppliers.memoize(() -> PlayerLookup.tracking((class_1297)player));
        switch (action) {
            case CHANNEL: {
                channelTickIndex = caster.getChannelTickIndex();
                incrementChannelTicks = 1;
                channelMultiplier = SpellHelper.channelValueMultiplier(spell);
                break;
            }
            case RELEASE: {
                if (SpellHelper.isChanneled(spell)) {
                    shouldPerformImpact = false;
                    channelMultiplier = 1.0f;
                } else {
                    channelMultiplier = progress >= 1.0f ? 1.0f : 0.0f;
                }
                SpellCastSyncHelper.clearCasting(player);
                break;
            }
        }
        Ammo.Result ammoResult = Ammo.ammoForSpell(player, spell, heldItemStack);
        if (channelMultiplier > 0.0f && ammoResult.satisfied()) {
            Spell.Target targeting = spell.target;
            boolean finished = action == SpellCast.Action.RELEASE || action == SpellCast.Action.TRIGGER && spell.type == Spell.Type.PASSIVE;
            boolean success = true;
            if (targeting.cap > 0) {
                targets = targets.stream().sorted(Comparator.comparingDouble(target -> target.method_5707(player.method_19538()))).limit(targeting.cap).toList();
            }
            Consumer<DeliveryCompletion> completion = null;
            if (finished) {
                float finalProgress = progress;
                List<class_1297> finalTargets = targets;
                completion = arg_0 -> SpellHelper.lambda$performSpell$3(player, spell, world, (Supplier)trackingPlayers, castingSpeed, finalProgress, spellSource, spellId, heldItemStack, ammoResult, spellEntry, finalTargets, action, arg_0);
            }
            if (shouldPerformImpact) {
                success = false;
                ImpactContext context = new ImpactContext(channelMultiplier, 1.0f, null, SpellPower.getSpellPower((SpellSchool)spell.school, (class_1309)player), SpellHelper.focusMode(spell), channelTickIndex);
                switch (targeting.type) {
                    case NONE: {
                        success = SpellHelper.deliver(world, spellEntry, player, List.of(), context, null, completion);
                        break;
                    }
                    case CASTER: {
                        List<DeliveryTarget> targetsWithContext = List.of(new DeliveryTarget((class_1297)player, context));
                        success = SpellHelper.deliver(world, spellEntry, player, targetsWithContext, context, null, completion);
                        break;
                    }
                    case AIM: {
                        Spell.Target.Aim aim = targeting.aim;
                        Optional firstTarget = targets.stream().findFirst();
                        List<DeliveryTarget> targetsWithContext = List.of();
                        if (firstTarget.isPresent()) {
                            class_1297 target2 = (class_1297)firstTarget.get();
                            ImpactContext targetSpecificContext = context;
                            targetsWithContext = List.of(new DeliveryTarget(target2, targetSpecificContext));
                        }
                        if (aim.required && !firstTarget.isPresent()) break;
                        success = SpellHelper.deliver(world, spellEntry, player, targetsWithContext, context, targetResult.location(), completion);
                        break;
                    }
                    case AREA: {
                        class_243 center = player.method_19538().method_1031(0.0, (double)(player.method_17682() / 2.0f), 0.0);
                        Spell.Target.Area area = spell.target.area;
                        float range = SpellHelper.getRange(player, spell) * player.method_55693();
                        ImpactContext centeredContext = context;
                        double squaredRange = range * range;
                        List<DeliveryTarget> targetsWithContext = targets.stream().map(target -> {
                            float distanceBasedMultiplier = 1.0f;
                            switch (area.distance_dropoff) {
                                case NONE: {
                                    break;
                                }
                                case SQUARED: {
                                    distanceBasedMultiplier = (float)((squaredRange - target.method_5707(center)) / squaredRange);
                                    distanceBasedMultiplier = Math.max(distanceBasedMultiplier, 0.0f);
                                }
                            }
                            return new DeliveryTarget((class_1297)target, centeredContext.distance(distanceBasedMultiplier));
                        }).toList();
                        SpellHelper.deliver(world, spellEntry, player, targetsWithContext, context, null, completion, true, false);
                        break;
                    }
                    case BEAM: 
                    case FROM_TRIGGER: {
                        List<DeliveryTarget> targetsWithContext = targets.stream().map(target -> new DeliveryTarget((class_1297)target, context)).toList();
                        success = SpellHelper.deliver(world, spellEntry, player, targetsWithContext, context, null, completion);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)targeting.type));
                    }
                }
                caster.setChannelTickIndex(channelTickIndex + incrementChannelTicks);
            } else if (finished && completion != null) {
                completion.accept(new DeliveryCompletion(true));
            }
        }
    }

    private static void consumeSpellCost(class_1657 player, float progress, SpellContainerSource.SourcedContainer spellSource, class_2960 spellId, Spell spell, class_1799 heldItemStack, Ammo.Result ammoResult, boolean scheduled) {
        Optional effect;
        boolean batching = spell.cost.batching;
        if (batching && !scheduled) {
            if (((SpellBatcher)player).hasBatchedCost(spellId)) {
                return;
            }
            ((WorldScheduler)player.method_37908()).schedule(0, () -> SpellHelper.consumeSpellCost(player, progress, spellSource, spellId, spell, heldItemStack, ammoResult, true));
            ((SpellBatcher)player).batchCost(spellId, true);
            return;
        }
        SpellHelper.imposeCooldown(player, spellSource, spellId, spell, progress);
        player.method_7322(spell.cost.exhaust * SpellEngineMod.config.spell_cost_exhaust_multiplier);
        if (SpellEngineMod.config.spell_cost_durability_allowed && spell.cost.durability > 0) {
            class_1799 stackToDamage = spellSource.itemStack().method_7963() ? spellSource.itemStack() : heldItemStack;
            stackToDamage.method_7970(spell.cost.durability, (class_1309)player, class_1304.field_6173);
        }
        Ammo.consume(ammoResult, player);
        if (spell.cost.effect_id != null && (effect = class_7923.field_41174.method_55841(class_2960.method_60654((String)spell.cost.effect_id))).isPresent()) {
            player.method_6016((class_6880)effect.get());
        }
    }

    public static boolean deliver(class_1937 world, class_6880<Spell> spellEntry, class_1657 caster, List<DeliveryTarget> targets, ImpactContext context, @Nullable class_243 targetLocation, Consumer<DeliveryCompletion> completion) {
        return SpellHelper.deliver(world, spellEntry, caster, targets, context, targetLocation, completion, false, false);
    }

    public static boolean deliver(class_1937 world, class_6880<Spell> spellEntry, class_1657 caster, List<DeliveryTarget> targets, ImpactContext context, @Nullable class_243 targetLocation, @Nullable Consumer<DeliveryCompletion> completion, boolean forceSuccess, boolean scheduled) {
        Spell spell = (Spell)spellEntry.comp_349();
        if (spell.deliver.delay > 0) {
            if (scheduled) {
                Predicate<class_1297> validator = entity -> entity != null && !entity.method_31481();
                if (!validator.test((class_1297)caster)) {
                    return false;
                }
                targets = targets.stream().filter(target -> validator.test(target.entity)).toList();
            } else {
                List<DeliveryTarget> finalTargets = targets;
                ((WorldScheduler)world).schedule(spell.deliver.delay, () -> SpellHelper.deliver(world, spellEntry, caster, finalTargets, context, targetLocation, completion, forceSuccess, true));
                return true;
            }
        }
        boolean delivered = false;
        switch (spell.deliver.type) {
            case DIRECT: {
                boolean anySuccess = false;
                class_243 casterPos = caster.method_19538().method_1031(0.0, (double)(caster.method_17682() / 2.0f), 0.0);
                for (DeliveryTarget targeted : targets) {
                    class_1297 target2 = targeted.entity;
                    ImpactContext targetSpecificContext = targeted.context.position(casterPos);
                    boolean result = SpellHelper.performImpacts(world, (class_1309)caster, target2, target2, spellEntry, spell.impacts, targetSpecificContext);
                    anySuccess = anySuccess || result;
                }
                delivered = anySuccess;
                break;
            }
            case PROJECTILE: {
                if (targets.isEmpty()) {
                    SpellHelper.shootProjectile(world, (class_1309)caster, null, spellEntry, context);
                } else {
                    for (DeliveryTarget targeted : targets) {
                        class_1297 target3 = targeted.entity;
                        ImpactContext targetSpecificContext = targeted.context;
                        SpellHelper.shootProjectile(world, (class_1309)caster, target3, spellEntry, targetSpecificContext);
                    }
                }
                delivered = true;
                break;
            }
            case METEOR: {
                boolean anyLaunched = false;
                if (targets.isEmpty() && targetLocation != null) {
                    SpellHelper.fallProjectile(world, (class_1309)caster, null, targetLocation, spellEntry, context);
                    anyLaunched = true;
                } else {
                    for (DeliveryTarget targeted : targets) {
                        class_1297 target4 = targeted.entity;
                        ImpactContext targetSpecificContext = targeted.context;
                        SpellHelper.fallProjectile(world, (class_1309)caster, target4, null, spellEntry, targetSpecificContext);
                        anyLaunched = true;
                    }
                }
                delivered = anyLaunched;
                break;
            }
            case CLOUD: {
                boolean placedAny = false;
                for (DeliveryTarget targeted : targets) {
                    class_1297 target5 = targeted.entity;
                    ImpactContext targetSpecificContext = targeted.context;
                    SpellHelper.placeCloud(world, (class_1309)caster, target5, spellEntry, targetSpecificContext);
                    placedAny = true;
                }
                delivered = placedAny;
                break;
            }
            case SHOOT_ARROW: {
                ArrowHelper.shootArrow(world, (class_1309)caster, spellEntry, context);
                delivered = true;
                break;
            }
            case STASH_EFFECT: {
                boolean anyAdded = false;
                Spell.Delivery.StashEffect stash = spell.deliver.stash_effect;
                class_2960 id = class_2960.method_60654((String)stash.id);
                class_6880.class_6883 effect = (class_6880.class_6883)class_7923.field_41174.method_55841(id).get();
                for (DeliveryTarget targeted : targets) {
                    class_1293 instance = new class_1293((class_6880)effect, (int)(stash.duration * 20.0f), stash.amplifier, false, stash.show_particles, true);
                    class_1297 class_12972 = targeted.entity();
                    if (!(class_12972 instanceof class_1309)) continue;
                    class_1309 livingEntity = (class_1309)class_12972;
                    livingEntity.method_6092(instance);
                    anyAdded = true;
                }
                delivered = anyAdded;
                break;
            }
            case CUSTOM: {
                SpellHandlers.CustomDelivery handler;
                if (spell.deliver.custom == null || (handler = SpellHandlers.customDelivery.get(spell.deliver.custom.handler)) == null) break;
                delivered = handler.onSpellDelivery(world, spellEntry, caster, targets, context, targetLocation);
            }
        }
        if (completion != null) {
            completion.accept(new DeliveryCompletion(delivered || forceSuccess));
        }
        return delivered;
    }

    public static void imposeCooldown(class_1657 player, SpellContainerSource.SourcedContainer source, class_2960 spellId, Spell spell, float progress) {
        float duration = SpellHelper.cooldownToSet((class_1309)player, spell, progress);
        int durationTicks = Math.round(duration * 20.0f);
        if (duration > 0.0f) {
            ((SpellCasterEntity)player).getCooldownManager().set(spellId, durationTicks);
        }
        if (SpellEngineMod.config.spell_item_cooldown_lock && spell.cost.cooldown.hosting_item) {
            class_1792 hostingItem = source.itemStack().method_7909();
            class_1796 itemCooldowns = player.method_7357();
            float durationLeft = (float)((ItemCooldownManagerExtension)itemCooldowns).SE_getLastCooldownDuration(hostingItem) * itemCooldowns.method_7905(hostingItem, 0.0f);
            if ((float)durationTicks > durationLeft) {
                itemCooldowns.method_7906(hostingItem, durationTicks);
            }
        }
    }

    private static float cooldownToSet(class_1309 caster, Spell spell, float progress) {
        if (spell.cost.cooldown.proportional) {
            return SpellHelper.getCooldownDuration(caster, spell) * progress;
        }
        return SpellHelper.getCooldownDuration(caster, spell);
    }

    public static float launchHeight(class_1309 livingEntity) {
        float eyeHeight = livingEntity.method_5751();
        double shoulderDistance = (double)livingEntity.method_17682() * 0.15;
        return (float)(((double)eyeHeight - shoulderDistance) * (double)livingEntity.method_17825());
    }

    public static class_243 launchPoint(class_1309 caster) {
        return SpellHelper.launchPoint(caster, launchPointOffsetDefault);
    }

    public static class_243 launchPoint(class_1309 caster, float forward) {
        class_243 look = caster.method_5720().method_1021((double)(forward * caster.method_17825()));
        return caster.method_19538().method_1031(0.0, (double)SpellHelper.launchHeight(caster), 0.0).method_1019(look);
    }

    public static void shootProjectile(class_1937 world, class_1309 caster, class_1297 target, class_6880<Spell> spellEntry, ImpactContext context) {
        SpellHelper.shootProjectile(world, caster, target, spellEntry, context, 0);
    }

    public static void shootProjectile(class_1937 world, class_1309 caster, class_1297 target, class_6880<Spell> spellEntry, ImpactContext context, int sequenceIndex) {
        float directionYaw;
        if (world.field_9236) {
            return;
        }
        Spell spell = (Spell)spellEntry.comp_349();
        class_243 launchPoint = SpellHelper.launchPoint(caster);
        Spell.Delivery.ShootProjectile data = spell.deliver.projectile;
        Spell.ProjectileData projectileData = data.projectile;
        Spell.ProjectileData.Perks mutablePerks = projectileData.perks.copy();
        SpellProjectile projectile = new SpellProjectile(world, caster, launchPoint.method_10216(), launchPoint.method_10214(), launchPoint.method_10215(), SpellProjectile.Behaviour.FLY, spellEntry, context, mutablePerks);
        Spell.LaunchProperties mutableLaunchProperties = data.launch_properties.copy();
        if (SpellEvents.PROJECTILE_SHOOT.isListened()) {
            SpellEvents.PROJECTILE_SHOOT.invoke(listener -> listener.onProjectileLaunch(new SpellEvents.ProjectileLaunchEvent(projectile, mutableLaunchProperties, caster, target, spellEntry, context, sequenceIndex)));
        }
        float velocity = mutableLaunchProperties.velocity;
        float divergence = projectileData.divergence;
        float directionPitch = data.inherit_shooter_pitch ? caster.method_36455() : 0.0f;
        float f = directionYaw = data.inherit_shooter_yaw ? caster.method_36454() : 0.0f;
        if (data.direct_towards_target && target != null) {
            class_243 directionVector = target.method_19538().method_1020(caster.method_19538()).method_1029();
            directionPitch = (float)VectorHelper.pitchFromNormalized(directionVector);
            directionYaw = (float)VectorHelper.yawFromNormalized(directionVector);
        }
        if (data.inherit_shooter_velocity) {
            projectile.method_24919((class_1297)caster, directionPitch, directionYaw, 0.0f, velocity, divergence);
        } else {
            if (!(data.direction_offsets == null || data.direction_offsets.length <= 0 || data.direction_offsets_require_target && target == null)) {
                int baseIndex = context.isChanneled() ? context.channelTickIndex() : sequenceIndex;
                int index = baseIndex % data.direction_offsets.length;
                Spell.Delivery.ShootProjectile.DirectionOffset offset = data.direction_offsets[index];
                directionPitch += offset.pitch;
                directionYaw += offset.yaw;
            }
            class_243 look = caster.method_5631(directionPitch, directionYaw).method_1029();
            projectile.method_7485(look.field_1352, look.field_1351, look.field_1350, velocity, divergence);
        }
        projectile.range = spell.range;
        projectile.method_36457(directionPitch);
        projectile.method_36456(directionYaw);
        projectile.setFollowedTarget(target);
        world.method_8649((class_1297)projectile);
        SoundHelper.playSound(world, (class_1297)projectile, mutableLaunchProperties.sound);
        if (sequenceIndex == 0 && mutableLaunchProperties.extra_launch_count > 0) {
            for (int i = 0; i < mutableLaunchProperties.extra_launch_count; ++i) {
                int ticks = (i + 1) * mutableLaunchProperties.extra_launch_delay;
                int nextSequenceIndex = i + 1;
                ((WorldScheduler)world).schedule(ticks, () -> {
                    if (caster == null || !caster.method_5805()) {
                        return;
                    }
                    SpellHelper.shootProjectile(world, caster, target, spellEntry, context, nextSequenceIndex);
                });
            }
        }
    }

    public static boolean fallProjectile(class_1937 world, class_1309 caster, class_1297 target, @Nullable class_243 targetLocation, class_6880<Spell> spellEntry, ImpactContext context) {
        return SpellHelper.fallProjectile(world, caster, target, targetLocation, spellEntry, context, 0);
    }

    public static boolean fallProjectile(class_1937 world, class_1309 caster, class_1297 target, @Nullable class_243 targetLocation, class_6880<Spell> spellEntry, ImpactContext context, int sequenceIndex) {
        class_243 targetPosition;
        if (world.field_9236) {
            return false;
        }
        class_243 class_2432 = targetPosition = target != null ? target.method_19538() : targetLocation;
        if (targetPosition == null) {
            return false;
        }
        Spell spell = (Spell)spellEntry.comp_349();
        Spell.Delivery.Meteor meteor = spell.deliver.meteor;
        float height = meteor.launch_height;
        class_243 launchPoint = targetPosition.method_1031(0.0, (double)height, 0.0);
        Spell.Delivery.Meteor data = spell.deliver.meteor;
        Spell.ProjectileData projectileData = data.projectile;
        Spell.LaunchProperties mutableLaunchProperties = data.launch_properties.copy();
        Spell.ProjectileData.Perks mutablePerks = projectileData.perks.copy();
        SpellProjectile projectile = new SpellProjectile(world, caster, launchPoint.method_10216(), launchPoint.method_10214(), launchPoint.method_10215(), SpellProjectile.Behaviour.FALL, spellEntry, context, mutablePerks);
        if (SpellEvents.PROJECTILE_FALL.isListened()) {
            SpellEvents.PROJECTILE_FALL.invoke(listener -> listener.onProjectileLaunch(new SpellEvents.ProjectileLaunchEvent(projectile, mutableLaunchProperties, caster, target, spellEntry, context, sequenceIndex)));
        }
        projectile.method_36456(0.0f);
        projectile.method_36457(90.0f);
        if (SpellHelper.launchSequenceEligible(sequenceIndex, meteor.divergence_requires_sequence)) {
            projectile.setVelocity(0.0, -1.0, 0.0, mutableLaunchProperties.velocity, 0.5f, projectileData.divergence);
        } else {
            projectile.method_18799(new class_243(0.0, (double)(-mutableLaunchProperties.velocity), 0.0));
        }
        if (SpellHelper.launchSequenceEligible(sequenceIndex, meteor.follow_target_requires_sequence)) {
            projectile.setFollowedTarget(target);
        } else {
            projectile.setFollowedTarget(null);
        }
        if (meteor.launch_radius > 0.0f && SpellHelper.launchSequenceEligible(sequenceIndex, meteor.offset_requires_sequence)) {
            double randomAngle = Math.toRadians(world.field_9229.method_43057() * 360.0f);
            class_243 offset = new class_243((double)meteor.launch_radius, 0.0, 0.0).method_1024((float)randomAngle);
            projectile.method_33574(projectile.method_19538().method_1019(offset));
        }
        projectile.field_5982 = projectile.method_36454();
        projectile.field_6004 = projectile.method_36455();
        projectile.range = height;
        world.method_8649((class_1297)projectile);
        if (sequenceIndex == 0 && mutableLaunchProperties.extra_launch_count > 0) {
            for (int i = 0; i < mutableLaunchProperties.extra_launch_count; ++i) {
                int ticks = (i + 1) * mutableLaunchProperties.extra_launch_delay;
                int nextSequenceIndex = i + 1;
                ((WorldScheduler)world).schedule(ticks, () -> {
                    if (caster == null || !caster.method_5805()) {
                        return;
                    }
                    SpellHelper.fallProjectile(world, caster, target, targetLocation, spellEntry, context, nextSequenceIndex);
                });
            }
        }
        return true;
    }

    private static boolean launchSequenceEligible(int index, int rule) {
        if (rule == 0) {
            return false;
        }
        if (rule > 0) {
            return index >= rule;
        }
        return index < -1 * rule;
    }

    private static void directImpact(class_1937 world, class_1309 caster, class_1297 target, class_6880<Spell> spellEntry, ImpactContext context) {
        SpellHelper.performImpacts(world, caster, target, target, spellEntry, ((Spell)spellEntry.comp_349()).impacts, context);
    }

    private static void beamImpact(class_1937 world, class_1309 caster, List<class_1297> targets, class_6880<Spell> spellEntry, ImpactContext context) {
        for (class_1297 target : targets) {
            SpellHelper.performImpacts(world, caster, target, target, spellEntry, ((Spell)spellEntry.comp_349()).impacts, context.position(target.method_19538()));
        }
    }

    public static void fallImpact(class_1309 caster, class_1297 projectile, class_6880<Spell> spellEntry, ImpactContext context) {
        class_243 adjustedCenter = context.position().method_1031(0.0, 1.0, 0.0);
        SpellHelper.performImpacts(projectile.method_37908(), caster, null, projectile, spellEntry, ((Spell)spellEntry.comp_349()).impacts, context.position(adjustedCenter));
    }

    public static boolean projectileImpact(class_1309 caster, class_1297 projectile, class_1297 target, class_6880<Spell> spellEntry, ImpactContext context) {
        return SpellHelper.performImpacts(projectile.method_37908(), caster, target, projectile, spellEntry, ((Spell)spellEntry.comp_349()).impacts, context);
    }

    public static boolean arrowImpact(class_1309 caster, class_1297 projectile, class_1297 target, class_6880<Spell> spellEntry, ImpactContext context) {
        Spell spell = (Spell)spellEntry.comp_349();
        if (spell.impacts != null) {
            return SpellHelper.performImpacts(projectile.method_37908(), caster, target, projectile, spellEntry, spell.impacts, context);
        }
        return false;
    }

    public static void lookupAndPerformAreaImpact(Spell.AreaImpact area_impact, class_6880<Spell> spellEntry, class_1309 caster, class_1297 exclude, class_1297 aoeSource, List<Spell.Impact> impacts, ImpactContext context, boolean additionalTargetLookup) {
        class_243 center = context.position();
        float radius = area_impact.combinedRadius(context.power().baseValue());
        List<class_1297> targets = TargetHelper.targetsFromArea(aoeSource, center, radius, area_impact.area, null);
        if (exclude != null) {
            targets.remove(exclude);
        }
        SpellHelper.applyAreaImpact(aoeSource.method_37908(), caster, targets, radius, area_impact.area, spellEntry, impacts, context.target(SpellTarget.FocusMode.AREA), additionalTargetLookup);
        ParticleHelper.sendBatches(aoeSource, area_impact.particles);
        SoundHelper.playSound(aoeSource.method_37908(), aoeSource, area_impact.sound);
    }

    private static void applyAreaImpact(class_1937 world, class_1309 caster, List<class_1297> targets, float range, Spell.Target.Area area, class_6880<Spell> spellEntry, List<Spell.Impact> impacts, ImpactContext context, boolean additionalTargetLookup) {
        double squaredRange = range * range;
        class_243 center = context.position();
        for (class_1297 target : targets) {
            float distanceBasedMultiplier = 1.0f;
            switch (area.distance_dropoff) {
                case NONE: {
                    break;
                }
                case SQUARED: {
                    distanceBasedMultiplier = (float)((squaredRange - target.method_5707(center)) / squaredRange);
                    distanceBasedMultiplier = Math.max(distanceBasedMultiplier, 0.0f);
                }
            }
            SpellHelper.performImpacts(world, caster, target, target, spellEntry, impacts, context.distance(distanceBasedMultiplier), additionalTargetLookup);
        }
    }

    public static boolean performImpacts(class_1937 world, class_1309 caster, @Nullable class_1297 target, class_1297 aoeSource, class_6880<Spell> spellEntry, List<Spell.Impact> impacts, ImpactContext context) {
        return SpellHelper.performImpacts(world, caster, target, aoeSource, spellEntry, impacts, context, true);
    }

    public static boolean performImpacts(class_1937 world, class_1309 caster, @Nullable class_1297 target, class_1297 aoeSource, class_6880<Spell> spellEntry, List<Spell.Impact> impacts, ImpactContext context, boolean additionalTargetLookup) {
        Collection trackers = target != null ? PlayerLookup.tracking((class_1297)target) : null;
        Spell spell = (Spell)spellEntry.comp_349();
        boolean anyPerformed = false;
        SpellTarget.Intent selectedIntent = null;
        for (Spell.Impact impact : impacts) {
            SpellTarget.Intent intent = SpellHelper.impactIntent(impact.action);
            if (!impact.action.apply_to_caster && selectedIntent != null && selectedIntent != intent || target == null) continue;
            boolean result = SpellHelper.performImpact(world, caster, target, spellEntry, impact, context, trackers);
            boolean bl = anyPerformed = anyPerformed || result;
            if (!result) continue;
            selectedIntent = intent;
        }
        Spell.AreaImpact area_impact = spell.area_impact;
        if (area_impact != null && additionalTargetLookup && (anyPerformed || target == null)) {
            SpellHelper.lookupAndPerformAreaImpact(area_impact, spellEntry, caster, target, aoeSource, impacts, context, false);
        }
        if (anyPerformed && caster instanceof class_1657) {
            class_1657 player = (class_1657)caster;
            ((WorldScheduler)world).schedule(0, () -> SpellTriggers.onSpellImpactAny(player, target, aoeSource, spellEntry));
        }
        return anyPerformed;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean performImpact(class_1937 world, class_1309 caster, class_1297 target, class_6880<Spell> spellEntry, Spell.Impact impact, ImpactContext context, Collection<class_3222> trackers) {
        block82: {
            if (!target.method_5732()) {
                return false;
            }
            success = false;
            critical = false;
            isKnockbackPushed = false;
            spell = (Spell)spellEntry.comp_349();
            try {
                originalTarget = target;
                if (impact.action.apply_to_caster) {
                    target = caster;
                } else {
                    intent = SpellHelper.impactIntent(impact.action);
                    if (!EntityRelations.actionAllowed(context.focusMode(), intent, caster, target)) {
                        return false;
                    }
                    if (intent == SpellTarget.Intent.HARMFUL && context.focusMode() == SpellTarget.FocusMode.AREA && ((EntityImmunity)target).isImmuneTo(EntityImmunity.Type.AREA_EFFECT)) {
                        return false;
                    }
                }
                conditionResult = SpellHelper.evaluateImpactConditions(target, caster, impact.target_modifiers);
                if (!conditionResult.allowed) {
                    return false;
                }
                targetWasAlive = true;
                if (target instanceof class_1309) {
                    livingEntity = (class_1309)target;
                    targetWasAlive = livingEntity.method_5805();
                }
                particleMultiplier = 1.0f * context.total();
                power = context.power();
                v0 = school = impact.school != null ? impact.school : spell.school;
                if (power == null || power.school() != school) {
                    power = SpellPower.getSpellPower((SpellSchool)school, (class_1309)caster);
                }
                if (impact.attribute != null) {
                    attributeOverride = (class_6880.class_6883)class_7923.field_41190.method_55841(class_2960.method_60654((String)impact.attribute)).get();
                    value = impact.attribute_from_target != false && originalTarget instanceof class_1309 != false ? ((livingEntity = (class_1309)originalTarget).method_6127().method_45331((class_6880)attributeOverride) != false ? livingEntity.method_45325((class_6880)attributeOverride) : 0.0) : caster.method_45325((class_6880)attributeOverride);
                    power = new SpellPower.Result(power.school(), value, power.criticalChance(), power.criticalDamage());
                }
                bonusPower = 1.0f + conditionResult.modifiers().stream().map((Function<Spell.Impact.Modifier, Float>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$performImpact$15(net.spell_engine.api.spell.Spell$Impact$Modifier ), (Lnet/spell_engine/api/spell/Spell$Impact$Modifier;)Ljava/lang/Float;)()).reduce(Float.valueOf(0.0f), (BinaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, sum(float float ), (Ljava/lang/Float;Ljava/lang/Float;)Ljava/lang/Float;)()).floatValue();
                bonusCritChance = conditionResult.modifiers().stream().map((Function<Spell.Impact.Modifier, Float>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$performImpact$16(net.spell_engine.api.spell.Spell$Impact$Modifier ), (Lnet/spell_engine/api/spell/Spell$Impact$Modifier;)Ljava/lang/Float;)()).reduce(Float.valueOf(0.0f), (BinaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, sum(float float ), (Ljava/lang/Float;Ljava/lang/Float;)Ljava/lang/Float;)());
                bonusCritDamage = conditionResult.modifiers().stream().map((Function<Spell.Impact.Modifier, Float>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$performImpact$17(net.spell_engine.api.spell.Spell$Impact$Modifier ), (Lnet/spell_engine/api/spell/Spell$Impact$Modifier;)Ljava/lang/Float;)()).reduce(Float.valueOf(0.0f), (BinaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, sum(float float ), (Ljava/lang/Float;Ljava/lang/Float;)Ljava/lang/Float;)());
                if ((power = new SpellPower.Result(power.school(), power.baseValue() * (double)bonusPower, power.criticalChance() + (double)bonusCritChance.floatValue(), power.criticalDamage() + (double)bonusCritDamage.floatValue())).baseValue() < (double)impact.action.min_power || power.baseValue() > (double)impact.action.max_power) {
                    clampedValue = class_3532.method_15350((double)power.baseValue(), (double)impact.action.min_power, (double)impact.action.max_power);
                    power = new SpellPower.Result(power.school(), clampedValue, power.criticalChance(), power.criticalDamage());
                }
                switch (1.$SwitchMap$net$spell_engine$api$spell$Spell$Impact$Action$Type[impact.action.type.ordinal()]) {
                    case 1: {
                        damageData = impact.action.damage;
                        knockbackMultiplier = Math.max(0.0f, damageData.knockback * context.total());
                        vulnerability = SpellPower.Vulnerability.none;
                        timeUntilRegen = target.field_6008;
                        if (target instanceof class_1309) {
                            livingEntity = (class_1309)target;
                            ((ConfigurableKnockback)livingEntity).pushKnockbackMultiplier_SpellEngine(context.hasOffset() != false ? 0.0f : knockbackMultiplier);
                            isKnockbackPushed = true;
                            if (damageData.bypass_iframes && SpellEngineMod.config.bypass_iframes) {
                                target.field_6008 = 0;
                            }
                            vulnerability = SpellPower.getVulnerability((class_1309)livingEntity, (SpellSchool)school);
                        }
                        result = power.random(vulnerability);
                        critical = result.isCritical();
                        amount = result.amount();
                        amount *= (double)damageData.spell_power_coefficient;
                        amount *= (double)context.total();
                        if (context.isChanneled()) {
                            amount *= (double)SpellPower.getHaste((class_1309)caster, (SpellSchool)school);
                        }
                        particleMultiplier = power.criticalDamage() + (double)vulnerability.criticalDamageBonus();
                        if (caster instanceof class_1657) {
                            player = (class_1657)caster;
                            SpellTriggers.onSpellImpactSpecific(player, target, spellEntry, impact, critical, Spell.Trigger.Stage.PRE);
                        }
                        caster.method_6114(target);
                        target.method_5643(SpellDamageSource.create((SpellSchool)school, (class_1309)caster), (float)amount);
                        if (target instanceof class_1309) {
                            livingEntity = (class_1309)target;
                            ((ConfigurableKnockback)livingEntity).popKnockbackMultiplier_SpellEngine();
                            isKnockbackPushed = false;
                            target.field_6008 = timeUntilRegen;
                            if (context.hasOffset()) {
                                direction = context.knockbackDirection(livingEntity.method_19538()).method_22882();
                                livingEntity.method_6005((double)(0.4f * knockbackMultiplier), direction.field_1352, direction.field_1350);
                            }
                        }
                        success = true;
                        break;
                    }
                    case 2: {
                        if (!(target instanceof class_1309)) break;
                        livingTarget = (class_1309)target;
                        healData = impact.action.heal;
                        particleMultiplier = power.criticalDamage();
                        result = power.random();
                        critical = result.isCritical();
                        amount = result.amount();
                        amount *= (double)healData.spell_power_coefficient;
                        amount *= (double)context.total();
                        if (context.isChanneled()) {
                            amount *= (double)SpellPower.getHaste((class_1309)caster, (SpellSchool)school);
                        }
                        if (caster instanceof class_1657) {
                            player = (class_1657)caster;
                            SpellTriggers.onSpellImpactSpecific(player, target, spellEntry, impact, critical, Spell.Trigger.Stage.PRE);
                        }
                        livingTarget.method_6025((float)amount);
                        if (SpellEvents.HEAL.isListened()) {
                            finalAmount = (float)amount;
                            SpellEvents.HEAL.invoke((Consumer<SpellEvents.HealEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$performImpact$18(net.minecraft.class_1309 net.minecraft.class_6880 net.minecraft.class_1309 float net.spell_engine.api.spell.event.SpellEvents$HealEvent ), (Lnet/spell_engine/api/spell/event/SpellEvents$HealEvent;)V)((class_1309)caster, spellEntry, (class_1309)livingTarget, (float)finalAmount));
                        }
                        success = true;
                        break;
                    }
                    case 3: {
                        data = impact.action.status_effect;
                        if (target instanceof class_1309) {
                            livingTarget = (class_1309)target;
                            optionalEffect = Optional.empty();
                            if (data.remove != null) {
                                effects = livingTarget.method_6026().stream().filter((Predicate<class_1293>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$performImpact$19(net.spell_engine.api.spell.Spell$Impact$Action$StatusEffect net.minecraft.class_1293 ), (Lnet/minecraft/class_1293;)Z)((Spell.Impact.Action.StatusEffect)data)).toList();
                                if (effects.isEmpty()) {
                                    return false;
                                }
                                switch (1.$SwitchMap$net$spell_engine$api$spell$Spell$Impact$Action$StatusEffect$Remove$Selector[data.remove.selector.ordinal()]) {
                                    case 1: {
                                        optionalEffect = Optional.of(effects.get(world.field_9229.method_43048(effects.size()))).map((Function<class_1293, class_6880>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, method_5579(), (Lnet/minecraft/class_1293;)Lnet/minecraft/class_6880;)());
                                        break;
                                    }
                                    case 2: {
                                        optionalEffect = Optional.of(effects.getFirst()).map((Function<class_1293, class_6880>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, method_5579(), (Lnet/minecraft/class_1293;)Lnet/minecraft/class_6880;)());
                                    }
                                }
                            } else {
                                id = class_2960.method_60654((String)data.effect_id);
                                optionalEffect = Optional.of((class_6880)class_7923.field_41174.method_55841(id).get());
                            }
                            if (optionalEffect.isEmpty()) {
                                return false;
                            }
                            effect = (class_6880)optionalEffect.get();
                            if (!SpellHelper.underApplyLimit(power, livingTarget, school, data.apply_limit)) {
                                return false;
                            }
                            amplifier = data.amplifier + (int)((double)data.amplifier_power_multiplier * power.nonCriticalValue());
                            switch (1.$SwitchMap$net$spell_engine$api$spell$Spell$Impact$Action$StatusEffect$ApplyMode[data.apply_mode.ordinal()]) {
                                case 1: 
                                case 2: {
                                    if (target.method_5864().method_20210(SpellEngineEntityTags.bosses) && (StatusEffectClassification.isMovementImpairing((class_6880<class_1291>)effect) || StatusEffectClassification.disablesMobAI((class_6880<class_1291>)effect))) {
                                        return false;
                                    }
                                    duration = Math.round(data.duration * 20.0f);
                                    showParticles = data.show_particles;
                                    if (data.apply_mode == Spell.Impact.Action.StatusEffect.ApplyMode.ADD) {
                                        currentEffect = livingTarget.method_6112(effect);
                                        legacyMode = data.amplifier_cap == 0 && data.amplifier > 0;
                                        cap = legacyMode == false ? data.amplifier_cap : data.amplifier;
                                        increment = legacyMode == false ? data.amplifier : 1;
                                        newAmplifier = 0;
                                        if (currentEffect != null) {
                                            currentAmplifier = currentEffect.method_5578();
                                            incrementedAmplifier = currentAmplifier + increment;
                                            newAmplifier = Math.min(incrementedAmplifier, cap);
                                            if (!data.refresh_duration) {
                                                if (currentAmplifier == newAmplifier) {
                                                    return false;
                                                }
                                                duration = currentEffect.method_5584();
                                            }
                                        }
                                        amplifier = newAmplifier;
                                    } else if (data.amplifier_cap > 0) {
                                        amplifier = Math.min(amplifier, data.amplifier_cap);
                                    }
                                    if (caster instanceof class_1657) {
                                        player = (class_1657)caster;
                                        SpellTriggers.onSpellImpactSpecific(player, target, spellEntry, impact, critical, Spell.Trigger.Stage.PRE);
                                    }
                                    instance = new class_1293(effect, duration, amplifier, false, showParticles, true);
                                    livingTarget.method_37222(instance, (class_1297)caster);
                                    success = true;
                                    break;
                                }
                                case 3: {
                                    if (data.amplifier_cap > 0) {
                                        amplifier = Math.min(amplifier, data.amplifier_cap);
                                    }
                                    if (!livingTarget.method_6059(effect)) break;
                                    if (caster instanceof class_1657) {
                                        player = (class_1657)caster;
                                        SpellTriggers.onSpellImpactSpecific(player, target, spellEntry, impact, critical, Spell.Trigger.Stage.PRE);
                                    }
                                    currentEffect = livingTarget.method_6112(effect);
                                    v1 = newAmplifier = amplifier > 0 ? currentEffect.method_5578() - amplifier : -1;
                                    if (newAmplifier < 0) {
                                        livingTarget.method_6016(effect);
                                    } else {
                                        livingTarget.method_37222(new class_1293(effect, currentEffect.method_5584(), newAmplifier, currentEffect.method_5591(), currentEffect.method_5581(), currentEffect.method_5592()), (class_1297)caster);
                                    }
                                    success = true;
                                }
                            }
                        }
                        break;
                    }
                    case 4: {
                        if (caster instanceof class_1657) {
                            player = (class_1657)caster;
                            SpellTriggers.onSpellImpactSpecific(player, target, spellEntry, impact, critical, Spell.Trigger.Stage.PRE);
                        }
                        data = impact.action.fire;
                        target.method_5639((float)data.duration);
                        if (target.method_20802() <= 0) break;
                        target.method_20803(target.method_20802() + data.tick_offset);
                        break;
                    }
                    case 5: {
                        spawns = impact.action.spawns;
                        if (spawns == null || spawns.isEmpty()) {
                            return false;
                        }
                        for (Spell.Impact.Action.Spawn data : spawns) {
                            id = class_2960.method_60654((String)data.entity_type_id);
                            type = (class_1299)class_7923.field_41177.method_10223(id);
                            entity = type.method_5883(world);
                            SpellHelper.applyEntityPlacement(entity, (class_1297)caster, target.method_19538(), data.placement);
                            if (entity instanceof SpellEntity.Spawned) {
                                spellSpawnedEntity = (SpellEntity.Spawned)entity;
                                args = new SpellEntity.Spawned.Args(caster, spellEntry, data, context);
                                spellSpawnedEntity.onSpawnedBySpell(args);
                            }
                            if (caster instanceof class_1657) {
                                player = (class_1657)caster;
                                SpellTriggers.onSpellImpactSpecific(player, target, spellEntry, impact, critical, Spell.Trigger.Stage.PRE);
                            }
                            ((WorldScheduler)world).schedule(data.delay_ticks, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$performImpact$20(net.minecraft.class_1937 net.minecraft.class_1297 ), ()V)((class_1937)world, (class_1297)entity));
                            success = true;
                        }
                        break;
                    }
                    case 6: {
                        data = impact.action.teleport;
                        if (!(target instanceof class_1309)) break;
                        livingTarget = (class_1309)target;
                        teleportedEntity = null;
                        destination = null;
                        startingPosition = null;
                        applyRotation = null;
                        switch (1.$SwitchMap$net$spell_engine$api$spell$Spell$Impact$Action$Teleport$Mode[data.mode.ordinal()]) {
                            case 1: {
                                teleportedEntity = livingTarget;
                                forward = data.forward;
                                look = target.method_5720();
                                startingPosition = target.method_19538();
                                destination = TargetHelper.findTeleportDestination(teleportedEntity, look, forward.distance, data.required_clearance_block_y);
                                groundJustBelow = TargetHelper.findSolidBlockBelow((class_1297)teleportedEntity, destination, target.method_37908(), -1.5f);
                                if (groundJustBelow == null) break;
                                destination = groundJustBelow;
                                break;
                            }
                            case 2: {
                                if (livingTarget == caster) {
                                    return false;
                                }
                                look = target.method_5720();
                                distance = 1.0f;
                                if (data.behind_target != null) {
                                    distance = data.behind_target.distance;
                                }
                                teleportedEntity = caster;
                                startingPosition = caster.method_19538();
                                destination = target.method_19538().method_1019(look.method_1021((double)(-distance)));
                                groundJustBelow = TargetHelper.findSolidBlockBelow((class_1297)teleportedEntity, destination, target.method_37908(), -1.5f);
                                if (groundJustBelow != null) {
                                    destination = groundJustBelow;
                                }
                                yaw = (yaw = (float)Math.toDegrees(Math.atan2(-(x = look.field_1352), z = look.field_1350))) < 0.0f ? yaw + 360.0f : yaw;
                                applyRotation = Float.valueOf(yaw);
                            }
                        }
                        if (destination == null || startingPosition == null || teleportedEntity == null) break;
                        ParticleHelper.sendBatches((class_1297)teleportedEntity, data.depart_particles, false);
                        world.method_32888((class_6880)class_5712.field_39446, startingPosition, class_5712.class_7397.method_43285((class_1297)teleportedEntity));
                        if (applyRotation == null || !(teleportedEntity instanceof class_3222)) ** GOTO lbl-1000
                        serverPlayer = (class_3222)teleportedEntity;
                        if (world instanceof class_3218) {
                            serverWorld = (class_3218)world;
                            if (caster instanceof class_1657) {
                                player = (class_1657)caster;
                                SpellTriggers.onSpellImpactSpecific(player, target, spellEntry, impact, critical, Spell.Trigger.Stage.PRE);
                            }
                            serverPlayer.method_14251(serverWorld, destination.field_1352, destination.field_1351, destination.field_1350, applyRotation.floatValue(), serverPlayer.method_36455());
                        } else lbl-1000:
                        // 2 sources

                        {
                            teleportedEntity.method_6082(destination.field_1352, destination.field_1351, destination.field_1350, false);
                        }
                        success = true;
                        ParticleHelper.sendBatches((class_1297)teleportedEntity, data.arrive_particles, false);
                        break;
                    }
                    case 7: {
                        cooldown = impact.action.cooldown;
                        modified = false;
                        if (cooldown != null && target instanceof class_1657) {
                            playerTarget = (class_1657)target;
                            if (caster instanceof class_1657) {
                                player = (class_1657)caster;
                                SpellTriggers.onSpellImpactSpecific(player, target, spellEntry, impact, critical, Spell.Trigger.Stage.PRE);
                            }
                            cooldownManager = ((SpellCasterEntity)playerTarget).getCooldownManager();
                            if (cooldown.actives != null) {
                                spells = SpellContainerSource.activeSpellsOf(playerTarget);
                                v2 = modified = modified != false || SpellHelper.modifyCooldowns(spells, cooldown.actives, cooldownManager) != false;
                            }
                            if (cooldown.passives != null) {
                                spells = SpellContainerSource.passiveSpellsOf(playerTarget);
                                v3 = modified = modified != false || SpellHelper.modifyCooldowns(spells, cooldown.passives, cooldownManager) != false;
                            }
                            if (modified) {
                                cooldownManager.update(false);
                                cooldownManager.pushSync();
                            }
                        }
                        success = modified;
                        break;
                    }
                    case 8: {
                        if (impact.action.custom == null || (handler = SpellHandlers.customImpact.get(impact.action.custom.handler)) == null) break;
                        if (caster instanceof class_1657) {
                            player = (class_1657)caster;
                            SpellTriggers.onSpellImpactSpecific(player, target, spellEntry, impact, critical, Spell.Trigger.Stage.PRE);
                        }
                        result = handler.onSpellImpact(spellEntry, power, caster, target, context);
                        particleMultiplier = power.criticalDamage();
                        success = result.success();
                        critical = result.critical();
                    }
                }
                if (success) {
                    if (impact.particles != null) {
                        countMultiplier = critical != false ? (float)particleMultiplier : 1.0f;
                        ParticleHelper.sendBatches(target, impact.particles, countMultiplier * caster.method_55693(), trackers);
                    }
                    if (impact.sound != null) {
                        SoundHelper.playSound(world, target, impact.sound);
                    }
                    if (targetWasAlive && caster instanceof class_1657) {
                        player = (class_1657)caster;
                        finalTarget = target;
                        finalCritical = critical;
                        ((WorldScheduler)world).schedule(0, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$performImpact$21(net.minecraft.class_1657 net.minecraft.class_1297 net.minecraft.class_6880 net.spell_engine.api.spell.Spell$Impact boolean ), ()V)((class_1657)player, (class_1297)finalTarget, spellEntry, (Spell.Impact)impact, (boolean)finalCritical));
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Failed to perform impact effect");
                System.err.println(e.getMessage());
                if (!isKnockbackPushed) break block82;
                ((ConfigurableKnockback)target).popKnockbackMultiplier_SpellEngine();
            }
        }
        return success;
    }

    private static boolean modifyCooldowns(List<class_6880<Spell>> spells, Spell.Impact.Action.Cooldown.Modify modifier, SpellCooldownManager cooldownManager) {
        boolean modifiedAny = false;
        for (class_6880<Spell> spell : spells) {
            int duration;
            int updatedDuration;
            class_2960 id = ((class_5321)spell.method_40230().get()).method_29177();
            if (!PatternMatching.matches(spell, SpellRegistry.KEY, modifier.id) || (updatedDuration = (int)(((float)(duration = cooldownManager.getCooldownDuration(id)) + modifier.duration_add) * modifier.duration_multiplier)) == duration) continue;
            cooldownManager.setDurationLeft(id, updatedDuration);
            modifiedAny = true;
        }
        return modifiedAny;
    }

    public static TargetConditionResult evaluateImpactConditions(class_1297 target, class_1309 caster, List<Spell.Impact.TargetModifier> target_modifiers) {
        if (target_modifiers == null) {
            return TargetConditionResult.ALLOWED;
        }
        ArrayList<Spell.Impact.Modifier> modifiers = new ArrayList<Spell.Impact.Modifier>();
        for (Spell.Impact.TargetModifier entry : target_modifiers) {
            boolean conditionMet = true;
            int i = 0;
            for (Spell.TargetCondition condition : entry.conditions) {
                boolean newResult = SpellTarget.evaluate(target, (class_1297)caster, condition);
                conditionMet = i == 0 ? newResult : (entry.all_required ? conditionMet && newResult : conditionMet || newResult);
                ++i;
            }
            switch (entry.execute) {
                case ALLOW: {
                    if (conditionMet) break;
                    return TargetConditionResult.DENIED;
                }
                case DENY: {
                    if (!conditionMet) break;
                    return TargetConditionResult.DENIED;
                }
            }
            if (!conditionMet || entry.modifier == null) continue;
            modifiers.add(entry.modifier);
        }
        return new TargetConditionResult(true, modifiers);
    }

    public static void placeCloud(class_1937 world, class_1309 caster, class_1297 target, class_6880<Spell> spellEntry, ImpactContext context) {
        Spell spell = (Spell)spellEntry.comp_349();
        List<Spell.Delivery.Cloud> clouds = spell.deliver.clouds;
        if (clouds == null || clouds.isEmpty()) {
            return;
        }
        if (target == null) {
            target = caster;
        }
        for (Spell.Delivery.Cloud cloud : clouds) {
            SpellCloud entity;
            if (cloud.entity_type_id != null) {
                class_2960 id = class_2960.method_60654((String)cloud.entity_type_id);
                class_1299 type = (class_1299)class_7923.field_41177.method_10223(id);
                entity = (SpellCloud)type.method_5883(world);
            } else {
                entity = new SpellCloud(world);
            }
            entity.setOwner(caster);
            entity.onCreatedFromSpell(((class_5321)spellEntry.method_40230().get()).method_29177(), cloud, context);
            SpellHelper.applyEntityPlacement(entity, target, target.method_19538(), cloud.placement);
            ((WorldScheduler)world).schedule(cloud.delay_ticks, () -> {
                ParticleBatch[] particles;
                world.method_8649((class_1297)entity);
                Sound sound = cloud.spawn.sound;
                if (sound != null) {
                    SoundHelper.playSound(world, entity, sound);
                }
                if ((particles = cloud.spawn.particles) != null) {
                    ParticleHelper.sendBatches(entity, particles);
                }
            });
        }
    }

    public static void applyEntityPlacement(class_1297 entity, class_1297 target, class_243 initialPosition, Spell.EntityPlacement placement) {
        class_243 position = initialPosition;
        if (placement != null) {
            if (placement.location_offset_by_look > 0.0f) {
                float yaw = target.method_36454() + placement.location_yaw_offset;
                position = position.method_1019(class_243.method_1030((float)0.0f, (float)yaw).method_1021((double)placement.location_offset_by_look));
            }
            position = position.method_1019(new class_243((double)placement.location_offset_x, (double)placement.location_offset_y, (double)placement.location_offset_z));
            if (placement.force_onto_ground) {
                class_243 groundPosBelow;
                class_243 searchPosition = position;
                class_2338 blockPos = class_2338.method_49637((double)searchPosition.method_10216(), (double)searchPosition.method_10214(), (double)searchPosition.method_10215());
                if (target.method_37908().method_8320(blockPos).method_51367()) {
                    searchPosition = searchPosition.method_1031(0.0, 2.0, 0.0);
                }
                class_243 class_2432 = position = (groundPosBelow = TargetHelper.findSolidBlockBelow(target, searchPosition, target.method_37908(), -20.0f)) != null ? groundPosBelow : position;
            }
            if (placement.apply_yaw) {
                entity.method_36456(target.method_36454());
            }
            if (placement.apply_pitch) {
                entity.method_36457(target.method_36455());
            }
            position = position.method_1019(new class_243((double)placement.location_offset_x, (double)placement.location_offset_y, (double)placement.location_offset_z));
        }
        entity.method_5814(position.method_10216(), position.method_10214(), position.method_10215());
    }

    public static SpellTarget.FocusMode focusMode(Spell spell) {
        switch (spell.target.type) {
            case AREA: 
            case BEAM: {
                return SpellTarget.FocusMode.AREA;
            }
            case NONE: 
            case CASTER: 
            case AIM: 
            case FROM_TRIGGER: {
                return SpellTarget.FocusMode.DIRECT;
            }
        }
        return null;
    }

    public static Optional<SpellTarget.Intent> deliveryIntent(Spell spell) {
        switch (spell.deliver.type) {
            case STASH_EFFECT: {
                SpellTarget.Intent intent = SpellHelper.intentForStatusEffect(spell.deliver.stash_effect.id);
                return Optional.of(intent);
            }
        }
        return Optional.empty();
    }

    public static EnumSet<SpellTarget.Intent> impactIntents(Spell spell) {
        HashSet<SpellTarget.Intent> intents = new HashSet<SpellTarget.Intent>();
        for (Spell.Impact impact : spell.impacts) {
            intents.add(SpellHelper.impactIntent(impact.action));
        }
        return EnumSet.copyOf(intents);
    }

    public static SpellTarget.Intent impactIntent(Spell.Impact.Action action) {
        switch (action.type) {
            case DAMAGE: 
            case FIRE: {
                return SpellTarget.Intent.HARMFUL;
            }
            case HEAL: 
            case SPAWN: {
                return SpellTarget.Intent.HELPFUL;
            }
            case STATUS_EFFECT: {
                if (action.status_effect.remove != null) {
                    return action.status_effect.remove.select_beneficial ? SpellTarget.Intent.HARMFUL : SpellTarget.Intent.HELPFUL;
                }
                return SpellHelper.intentForStatusEffect(action.status_effect.effect_id);
            }
            case TELEPORT: {
                return action.teleport.intent;
            }
            case COOLDOWN: {
                Spell.Impact.Action.Cooldown cooldown = action.cooldown;
                if (cooldown != null) {
                    float duration_add = 0.0f;
                    float duration_multiplier = 1.0f;
                    if (cooldown.actives != null) {
                        duration_add += cooldown.actives.duration_add;
                        duration_multiplier += cooldown.actives.duration_multiplier - 1.0f;
                    }
                    if (cooldown.passives != null) {
                        duration_add += cooldown.passives.duration_add;
                        duration_multiplier += cooldown.passives.duration_multiplier - 1.0f;
                    }
                    boolean addHelpful = duration_add <= 0.0f;
                    boolean multiplierHelpful = duration_multiplier <= 1.0f;
                    return addHelpful && multiplierHelpful ? SpellTarget.Intent.HELPFUL : SpellTarget.Intent.HARMFUL;
                }
                return SpellTarget.Intent.HELPFUL;
            }
            case CUSTOM: {
                return action.custom.intent;
            }
        }
        return null;
    }

    private static SpellTarget.Intent intentForStatusEffect(String idString) {
        class_2960 id = class_2960.method_60654((String)idString);
        class_1291 effect = (class_1291)class_7923.field_41174.method_10223(id);
        return effect.method_5573() ? SpellTarget.Intent.HELPFUL : SpellTarget.Intent.HARMFUL;
    }

    public static boolean underApplyLimit(SpellPower.Result spellPower, class_1309 target, SpellSchool school, Spell.Impact.Action.StatusEffect.ApplyLimit limit) {
        if (limit == null) {
            return true;
        }
        float power = (float)spellPower.nonCriticalValue();
        float cap = limit.health_base + power * limit.spell_power_multiplier;
        return cap >= target.method_6063();
    }

    public static EstimatedOutput estimate(Spell spell, class_1657 caster, class_1799 itemStack) {
        SpellSchool spellSchool = spell.school;
        ArrayList<EstimatedValue> damageEffects = new ArrayList<EstimatedValue>();
        ArrayList<EstimatedValue> healEffects = new ArrayList<EstimatedValue>();
        boolean isEquipped = AttributeModifierUtil.isItemStackEquipped(itemStack, caster);
        for (Spell.Impact impact : spell.impacts) {
            SpellPower.Result power;
            boolean useRealAttributes;
            Optional optionalAttribute;
            SpellSchool school = impact.school != null ? impact.school : spellSchool;
            class_6880 attribute = school.attributeEntry;
            boolean attributeOverride = false;
            if (impact.attribute != null && !impact.attribute.isEmpty() && (optionalAttribute = class_7923.field_41190.method_55841(class_2960.method_60654((String)impact.attribute))).isPresent()) {
                attribute = (class_6880)optionalAttribute.get();
                attributeOverride = true;
            }
            double flatBonusOnItemStack = AttributeModifierUtil.flatBonusFrom(itemStack, (class_6880<class_1320>)attribute);
            boolean bl = useRealAttributes = isEquipped || flatBonusOnItemStack == 0.0;
            if (useRealAttributes) {
                power = SpellPower.getSpellPower((SpellSchool)school, (class_1309)caster);
                if (attributeOverride) {
                    double value = caster.method_45325(attribute);
                    power = new SpellPower.Result(school, value, power.criticalChance(), power.criticalDamage());
                }
            } else {
                power = new SpellPower.Result(school, flatBonusOnItemStack, 0.0, 1.0);
            }
            if (power.baseValue() < (double)impact.action.min_power || power.baseValue() > (double)impact.action.max_power) {
                double clampedValue = class_3532.method_15350((double)power.baseValue(), (double)impact.action.min_power, (double)impact.action.max_power);
                power = new SpellPower.Result(power.school(), clampedValue, power.criticalChance(), power.criticalDamage());
            }
            switch (impact.action.type) {
                case DAMAGE: {
                    Spell.Impact.Action.Damage damageData = impact.action.damage;
                    EstimatedValue damage = new EstimatedValue(power.nonCriticalValue(), power.forcedCriticalValue()).multiply(damageData.spell_power_coefficient);
                    damageEffects.add(damage);
                    break;
                }
                case HEAL: {
                    Spell.Impact.Action.Heal healData = impact.action.heal;
                    EstimatedValue healing = new EstimatedValue(power.nonCriticalValue(), power.forcedCriticalValue()).multiply(healData.spell_power_coefficient);
                    healEffects.add(healing);
                }
            }
        }
        return new EstimatedOutput(damageEffects, healEffects);
    }

    private static /* synthetic */ void lambda$performImpact$21(class_1657 player, class_1297 finalTarget, class_6880 spellEntry, Spell.Impact impact, boolean finalCritical) {
        SpellTriggers.onSpellImpactSpecific(player, finalTarget, (class_6880<Spell>)spellEntry, impact, finalCritical, Spell.Trigger.Stage.POST);
    }

    private static /* synthetic */ void lambda$performImpact$20(class_1937 world, class_1297 entity) {
        world.method_8649(entity);
    }

    private static /* synthetic */ boolean lambda$performImpact$19(Spell.Impact.Action.StatusEffect data, class_1293 instance) {
        return ((class_1291)instance.method_5579().comp_349()).method_5573() == data.remove.select_beneficial && PatternMatching.matches(instance.method_5579(), class_7924.field_41208, data.remove.id);
    }

    private static /* synthetic */ void lambda$performImpact$18(class_1309 caster, class_6880 spellEntry, class_1309 livingTarget, float finalAmount, SpellEvents.HealEvent listener) {
        listener.onHeal(new SpellEvents.HealEvent.Args(caster, (class_6880<Spell>)spellEntry, livingTarget, finalAmount));
    }

    private static /* synthetic */ Float lambda$performImpact$17(Spell.Impact.Modifier modifier) {
        return Float.valueOf(modifier.critical_damage_bonus);
    }

    private static /* synthetic */ Float lambda$performImpact$16(Spell.Impact.Modifier modifier) {
        return Float.valueOf(modifier.critical_chance_bonus);
    }

    private static /* synthetic */ Float lambda$performImpact$15(Spell.Impact.Modifier modifier) {
        return Float.valueOf(modifier.power_multiplier);
    }

    private static /* synthetic */ void lambda$performSpell$3(class_1657 player, Spell spell, class_1937 world, Supplier trackingPlayers, float castingSpeed, float finalProgress, SpellContainerSource.SourcedContainer spellSource, class_2960 spellId, class_1799 heldItemStack, Ammo.Result ammoResult, class_6880 spellEntry, List finalTargets, SpellCast.Action action, DeliveryCompletion completionArgs) {
        boolean deliverySuccess = completionArgs.success();
        if (deliverySuccess) {
            ParticleHelper.sendBatches((class_1297)player, spell.release.particles);
            if (spell.release.particles_scaled_with_ranged != null) {
                ParticleBatch[] scaledParticles = new ParticleBatch[spell.release.particles_scaled_with_ranged.length];
                for (int i = 0; i < spell.release.particles_scaled_with_ranged.length; ++i) {
                    ParticleBatch particles = spell.release.particles_scaled_with_ranged[i];
                    float range = SpellHelper.getRange(player, spell);
                    scaledParticles[i] = particles.copy().scale(range);
                }
                ParticleHelper.sendBatches((class_1297)player, scaledParticles);
            }
            SoundHelper.playSound(world, (class_1297)player, spell.release.sound);
            AnimationHelper.sendAnimation(player, (Collection)trackingPlayers.get(), SpellCast.Animation.RELEASE, spell.release.animation, castingSpeed);
            SpellHelper.consumeSpellCost(player, finalProgress, spellSource, spellId, spell, heldItemStack, ammoResult, false);
            SpellEvents.SpellCastEvent.Args args = new SpellEvents.SpellCastEvent.Args(player, (class_6880<Spell>)spellEntry, finalTargets, action, finalProgress);
            SpellEvents.SPELL_CAST.invoke(listener -> listener.onSpellCast(args));
        }
    }

    public record ImpactContext(float channel, float distance, @Nullable class_243 position, SpellPower.Result power, SpellTarget.FocusMode focusMode, int channelTickIndex) {
        public ImpactContext() {
            this(1.0f, 1.0f, null, null, SpellTarget.FocusMode.DIRECT, 0);
        }

        public ImpactContext channeled(float multiplier) {
            return new ImpactContext(multiplier, this.distance, this.position, this.power, this.focusMode, this.channelTickIndex);
        }

        public ImpactContext distance(float multiplier) {
            return new ImpactContext(this.channel, multiplier, this.position, this.power, this.focusMode, this.channelTickIndex);
        }

        public ImpactContext position(class_243 position) {
            return new ImpactContext(this.channel, this.distance, position, this.power, this.focusMode, this.channelTickIndex);
        }

        public ImpactContext power(SpellPower.Result spellPower) {
            return new ImpactContext(this.channel, this.distance, this.position, spellPower, this.focusMode, this.channelTickIndex);
        }

        public ImpactContext target(SpellTarget.FocusMode focusMode) {
            return new ImpactContext(this.channel, this.distance, this.position, this.power, focusMode, this.channelTickIndex);
        }

        public boolean hasOffset() {
            return this.position != null;
        }

        public class_243 knockbackDirection(class_243 targetPosition) {
            return targetPosition.method_1020(this.position).method_1029();
        }

        public boolean isChanneled() {
            return this.channel != 1.0f;
        }

        public float total() {
            return this.channel * this.distance;
        }
    }

    public record DeliveryTarget(class_1297 entity, ImpactContext context) {
    }

    public record DeliveryCompletion(boolean success) {
    }

    public record TargetConditionResult(boolean allowed, List<Spell.Impact.Modifier> modifiers) {
        public static final TargetConditionResult ALLOWED = new TargetConditionResult(true, List.of());
        public static final TargetConditionResult DENIED = new TargetConditionResult(false, List.of());
    }

    public record EstimatedValue(double min, double max) {
        public EstimatedValue multiply(double value) {
            return new EstimatedValue(this.min * value, this.max * value);
        }
    }

    public record EstimatedOutput(List<EstimatedValue> damage, List<EstimatedValue> heal) {
    }
}

