/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_8710;
import net.spell_engine.network.Packets;
import org.jetbrains.annotations.Nullable;

public class SpellCooldownManager {
    private final Map<class_2960, Entry> entries = Maps.newHashMap();
    private int tick;
    private final class_1657 owner;
    private static final String NBT_KEY = "spell_engine_cooldowns";

    public SpellCooldownManager(class_1657 owner) {
        this.owner = owner;
    }

    public boolean isCoolingDown(class_2960 spell) {
        return this.getCooldownProgress(spell, 0.0f) > 0.0f;
    }

    public float getCooldownProgress(class_2960 spell, float tickDelta) {
        Entry entry = this.entries.get(spell);
        if (entry != null) {
            float f = entry.endTick - entry.startTick;
            float g = (float)entry.endTick - ((float)this.tick + tickDelta);
            return class_3532.method_15363((float)(g / f), (float)0.0f, (float)1.0f);
        }
        return 0.0f;
    }

    public int getCooldownDuration(class_2960 spell) {
        Entry entry = this.entries.get(spell);
        if (entry != null) {
            return entry.timeLeft(this.tick);
        }
        return 0;
    }

    public void setDurationLeft(class_2960 spell, int duration) {
        Entry existingEntry = this.entries.get(spell);
        if (existingEntry != null) {
            this.entries.put(spell, new Entry(this.tick, this.tick + duration));
        } else if (duration > 0) {
            this.entries.put(spell, new Entry(this.tick, this.tick + duration));
        }
    }

    public void tickUpdate() {
        ++this.tick;
        this.update(true);
    }

    public void update(boolean sync) {
        if (!this.entries.isEmpty()) {
            Iterator<Map.Entry<class_2960, Entry>> iterator = this.entries.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<class_2960, Entry> entry = iterator.next();
                if (entry.getValue().endTick > this.tick) continue;
                iterator.remove();
                if (!sync) continue;
                this.cooldownCleared(entry.getKey());
            }
        }
    }

    public void set(class_2960 spell, int duration, boolean force) {
        if (force || !this.entries.containsKey(spell) || this.entries.get(spell).timeLeft(this.tick) < duration) {
            this.entries.put(spell, new Entry(this.tick, this.tick + duration));
            this.cooldownSet(spell, duration);
        }
    }

    public void set(class_2960 spell, int duration) {
        this.set(spell, duration, true);
    }

    public void remove(class_2960 spell) {
        this.entries.remove(spell);
        this.cooldownCleared(spell);
    }

    protected void cooldownSet(class_2960 spell, int duration) {
        class_1657 class_16572 = this.owner;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new Packets.SpellCooldown(spell, duration));
        }
    }

    protected void cooldownCleared(class_2960 spell) {
        class_1657 class_16572 = this.owner;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new Packets.SpellCooldown(spell, 0));
        }
    }

    public void writeCustomDataToNbt(class_2487 nbt) {
        class_2487 cooldowns = new class_2487();
        for (Map.Entry<class_2960, Entry> entry : this.entries.entrySet()) {
            class_2960 spell = entry.getKey();
            Entry cooldown = entry.getValue();
            class_2487 cooldownData = new class_2487();
            cooldownData.method_10569("start", cooldown.startTick - this.tick);
            cooldownData.method_10569("end", cooldown.endTick - this.tick);
            cooldowns.method_10566(spell.toString(), (class_2520)cooldownData);
        }
        nbt.method_10566(NBT_KEY, (class_2520)cooldowns);
    }

    public void readCustomDataFromNbt(class_2487 nbt) {
        class_2487 cooldowns = nbt.method_10562(NBT_KEY);
        for (String key : cooldowns.method_10541()) {
            class_2960 spell = class_2960.method_60654((String)key);
            class_2487 cooldownData = cooldowns.method_10562(key);
            int start = cooldownData.method_10550("start");
            int end = cooldownData.method_10550("end");
            this.entries.put(spell, new Entry(start, end));
        }
    }

    public void reset(@Nullable class_2960 spellId) {
        if (spellId == null) {
            this.entries.clear();
        } else {
            this.entries.remove(spellId);
        }
        this.pushSync();
    }

    public void pushSync() {
        class_1657 class_16572 = this.owner;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new Packets.SpellCooldownSync(this.tick, Map.copyOf(this.entries)));
        }
    }

    public void acceptSync(int baseTick, Map<class_2960, Entry> cooldowns) {
        this.tick = baseTick;
        this.entries.clear();
        this.entries.putAll(cooldowns);
    }

    public record Entry(int startTick, int endTick) {
        int timeLeft(int currentTick) {
            return Math.max(0, this.endTick - currentTick);
        }
    }
}

