/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.compat.container.ContainerCompat;
import org.jetbrains.annotations.Nullable;

public class Ammo {
    private static final class_2960 SPELL_INFINITY = class_2960.method_60655((String)"spell_engine", (String)"spell_infinity");

    public static Result ammoForSpell(class_1657 player, Spell spell, class_1799 casterStack) {
        boolean satisfied = true;
        Searched ammo = null;
        int consume = 0;
        List<Source> sources = List.of();
        if (spell.cost.item != null && spell.cost.item.id != null && !spell.cost.item.id.isEmpty()) {
            Optional enchantmentQuery;
            ammo = Searched.from(spell.cost.item.id);
            if (player.method_31549().field_7477 || !SpellEngineMod.config.spell_cost_item_allowed) {
                return new Result(satisfied, ammo, consume, sources);
            }
            class_2960 id = class_2960.method_60654((String)spell.cost.item.id);
            boolean needsArrow = id.method_12832().contains("arrow");
            Optional optional = enchantmentQuery = needsArrow ? player.method_37908().method_30349().method_30530(class_7924.field_41265).method_40264(class_1893.field_9125) : player.method_37908().method_30349().method_30530(class_7924.field_41265).method_55841(SPELL_INFINITY);
            if (enchantmentQuery.isPresent() && class_1890.method_8225((class_6880)((class_6880)enchantmentQuery.get()), (class_1799)casterStack) > 0) {
                return new Result(satisfied, ammo, consume, sources);
            }
            if (ammo.isValid()) {
                int amountNeeded = spell.cost.item.amount;
                sources = Ammo.findSources(player, ammo, amountNeeded);
                int amountAvailable = sources.stream().mapToInt(Source::found).sum();
                satisfied = amountAvailable >= amountNeeded;
                consume = satisfied && spell.cost.item.consume ? amountAvailable : 0;
            }
        }
        return new Result(satisfied, ammo, consume, sources);
    }

    public static List<Source> findSources(class_1657 player, Searched searched, int totalAmount) {
        ArrayList<Source> sources = new ArrayList<Source>();
        int foundAmount = 0;
        Source container = Ammo.findContainer(player, searched.asPredicate(), totalAmount);
        if (container != null) {
            sources.add(container);
            foundAmount += container.found();
        }
        if (foundAmount < totalAmount) {
            class_1661 inventory = player.method_31548();
            for (int i = 0; i < inventory.method_5439(); ++i) {
                class_1799 stack = inventory.method_5438(i);
                if (searched.matches(stack)) {
                    Source source = Ammo.sourceFromStack(stack, totalAmount - foundAmount);
                    sources.add(source);
                    foundAmount += source.found();
                }
                if (foundAmount >= totalAmount) break;
            }
        }
        return sources;
    }

    private static Source sourceFromStack(class_1799 stack, int amount) {
        int found = Math.min(stack.method_7947(), amount);
        return new Source(stack, found, false);
    }

    @Nullable
    public static Source findContainer(class_1657 player, Predicate<class_1799> item, int amount) {
        for (Function<class_1657, List<class_1799>> provider : ContainerCompat.providers) {
            List<class_1799> stacks = provider.apply(player);
            for (class_1799 stack : stacks) {
                int found = Math.min(Ammo.findInContainer(stack, item), amount);
                if (found <= 0) continue;
                return new Source(stack, found, true);
            }
        }
        return null;
    }

    public static int findInContainer(class_1799 containerStack, Predicate<class_1799> consumedItem) {
        int found = 0;
        ContainerCompat.Adapter bundle = ContainerCompat.getContainerComponent(containerStack);
        if (bundle != null) {
            for (int i = 0; i < bundle.size(); ++i) {
                class_1799 storedStack = bundle.get(i);
                if (!consumedItem.test(storedStack)) continue;
                found += storedStack.method_7947();
            }
        }
        return found;
    }

    public static class_1799 findFirstInContainer(class_1799 containerStack, Predicate<class_1799> consumedItem) {
        ContainerCompat.Adapter bundle = ContainerCompat.getContainerComponent(containerStack);
        if (bundle != null) {
            for (int i = 0; i < bundle.size(); ++i) {
                class_1799 storedStack = bundle.get(i);
                if (!consumedItem.test(storedStack)) continue;
                return storedStack;
            }
        }
        return class_1799.field_8037;
    }

    public static void consume(Result result, class_1657 player) {
        if (result.consume() > 0) {
            for (Source source : result.sources()) {
                if (source.isContainer()) {
                    Ammo.takeFromContainer(source.itemStack(), result.item(), source.found());
                    continue;
                }
                class_1262.method_29234((class_1263)player.method_31548(), result.item().asPredicate(), (int)source.found(), (boolean)false);
            }
        }
    }

    public static int takeFromContainer(class_1799 containerStack, Searched consumedItem, int amount) {
        return Ammo.takeFromContainer(containerStack, consumedItem.asPredicate(), amount);
    }

    public static int takeFromContainer(class_1799 containerStack, Predicate<class_1799> consumedItem, int amount) {
        int taken = 0;
        ContainerCompat.Adapter bundle = ContainerCompat.getContainerComponent(containerStack);
        int toDecreement = amount;
        if (bundle != null) {
            ArrayList<class_1799> putBack = new ArrayList<class_1799>();
            for (int i = 0; i < bundle.size(); ++i) {
                class_1799 storedStack = bundle.get(i);
                if (consumedItem.test(storedStack)) {
                    int decrementable = Math.min(storedStack.method_7947(), toDecreement);
                    storedStack.method_7934(decrementable);
                    toDecreement -= decrementable;
                    taken += decrementable;
                }
                if (storedStack.method_7960()) continue;
                putBack.add(storedStack);
            }
            ContainerCompat.Adapter newBundle = bundle.createNewWithContents((List<class_1799>)putBack.reversed());
            newBundle.attachTo(containerStack);
        }
        return taken;
    }

    public record Searched(@Nullable class_6862<class_1792> tag, @Nullable class_1792 item) {
        public static Searched from(String stringId) {
            if (stringId.startsWith("#")) {
                return new Searched((class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)stringId.substring(1))), null);
            }
            return new Searched(null, (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)stringId)));
        }

        public boolean isValid() {
            return this.item != null || this.tag != null;
        }

        public boolean matches(class_1799 stack) {
            if (this.tag != null) {
                return stack.method_31573(this.tag);
            }
            if (this.item != null) {
                return stack.method_31574(this.item);
            }
            return false;
        }

        public Predicate<class_1799> asPredicate() {
            return this::matches;
        }

        public String getTranslationKey() {
            if (this.tag != null) {
                return this.tag.getTranslationKey();
            }
            if (this.item != null) {
                return this.item.method_7876();
            }
            return "";
        }
    }

    public record Result(boolean satisfied, Searched item, int consume, List<Source> sources) {
    }

    public record Source(class_1799 itemStack, int found, boolean isContainer) {
    }
}

