/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.fx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.client.particle.TemplateParticleEffect;
import net.spell_engine.client.util.Color;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.network.Packets;
import net.spell_engine.utils.TargetHelper;
import net.spell_engine.utils.VectorHelper;
import org.jetbrains.annotations.Nullable;

public class ParticleHelper {
    private static Random rng = new Random();

    public static void sendBatches(class_1297 trackedEntity, ParticleBatch[] batches) {
        ParticleHelper.sendBatches(trackedEntity, batches, true);
    }

    public static void sendBatches(class_1297 trackedEntity, ParticleBatch[] batches, boolean includeSourceEntity) {
        ParticleHelper.sendBatches(trackedEntity, batches, 1.0f, PlayerLookup.tracking((class_1297)trackedEntity), includeSourceEntity);
    }

    public static void sendBatches(class_1297 trackedEntity, ParticleBatch[] batches, float countMultiplier, Collection<class_3222> trackers) {
        ParticleHelper.sendBatches(trackedEntity, batches, countMultiplier, trackers, true);
    }

    public static void sendBatches(class_1297 trackedEntity, ParticleBatch[] batches, float countMultiplier, Collection<class_3222> trackers, boolean includeSourceEntity) {
        class_3222 serverPlayer2;
        if (batches == null || batches.length == 0) {
            return;
        }
        int sourceEntityId = trackedEntity.method_5628();
        Packets.ParticleBatches.SourceType sourceType = Packets.ParticleBatches.SourceType.COORDINATE;
        ArrayList<Packets.ParticleBatches.Spawn> spawns = new ArrayList<Packets.ParticleBatches.Spawn>();
        for (ParticleBatch batch : batches) {
            class_243 sourceLocation = class_243.field_1353;
            switch (sourceType) {
                case ENTITY: {
                    break;
                }
                case COORDINATE: {
                    sourceLocation = ParticleHelper.origin(trackedEntity, batch.origin);
                }
            }
            spawns.add(new Packets.ParticleBatches.Spawn(includeSourceEntity ? sourceEntityId : 0, trackedEntity.method_36454(), trackedEntity.method_36455(), sourceLocation, batch));
        }
        Packets.ParticleBatches packet = new Packets.ParticleBatches(sourceType, countMultiplier, spawns);
        if (trackedEntity instanceof class_3222 && ServerPlayNetworking.canSend((class_3222)(serverPlayer2 = (class_3222)trackedEntity), (class_2960)Packets.ParticleBatches.ID)) {
            ServerPlayNetworking.send((class_3222)serverPlayer2, (class_8710)packet);
        }
        trackers.forEach(serverPlayer -> {
            if (ServerPlayNetworking.canSend((class_3222)serverPlayer, (class_2960)Packets.ParticleBatches.ID)) {
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)packet);
            }
        });
    }

    public static void play(class_1937 world, class_1297 source, ParticleBatch[] batches) {
        if (batches == null) {
            return;
        }
        for (ParticleBatch batch : batches) {
            ParticleHelper.play(world, source, 0.0f, 0.0f, batch);
        }
    }

    public static void play(class_1937 world, class_1297 source, ParticleBatch batch) {
        ParticleHelper.play(world, source, 0.0f, 0.0f, batch);
    }

    public static void play(class_1937 world, class_1297 entity, float yaw, float pitch, ParticleBatch batch) {
        ParticleHelper.play(world, entity.field_6012, ParticleHelper.origin(entity, batch.origin), entity.method_17681(), yaw, pitch, batch, entity);
    }

    private static class_2394 resolveParticleType(ParticleBatch batch, @Nullable class_1297 sourceEntity) {
        class_2960 id = class_2960.method_60654((String)batch.particle_id);
        class_2394 particle = (class_2394)class_7923.field_41180.method_10223(id);
        if (particle instanceof TemplateParticleEffect) {
            TemplateParticleEffect templateParticleEffect = (TemplateParticleEffect)particle;
            TemplateParticleEffect copy = templateParticleEffect.copy();
            TemplateParticleEffect.Appearance appearance = copy.createOrDefaultAppearance();
            if (batch.color_rgba >= 0L) {
                appearance.color = Color.fromRGBA(batch.color_rgba);
            }
            if (batch.follow_entity) {
                appearance.entityFollowed = sourceEntity;
            }
            if (batch.scale != 1.0f) {
                appearance.scale = batch.scale;
            }
            if (batch.origin == ParticleBatch.Origin.GROUND) {
                appearance.grounded = true;
            }
            appearance.max_age = batch.max_age;
            particle = copy;
        }
        return particle;
    }

    public static void play(class_1937 world, long time, class_243 origin, float width, float yaw, float pitch, ParticleBatch batch, @Nullable class_1297 sourceEntity) {
        try {
            class_2394 particle = ParticleHelper.resolveParticleType(batch, sourceEntity);
            float count = batch.count;
            if (batch.count < 1.0f) {
                count = rng.nextFloat() < batch.count ? 1.0f : 0.0f;
            }
            int i = 0;
            while ((float)i < count) {
                class_243 direction = ParticleHelper.direction(batch, time, yaw, pitch);
                class_243 particleSpecificOrigin = origin.method_1019(ParticleHelper.offset(width, batch.extent, batch.shape, direction.method_1029(), batch.rotation, yaw, pitch));
                if (batch.pre_spawn_travel != 0.0f) {
                    particleSpecificOrigin = particleSpecificOrigin.method_1019(direction.method_1021((double)batch.pre_spawn_travel));
                }
                if (batch.invert) {
                    direction = direction.method_22882();
                }
                world.method_8466(particle, true, particleSpecificOrigin.field_1352, particleSpecificOrigin.field_1351, particleSpecificOrigin.field_1350, direction.field_1352, direction.field_1351, direction.field_1350);
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to play particle batch - " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static List<SpawnInstruction> convertToInstructions(class_1937 world, Packets.ParticleBatches packet) {
        ArrayList<SpawnInstruction> instructions = new ArrayList<SpawnInstruction>();
        Packets.ParticleBatches.SourceType sourceType = packet.sourceType();
        for (Packets.ParticleBatches.Spawn spawn : packet.spawns()) {
            float yaw = spawn.yaw();
            float pitch = spawn.pitch();
            ParticleBatch batch = spawn.batch();
            class_243 origin = class_243.field_1353;
            float width = 0.5f;
            class_1297 sourceEntity = world.method_8469(spawn.sourceEntityId());
            switch (sourceType) {
                case ENTITY: {
                    origin = ParticleHelper.origin(sourceEntity, batch.origin);
                    break;
                }
                case COORDINATE: {
                    origin = spawn.sourceLocation();
                }
            }
            class_2394 particle = ParticleHelper.resolveParticleType(batch, sourceEntity);
            float count = batch.count;
            if (batch.count < 1.0f) {
                count = rng.nextFloat() < batch.count ? 1.0f : 0.0f;
            }
            int i = 0;
            while ((float)i < count) {
                class_243 direction = ParticleHelper.direction(batch, world.method_8510(), yaw, pitch);
                class_243 particleSpecificOrigin = origin.method_1019(ParticleHelper.offset(width, batch.extent, batch.shape, direction.method_1029(), batch.rotation, yaw, pitch));
                if (batch.pre_spawn_travel != 0.0f) {
                    particleSpecificOrigin = particleSpecificOrigin.method_1019(direction.method_1021((double)batch.pre_spawn_travel));
                }
                if (batch.invert) {
                    direction = direction.method_22882();
                }
                instructions.add(new SpawnInstruction(particle, sourceEntity, particleSpecificOrigin.field_1352, particleSpecificOrigin.field_1351, particleSpecificOrigin.field_1350, direction.field_1352, direction.field_1351, direction.field_1350));
                ++i;
            }
        }
        return instructions;
    }

    private static class_243 origin(class_1297 entity, ParticleBatch.Origin origin) {
        switch (origin) {
            case FEET: {
                return entity.method_19538().method_1031(0.0, (double)(entity.method_17682() * 0.1f), 0.0);
            }
            case CENTER: {
                return entity.method_19538().method_1031(0.0, (double)(entity.method_17682() * 0.5f), 0.0);
            }
            case LAUNCH_POINT: {
                if (entity instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)entity;
                    return SpellHelper.launchPoint(livingEntity);
                }
                return entity.method_19538().method_1031(0.0, (double)(entity.method_17682() * 0.5f), 0.0);
            }
            case GROUND: {
                class_243 position = TargetHelper.findSolidBelow(entity, entity.method_19538(), entity.method_37908(), -2.0f);
                if (position != null) {
                    return new class_243(entity.method_23317(), position.method_10214() + (double)0.1f, entity.method_23321());
                }
                return entity.method_19538().method_1031(0.0, (double)0.1f, 0.0);
            }
        }
        return entity.method_19538();
    }

    private static class_243 offset(float width, float extent, ParticleBatch.Shape shape, class_243 direction, ParticleBatch.Rotation rotation, float yaw, float pitch) {
        class_243 offset = class_243.field_1353;
        if (extent >= 1000.0f) {
            width = 0.0f;
            extent -= 1000.0f;
        }
        switch (shape) {
            case LINE_VERTICAL: 
            case CIRCLE: 
            case CONE: 
            case SPHERE: {
                if (extent > 0.0f) {
                    offset = direction.method_1021((double)extent);
                }
                return offset;
            }
            case PIPE: {
                float size = width * 0.5f + extent;
                float angle = (float)Math.toRadians(rng.nextFloat() * 360.0f);
                offset = new class_243((double)size, 0.0, 0.0).method_1024(angle);
                break;
            }
            case WIDE_PIPE: {
                float size = width + extent;
                float angle = (float)Math.toRadians(rng.nextFloat() * 360.0f);
                offset = new class_243((double)size, 0.0, 0.0).method_1024(angle);
                break;
            }
            case PILLAR: {
                float x = (width * 0.5f + extent) * rng.nextFloat();
                float angle = (float)Math.toRadians(rng.nextFloat() * 360.0f);
                offset = new class_243((double)x, 0.0, 0.0).method_1024(angle);
            }
        }
        if (rotation != null) {
            switch (rotation) {
                case LOOK: {
                    offset = offset.method_1037((float)Math.toRadians(-1.0f * (pitch + 90.0f))).method_1024((float)Math.toRadians(-yaw));
                }
            }
        }
        return offset;
    }

    private static class_243 direction(ParticleBatch batch, long time, float yaw, float pitch) {
        class_243 direction = class_243.field_1353;
        float rotateAroundX = 0.0f;
        float rotateAroundY = 0.0f;
        switch (batch.shape) {
            case LINE: {
                direction = new class_243(0.0, 0.0, (double)ParticleHelper.randomInRange(batch.min_speed, batch.max_speed));
                pitch = -pitch;
                break;
            }
            case CONE: {
                direction = new class_243(0.0, (double)ParticleHelper.randomInRange(batch.min_speed, batch.max_speed), 0.0);
                rotateAroundX += rng.nextFloat() * batch.angle - batch.angle * 0.5f;
                rotateAroundY += rng.nextFloat() * batch.angle - batch.angle * 0.5f;
                break;
            }
            case CIRCLE: {
                direction = new class_243(0.0, 0.0, (double)ParticleHelper.randomInRange(batch.min_speed, batch.max_speed)).method_1024((float)Math.toRadians(rng.nextFloat() * 360.0f));
                break;
            }
            case LINE_VERTICAL: 
            case PIPE: 
            case WIDE_PIPE: 
            case PILLAR: {
                direction = new class_243(0.0, (double)ParticleHelper.randomInRange(batch.min_speed, batch.max_speed), 0.0);
                break;
            }
            case SPHERE: {
                direction = new class_243((double)ParticleHelper.randomInRange(batch.min_speed, batch.max_speed), 0.0, 0.0).method_31033((float)Math.toRadians(rng.nextFloat() * 360.0f)).method_1024((float)Math.toRadians(rng.nextFloat() * 360.0f));
            }
        }
        if (batch.rotation != null) {
            switch (batch.rotation) {
                case LOOK: {
                    float pRot = -pitch;
                    float yRot = yaw * -1.0f;
                    direction = direction.method_1037((float)Math.toRadians(pRot - 90.0f + rotateAroundX)).method_1024((float)Math.toRadians(yRot + rotateAroundY));
                    if (!(batch.roll > 0.0f)) break;
                    class_243 axis = VectorHelper.axisFromRotation(yRot, pRot).method_22882();
                    float diff = (float)time * batch.roll % 360.0f + batch.roll_offset;
                    direction = VectorHelper.rotateAround(direction, axis, diff);
                }
            }
        } else {
            direction = direction.method_1037((float)Math.toRadians(rotateAroundX)).method_1024((float)Math.toRadians(rotateAroundY));
            if (batch.roll > 0.0f) {
                float diff = (float)time * batch.roll % 360.0f + batch.roll_offset;
                direction = direction.method_1024((float)Math.toRadians(diff));
            }
        }
        return direction;
    }

    private static float randomInRange(float min, float max) {
        float range = max - min;
        return min + range * rng.nextFloat();
    }

    private static float randomSignedInRange(float min, float max) {
        float rand = rng.nextFloat();
        float range = max - min;
        float sign = rand > 0.5f ? 1.0f : -1.0f;
        float base = sign * min;
        float varied = sign * range * rand;
        return base + varied;
    }

    public record SpawnInstruction(class_2394 particle, @Nullable class_1297 sourceEntity, double positionX, double positionY, double positionZ, double velocityX, double velocityY, double velocityZ) {
        public void perform(class_1937 world) {
            try {
                world.method_8466(this.particle, true, this.positionX, this.positionY, this.positionZ, this.velocityX, this.velocityY, this.velocityZ);
            }
            catch (Exception e) {
                System.err.println("Failed to perform particle SpawnInstruction");
            }
        }
    }
}

