/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.fabric.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_2396;
import net.minecraft.class_304;
import net.minecraft.class_4002;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.client.input.Keybindings;
import net.spell_engine.client.particle.ShiftedParticle;
import net.spell_engine.client.particle.SpellAreaParticle;
import net.spell_engine.client.particle.SpellExplosionParticle;
import net.spell_engine.client.particle.SpellFlameParticle;
import net.spell_engine.client.particle.SpellSmokeParticle;
import net.spell_engine.client.particle.SpellSnowflakeParticle;
import net.spell_engine.client.particle.SpellUniversalParticle;
import net.spell_engine.client.particle.UniversalSpellParticle;
import net.spell_engine.client.render.CustomModelRegistry;
import net.spell_engine.client.render.SpellCloudRenderer;
import net.spell_engine.client.render.SpellProjectileRenderer;
import net.spell_engine.entity.SpellCloud;
import net.spell_engine.entity.SpellProjectile;
import net.spell_engine.fx.SpellEngineParticles;

public class FabricClientMod
implements ClientModInitializer {
    public void onInitializeClient() {
        SpellEngineClient.initialize();
        this.registerKeyBindings();
        ItemTooltipCallback.EVENT.register((itemStack, tooltipContext, tooltipType, lines) -> SpellTooltip.addSpellLines(itemStack, tooltipType, lines));
        EntityRendererRegistry.register(SpellProjectile.ENTITY_TYPE, SpellProjectileRenderer::new);
        EntityRendererRegistry.register(SpellCloud.ENTITY_TYPE, SpellCloudRenderer::new);
        this.registerParticleAppearances();
    }

    private void registerParticleAppearances() {
        for (SpellEngineParticles.MagicParticleFamily.Variant variant : SpellEngineParticles.MAGIC_FAMILY_VARIANTS.get()) {
            ParticleFactoryRegistry.getInstance().register(variant.particleType(), provider -> new UniversalSpellParticle.MagicVariant((class_4002)provider, variant));
        }
        ParticleFactoryRegistry.getInstance().register((class_2396)SpellEngineParticles.flame.particleType(), SpellFlameParticle.FlameFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)SpellEngineParticles.flame_spark.particleType(), SpellFlameParticle.AnimatedFlameFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)SpellEngineParticles.flame_ground.particleType(), SpellFlameParticle.AnimatedFlameFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)SpellEngineParticles.flame_medium_a.particleType(), SpellFlameParticle.MediumFlameFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)SpellEngineParticles.flame_medium_b.particleType(), SpellFlameParticle.MediumFlameFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)SpellEngineParticles.snowflake.particleType(), SpellSnowflakeParticle.FrostFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)SpellEngineParticles.frost_shard.particleType(), SpellFlameParticle.FrostShard::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)SpellEngineParticles.electric_arc_A.particleType(), SpellFlameParticle.ElectricSparkFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)SpellEngineParticles.electric_arc_B.particleType(), SpellFlameParticle.ElectricSparkFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)SpellEngineParticles.smoke_medium.particleType(), SpellFlameParticle.SmokeFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)SpellEngineParticles.weakness_smoke.particleType(), SpellFlameParticle.WeaknessSmokeFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)SpellEngineParticles.sign_charge.particleType(), SpellFlameParticle.RageSignFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)SpellEngineParticles.shield_small.particleType(), provider -> new UniversalSpellParticle.Opaque((class_4002)provider, SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE));
        ParticleFactoryRegistry.getInstance().register((class_2396)SpellEngineParticles.dripping_blood.particleType(), SpellSnowflakeParticle.DrippingBloodFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)SpellEngineParticles.roots.particleType(), ShiftedParticle.RootsFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)SpellEngineParticles.fire_explosion.particleType(), SpellExplosionParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)SpellEngineParticles.smoke_large.particleType(), SpellSmokeParticle.CosySmokeFactory::new);
        for (SpellEngineParticles.TemplateEntry templateEntry : SpellEngineParticles.areaEffects()) {
            ParticleFactoryRegistry.getInstance().register((class_2396)templateEntry.particleType(), provider -> new SpellAreaParticle.Factory((class_4002)provider, entry.texture(), entry.fading()));
        }
        for (SpellEngineParticles.TemplateEntry templateEntry : SpellEngineParticles.signEffects()) {
            ParticleFactoryRegistry.getInstance().register((class_2396)templateEntry.particleType(), provider -> new SpellFlameParticle.SignFactory((class_4002)provider, entry.texture()));
        }
        for (SpellEngineParticles.MagicParticles.Variant variant : SpellEngineParticles.MagicParticles.all) {
            ParticleFactoryRegistry.getInstance().register((class_2396)variant.entry().particleType(), provider -> new SpellUniversalParticle.MagicVariant((class_4002)provider, variant));
        }
        ModelLoadingPlugin.register(pluginCtx -> pluginCtx.addModels(CustomModelRegistry.modelIds));
    }

    private void registerKeyBindings() {
        for (class_304 keybinding : Keybindings.all()) {
            KeyBindingHelper.registerKeyBinding((class_304)keybinding);
        }
    }
}

