/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.compat.trinkets;

import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.event.TrinketEquipCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.spell_engine.api.item.trinket.ISpellBookItem;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_engine.compat.container.ContainerCompat;
import net.spell_engine.internals.container.SpellContainerSource;

public class TrinketsCompat {
    private static boolean intialized = false;
    private static boolean enabled = false;

    public static void init() {
        if (intialized) {
            return;
        }
        enabled = FabricLoader.getInstance().isModLoaded("trinkets");
        if (enabled) {
            TrinketsApi.registerTrinketPredicate((class_2960)class_2960.method_60655((String)"spell_engine", (String)"spell_book"), (itemStack, slotReference, livingEntity) -> {
                if (ISpellBookItem.isSpellBook(itemStack.method_7909())) {
                    return TriState.TRUE;
                }
                return TriState.DEFAULT;
            });
            ContainerCompat.addProvider(TrinketsCompat::getAll);
            String spellSourceName = "trinkets";
            SpellContainerSource.addSource(new SpellContainerSource.Entry("trinkets", TrinketsCompat::getSpellContainers, TrinketsCompat::getAll), SpellContainerSource.MAIN_HAND.name());
            TrinketEquipCallback.EVENT.register((stack, slot, entity) -> {
                if (entity instanceof class_1657) {
                    class_1657 player = (class_1657)entity;
                    SpellContainerSource.setDirty(player, "trinkets");
                }
            });
        }
        intialized = true;
    }

    private static List<class_1799> getAll(class_1657 player) {
        Optional component = TrinketsApi.getTrinketComponent((class_1309)player);
        if (component.isEmpty()) {
            return List.of();
        }
        TrinketComponent trinketComponent = (TrinketComponent)component.get();
        return trinketComponent.getAllEquipped().stream().map(reference -> (class_1799)reference.method_15441()).toList();
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static List<SpellContainerSource.SourcedContainer> getSpellContainers(class_1657 player, String sourceName) {
        Optional component = TrinketsApi.getTrinketComponent((class_1309)player);
        if (component.isEmpty()) {
            return List.of();
        }
        ArrayList<SpellContainerSource.SourcedContainer> spellBooks = new ArrayList<SpellContainerSource.SourcedContainer>();
        ArrayList others = new ArrayList();
        TrinketComponent trinketComponent = (TrinketComponent)component.get();
        trinketComponent.getAllEquipped().forEach(pair -> {
            class_1799 stack = (class_1799)pair.method_15441();
            if (stack.method_7960()) {
                return;
            }
            SpellContainer container = SpellContainerHelper.containerFromItemStack(stack);
            if (container != null && container.isValid()) {
                if (((SlotReference)pair.method_15442()).getId().contains("spell/book")) {
                    spellBooks.add(new SpellContainerSource.SourcedContainer(sourceName, stack, container));
                } else {
                    others.add(new SpellContainerSource.SourcedContainer(sourceName, stack, container));
                }
            }
        });
        spellBooks.addAll(others);
        return spellBooks;
    }

    public static class_1799 getSpellBookStack(class_1657 player) {
        if (!enabled) {
            return class_1799.field_8037;
        }
        Optional component = TrinketsApi.getTrinketComponent((class_1309)player);
        if (component.isEmpty()) {
            return class_1799.field_8037;
        }
        return ((TrinketInventory)((Map)((TrinketComponent)component.get()).getInventory().get("spell")).get("book")).method_5438(0);
    }
}

