/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.particle;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2400;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4955;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.spell_engine.client.particle.TemplateParticleEffect;
import net.spell_engine.client.particle.TemplateParticleType;
import net.spell_engine.client.util.Color;
import net.spell_engine.fx.SpellEngineParticles;
import net.spell_power.api.SpellSchools;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class SpellFlameParticle
extends class_4955 {
    boolean glow = true;
    boolean translucent = false;
    private class_4002 spriteProviderForAnimation = null;
    @Nullable
    class_1297 followEntity;

    public SpellFlameParticle(class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
        super(clientWorld, d, e, f, g, h, i);
    }

    public class_3999 method_18122() {
        return this.translucent ? class_3999.field_17829 : class_3999.field_17830;
    }

    public void method_3069(double dx, double dy, double dz) {
        if (this.followEntity != null && !this.followEntity.method_31481()) {
            dx += this.followEntity.method_23317() - this.followEntity.field_6014;
            dy += this.followEntity.method_23318() - this.followEntity.field_6036;
            dz += this.followEntity.method_23321() - this.followEntity.field_5969;
        }
        this.method_3067(this.method_3064().method_989(dx, dy, dz));
        this.method_3072();
    }

    public float method_18132(float tickDelta) {
        float f = ((float)this.field_3866 + tickDelta) / (float)this.field_3847;
        return this.field_17867 * (1.0f - f * f * 0.5f);
    }

    public int method_3068(float tint) {
        if (this.glow) {
            return 255;
        }
        return super.method_3068(tint);
    }

    public void method_3070() {
        super.method_3070();
        if (this.spriteProviderForAnimation != null) {
            this.method_18142(this.spriteProviderForAnimation);
        }
    }

    private void moveWithFollowed() {
        if (this.followEntity != null && !this.followEntity.method_31481()) {
            this.field_3874 += this.followEntity.method_23317() - this.followEntity.field_6014;
            this.field_3854 += this.followEntity.method_23318() - this.followEntity.field_6036;
            this.field_3871 += this.followEntity.method_23321() - this.followEntity.field_5969;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class SignFactory
    implements class_707<TemplateParticleType> {
        private final class_4002 spriteProvider;
        private final SpellEngineParticles.Texture texture;

        public SignFactory(class_4002 spriteProvider, SpellEngineParticles.Texture texture) {
            this.spriteProvider = spriteProvider;
            this.texture = texture;
        }

        @Nullable
        public class_703 createParticle(TemplateParticleType particleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.method_18140(this.spriteProvider);
            particle.field_28786 = 0.6f;
            particle.field_17867 = 0.4f;
            particle.field_3841 = 0.9f;
            particle.translucent = true;
            particle.field_3861 = 1.0f;
            particle.field_3842 = 1.0f;
            particle.field_3859 = 1.0f;
            particle.field_3847 = this.texture.frames() > 1 ? this.texture.frames() : 40;
            TemplateParticleType.apply(particleType, (class_703)particle);
            TemplateParticleEffect.Appearance appearance = particleType.getAppearance();
            if (appearance != null) {
                Color color = appearance.color;
                if (color != null) {
                    particle.field_3841 *= appearance.color.alpha();
                }
                particle.field_17867 *= appearance.scale;
                particle.followEntity = appearance.entityFollowed;
            }
            return particle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class RageSignFactory
    extends PopupSignFactory {
        public RageSignFactory(class_4002 spriteProvider) {
            super(spriteProvider, Color.RAGE);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class PopupSignFactory
    implements class_707<class_2400> {
        private final class_4002 spriteProvider;
        public Color color = Color.from(0xFFFFFF);

        public PopupSignFactory(class_4002 spriteProvider, Color color) {
            this.spriteProvider = spriteProvider;
            this.color = color;
        }

        @Nullable
        public class_703 createParticle(class_2400 SimpleParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.method_18140(this.spriteProvider);
            particle.method_3084(this.color.red(), this.color.green(), this.color.blue());
            particle.field_28786 = 0.6f;
            particle.field_17867 = 0.4f;
            particle.field_3847 = 40;
            particle.field_3841 = 0.9f;
            particle.translucent = true;
            return particle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class BuffRageFactory
    extends BuffFactory {
        public BuffRageFactory(class_4002 spriteProvider) {
            super(spriteProvider, Color.RAGE);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class BuffFactory
    implements class_707<class_2400> {
        private final class_4002 spriteProvider;
        public Color color = Color.from(0xFFFFFF);

        public BuffFactory(class_4002 spriteProvider, Color color) {
            this.spriteProvider = spriteProvider;
            this.color = color;
        }

        @Nullable
        public class_703 createParticle(class_2400 SimpleParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.method_18140(this.spriteProvider);
            float j = clientWorld.field_9229.method_43057() * 0.5f + 0.35f;
            particle.method_3084(this.color.red() * j, this.color.green() * j, this.color.blue() * j);
            particle.field_3847 = 16;
            particle.translucent = true;
            return particle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class NatureSlowingFactory
    extends NatureFactory {
        public NatureSlowingFactory(class_4002 spriteProvider) {
            super(spriteProvider);
        }

        @Override
        @Nullable
        public class_703 createParticle(class_2400 SimpleParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = (SpellFlameParticle)super.createParticle(SimpleParticleType, clientWorld, d, e, f, g, h, i);
            particle.field_28786 = 0.8f;
            return particle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class WhiteFactory
    extends ColorableFactory {
        public WhiteFactory(class_4002 spriteProvider) {
            super(spriteProvider, Color.WHITE);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class NatureFactory
    extends ColorableFactory {
        public NatureFactory(class_4002 spriteProvider) {
            super(spriteProvider, Color.NATURE);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class HolyFactory
    extends ColorableFactory {
        public HolyFactory(class_4002 spriteProvider) {
            super(spriteProvider, Color.HOLY);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class HealingFactory
    extends ColorableFactory {
        public HealingFactory(class_4002 spriteProvider) {
            super(spriteProvider, Color.from(SpellSchools.HEALING.color));
        }
    }

    public static class ColorableFactory
    implements class_707<class_2400> {
        private final class_4002 spriteProvider;
        public Color color = Color.from(0xFFFFFF);

        public ColorableFactory(class_4002 spriteProvider, Color color) {
            this.spriteProvider = spriteProvider;
            this.color = color;
        }

        @Nullable
        public class_703 createParticle(class_2400 SimpleParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.method_18140(this.spriteProvider);
            float j = clientWorld.field_9229.method_43057() * 0.5f + 0.35f;
            particle.method_3084(this.color.red() * j, this.color.green() * j, this.color.blue() * j);
            return particle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class FrostShard
    implements class_707<class_2400> {
        private final class_4002 spriteProvider;
        public static Color color = Color.FROST;

        public FrostShard(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public class_703 createParticle(class_2400 SimpleParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.method_18140(this.spriteProvider);
            float j = clientWorld.field_9229.method_43057() * 0.5f + 0.35f;
            particle.method_3084(color.red() * j, color.green() * j, color.blue() * j);
            particle.field_3869 *= clientWorld.field_9229.method_43057() * 0.2f + 0.9f;
            particle.field_3847 = Math.round(clientWorld.field_9229.method_43057() * 3.0f) + 5;
            return particle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class MediumFlameFactory
    implements class_707<class_2400> {
        private final class_4002 spriteProvider;

        public MediumFlameFactory(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public class_703 createParticle(class_2400 SimpleParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.method_18140(this.spriteProvider);
            particle.spriteProviderForAnimation = this.spriteProvider;
            particle.field_17867 = 0.5f;
            particle.field_3847 = (int)((double)particle.field_3847 * 0.5);
            return particle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class WeaknessSmokeFactory
    implements class_707<class_2400> {
        private final class_4002 spriteProvider;
        public Color color = Color.from(0x993333);

        public WeaknessSmokeFactory(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public class_703 createParticle(class_2400 SimpleParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.method_18140(this.spriteProvider);
            float j = clientWorld.field_9229.method_43057() * 0.5f + 0.35f;
            particle.method_3084(this.color.red() * j, this.color.green() * j, this.color.blue() * j);
            particle.spriteProviderForAnimation = this.spriteProvider;
            particle.field_28786 = 0.8f;
            particle.method_3083(0.7f);
            particle.glow = false;
            particle.field_3844 = 0.01f;
            return particle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class SmokeFactory
    implements class_707<TemplateParticleType> {
        private final class_4002 spriteProvider;

        public SmokeFactory(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public class_703 createParticle(TemplateParticleType templateParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.method_18140(this.spriteProvider);
            particle.method_3084(1.0f, 1.0f, 1.0f);
            TemplateParticleType.apply(templateParticleType, (class_703)particle);
            float j = clientWorld.field_9229.method_43057() * 0.5f + 0.35f;
            particle.method_3084(particle.field_3861 * j, particle.field_3842 * j, particle.field_3859 * j);
            particle.spriteProviderForAnimation = this.spriteProvider;
            particle.field_28786 = 0.8f;
            particle.field_3841 *= 0.8f;
            particle.glow = false;
            particle.field_3844 = -0.01f;
            return particle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ElectricSparkFactory
    extends ColoredAnimatedFactory {
        public ElectricSparkFactory(class_4002 spriteProvider) {
            super(Color.ELECTRIC, 0.75f, spriteProvider);
            this.randomColorRange = 0.0f;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ColoredAnimatedFactory
    implements class_707<class_2400> {
        private final class_4002 spriteProvider;
        private final Color color;
        private final float scale;
        protected float randomColorFloor = 0.5f;
        protected float randomColorRange = 0.35f;

        public ColoredAnimatedFactory(Color color, float scale, class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
            this.color = color;
            this.scale = scale;
        }

        public class_703 createParticle(class_2400 SimpleParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.method_18140(this.spriteProvider);
            particle.spriteProviderForAnimation = this.spriteProvider;
            float red = this.color.red();
            float green = this.color.green();
            float blue = this.color.blue();
            if (this.randomColorRange > 0.0f) {
                red = (clientWorld.field_9229.method_43057() * this.randomColorFloor + this.randomColorRange) * red;
                green = (clientWorld.field_9229.method_43057() * this.randomColorFloor + this.randomColorRange) * green;
                blue = (clientWorld.field_9229.method_43057() * this.randomColorFloor + this.randomColorRange) * blue;
            }
            float j = clientWorld.field_9229.method_43057() * 0.5f + 0.35f;
            particle.method_3084(red, green, blue);
            particle.field_17867 = this.scale;
            particle.method_3083(1.0f);
            return particle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class AnimatedFlameFactory
    implements class_707<class_2400> {
        private final class_4002 spriteProvider;

        public AnimatedFlameFactory(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public class_703 createParticle(class_2400 SimpleParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.method_18140(this.spriteProvider);
            particle.spriteProviderForAnimation = this.spriteProvider;
            return particle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class FlameFactory
    implements class_707<class_2400> {
        private final class_4002 spriteProvider;

        public FlameFactory(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public class_703 createParticle(class_2400 SimpleParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.method_18140(this.spriteProvider);
            return particle;
        }
    }
}

