/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.particle;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.spell_engine.client.particle.TemplateParticleEffect;
import net.spell_engine.client.particle.TemplateParticleType;
import net.spell_engine.client.util.Color;
import net.spell_engine.fx.SpellEngineParticles;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class SpellAreaParticle
extends class_4003 {
    @Nullable
    class_1297 followEntity;
    public SpellEngineParticles.Fading fading = SpellEngineParticles.Fading.NONE;
    private final class_4002 spriteProvider;
    private float initialAlpha = 1.0f;
    public boolean grounded = false;
    private static final float EASE_DURATION = 0.3f;
    private static final float EASE_DURATION_INVERSE = 3.3333333f;

    protected SpellAreaParticle(class_638 world, double d, double e, double f, double g, double h, double i, class_4002 spriteProvider) {
        super(world, d, e, f, g, h, i);
        this.spriteProvider = spriteProvider;
        this.method_18142(spriteProvider);
    }

    public int method_3068(float tint) {
        return 255;
    }

    public void method_3069(double dx, double dy, double dz) {
        if (this.grounded && this.followEntity != null && !this.followEntity.method_31481()) {
            this.method_3063(this.followEntity.method_23317(), this.followEntity.method_23318() + (double)0.05f, this.followEntity.method_23321());
            class_243 velocity = this.followEntity.method_18798();
            this.field_3852 = velocity.field_1352;
            this.field_3869 = velocity.field_1351;
            this.field_3850 = velocity.field_1350;
        } else {
            if (this.followEntity != null && !this.followEntity.method_31481()) {
                dx += this.followEntity.method_23317() - this.followEntity.field_6014;
                dy += this.followEntity.method_23318() - this.followEntity.field_6036;
                dz += this.followEntity.method_23321() - this.followEntity.field_5969;
            }
            this.method_3067(this.method_3064().method_989(dx, dy, dz));
            this.method_3072();
        }
    }

    public void method_3070() {
        super.method_3070();
        if (this.field_3866 < this.field_3847) {
            this.method_18142(this.spriteProvider);
            this.updateAlpha(this.fading, this.initialAlpha);
        }
    }

    private void updateAlpha(SpellEngineParticles.Fading fading, float initialAlpha) {
        switch (fading) {
            case NONE: {
                return;
            }
            case IN: {
                float progress = (float)this.field_3866 / (float)this.field_3847;
                this.field_3841 = initialAlpha * Math.min(1.0f, progress * 3.3333333f);
                break;
            }
            case OUT: {
                float progress = (float)this.field_3866 / (float)this.field_3847;
                this.field_3841 = initialAlpha * Math.min(1.0f, (1.0f - progress) * 3.3333333f);
                break;
            }
            case IN_OUT: {
                float progress = (float)this.field_3866 / (float)this.field_3847;
                this.field_3841 = initialAlpha * Math.min(1.0f, Math.min(progress, 1.0f - progress) * 3.3333333f);
            }
        }
    }

    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float tickDelta) {
        Quaternionf quaternion2;
        class_243 vec3d = camera.method_19326();
        float f = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3858, (double)this.field_3874) - vec3d.method_10216());
        float g = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3838, (double)this.field_3854) - vec3d.method_10214());
        float h = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3856, (double)this.field_3871) - vec3d.method_10215());
        if (this.field_3839 == 0.0f) {
            quaternion2 = camera.method_23767();
        } else {
            quaternion2 = new Quaternionf((Quaternionfc)camera.method_23767());
            float i = class_3532.method_16439((float)tickDelta, (float)this.field_3857, (float)this.field_3839);
            quaternion2.rotateZ(i);
        }
        Vector3f vec3f = new Vector3f(-1.0f, -1.0f, 0.0f);
        vec3f.rotate((Quaternionfc)quaternion2);
        Vector3f[] Vec3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float j = this.method_18132(tickDelta);
        for (int k = 0; k < 4; ++k) {
            Vector3f Vec3f2 = Vec3fs[k];
            Vec3f2.rotate((Quaternionfc)new Quaternionf().rotateXYZ((float)Math.toRadians(90.0), -0.0f, 0.0f));
            Vec3f2.mul(j);
            Vec3f2.add(f, g, h);
        }
        float minU = this.method_18133();
        float maxU = this.method_18134();
        float minV = this.method_18135();
        float maxV = this.method_18136();
        int l = this.method_3068(tickDelta);
        vertexConsumer.method_22912(Vec3fs[0].x(), Vec3fs[0].y(), Vec3fs[0].z()).method_22913(maxU, maxV).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_60803(l);
        vertexConsumer.method_22912(Vec3fs[1].x(), Vec3fs[1].y(), Vec3fs[1].z()).method_22913(maxU, minV).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_60803(l);
        vertexConsumer.method_22912(Vec3fs[2].x(), Vec3fs[2].y(), Vec3fs[2].z()).method_22913(minU, minV).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_60803(l);
        vertexConsumer.method_22912(Vec3fs[3].x(), Vec3fs[3].y(), Vec3fs[3].z()).method_22913(minU, maxV).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_60803(l);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Factory
    implements class_707<TemplateParticleType> {
        private final class_4002 spriteProvider;
        private final SpellEngineParticles.Texture texture;
        private final SpellEngineParticles.Fading fading;

        public Factory(class_4002 spriteProvider, SpellEngineParticles.Texture texture, SpellEngineParticles.Fading fading) {
            this.spriteProvider = spriteProvider;
            this.texture = texture;
            this.fading = fading;
        }

        public class_703 createParticle(TemplateParticleType particleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellAreaParticle particle = new SpellAreaParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
            particle.field_3852 = g;
            particle.field_3869 = h;
            particle.field_3850 = i;
            particle.field_28787 = false;
            particle.field_3861 = 1.0f;
            particle.field_3842 = 1.0f;
            particle.field_3859 = 1.0f;
            if (this.texture.frames() > 1) {
                particle.field_3847 = this.texture.frames();
            } else {
                particle.field_3847 = 16;
            }
            particle.field_17867 = 1.0f;
            TemplateParticleType.apply(particleType, (class_703)particle);
            TemplateParticleEffect.Appearance appearance = particleType.getAppearance();
            if (appearance != null) {
                Color color = appearance.color;
                if (color != null) {
                    particle.field_3841 *= appearance.color.alpha();
                }
                particle.field_17867 *= appearance.scale;
                particle.field_3847 = (int)((float)particle.field_3847 * appearance.max_age);
                particle.followEntity = appearance.entityFollowed;
                particle.grounded = appearance.grounded;
            }
            particle.fading = this.fading;
            particle.initialAlpha = particle.field_3841;
            return particle;
        }
    }
}

