/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.input;

import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1766;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2596;
import net.minecraft.class_2846;
import net.minecraft.class_310;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_engine.compat.trinkets.TrinketsCompat;
import net.spell_engine.utils.AttributeModifierUtil;
import org.jetbrains.annotations.Nullable;

public class AutoSwapHelper {
    public static boolean autoSwapForAttack() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || player.method_7325()) {
            return false;
        }
        class_1799 mainHand = player.method_6047();
        class_1799 offHand = (class_1799)player.method_31548().field_7544.get(0);
        if (mainHand.method_7960() || offHand.method_7960() || AutoSwapHelper.isPlaceable(mainHand) || !AutoSwapHelper.isAnyWeapon(mainHand) || !AutoSwapHelper.hasSpells(mainHand) && !AutoSwapHelper.isUsable(mainHand)) {
            return false;
        }
        if (!AutoSwapHelper.isMeleeWeapon(mainHand) && AutoSwapHelper.isMeleeWeapon(offHand)) {
            AutoSwapHelper.swapHeldItems();
            return true;
        }
        return false;
    }

    public static boolean autoSwapForSpells() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || player.method_7325()) {
            return false;
        }
        class_1799 mainHand = player.method_6047();
        class_1799 offHand = (class_1799)player.method_31548().field_7544.get(0);
        if (mainHand.method_7960() || offHand.method_7960() || AutoSwapHelper.isUsable(mainHand) || !AutoSwapHelper.isAnyWeapon(mainHand) || !AutoSwapHelper.isAnyWeapon(offHand)) {
            return false;
        }
        SpellContainer.ContentType mainHandType = AutoSwapHelper.spellContentType(mainHand);
        SpellContainer.ContentType offHandType = AutoSwapHelper.spellContentType(offHand);
        SpellContainer.ContentType spellbookType = AutoSwapHelper.spellContentType(TrinketsCompat.getSpellBookStack((class_1657)player));
        if (spellbookType != null && !AutoSwapHelper.hasSpells(mainHand) && mainHandType != spellbookType && offHandType == spellbookType) {
            AutoSwapHelper.swapHeldItems();
            return true;
        }
        return false;
    }

    public static void swapHeldItems() {
        class_310.method_1551().method_1562().method_52787((class_2596)new class_2846(class_2846.class_2847.field_12969, class_2338.field_10980, class_2350.field_11033));
    }

    public static boolean isPlaceable(class_1799 itemStack) {
        return itemStack.method_7909() instanceof class_1747;
    }

    public static boolean isUsable(class_1799 itemStack) {
        return itemStack.method_7976() != class_1839.field_8952 || itemStack.method_7909() instanceof class_1766;
    }

    public static boolean isMeleeWeapon(class_1799 itemStack) {
        return AttributeModifierUtil.hasModifier(itemStack, (class_6880<class_1320>)class_5134.field_23721) && AttributeModifierUtil.hasModifier(itemStack, (class_6880<class_1320>)class_5134.field_23723);
    }

    public static boolean isAnyWeapon(class_1799 itemStack) {
        if (AutoSwapHelper.isMeleeWeapon(itemStack)) {
            return true;
        }
        return FabricLoader.getInstance().isModLoaded("ranged_weapon_api") && AttributeModifierUtil.hasModifier(itemStack, (class_6880<class_1320>)EntityAttributes_RangedWeapon.DAMAGE.entry);
    }

    @Nullable
    private static SpellContainer.ContentType spellContentType(class_1799 itemStack) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        if (container != null) {
            return container.content();
        }
        return null;
    }

    private static boolean hasSpells(class_1799 itemStack) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        if (container != null) {
            return !container.spell_ids().isEmpty();
        }
        return false;
    }
}

