/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.gui;

import com.ibm.icu.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.mixin.client.keybinding.KeyBindingAccessor;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.api.tags.SpellEngineItemTags;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.input.Keybindings;
import net.spell_engine.config.ClientConfig;
import net.spell_engine.config.ServerConfig;
import net.spell_engine.internals.Ammo;
import net.spell_engine.internals.SpellHelper;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;

public class SpellTooltip {
    public static final String damageToken = "damage";
    public static final String healToken = "heal";
    public static final String rangeToken = "range";
    public static final String durationToken = "duration";
    public static final String itemToken = "item";
    public static final String effectDurationToken = "effect_duration";
    public static final String effectAmplifierToken = "effect_amplifier";
    public static final String effectAmplifierCapToken = "effect_amplifier_cap";
    public static final String impactRangeToken = "impact_range";
    public static final String teleportDistanceToken = "teleport_distance";
    public static final String countToken = "count";
    public static final String trigger_chance = "trigger_chance";
    public static final String trigger_list = "trigger_list";
    private static final Map<class_2960, DescriptionMutator> descriptionMutators = new HashMap<class_2960, DescriptionMutator>();

    public static String placeholder(String token) {
        return "{" + token + "}";
    }

    /*
     * WARNING - void declaration
     */
    public static void addSpellLines(class_1799 itemStack, class_1836 tooltipType, List<class_2561> lines) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        int addSectionDivider = 0;
        ClientConfig config = SpellEngineClient.config;
        ArrayList<Object> spellTextLines = new ArrayList<Object>();
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        if (container != null && container.isValid()) {
            int indentLevel;
            if (container.is_proxy() && config.showSpellBookSuppportTooltip) {
                switch (container.content()) {
                    case MAGIC: {
                        spellTextLines.add(class_2561.method_43471((String)"spell.tooltip.host.proxy.spell").method_27692(class_124.field_1080));
                        break;
                    }
                    case ARCHERY: {
                        spellTextLines.add(class_2561.method_43471((String)"spell.tooltip.host.proxy.archery").method_27692(class_124.field_1080));
                    }
                }
                ++addSectionDivider;
            }
            List<Object> spells = List.of();
            class_638 world = class_310.method_1551().field_1687;
            if (world != null) {
                spells = container.spell_ids().stream().map(idString -> {
                    class_2960 spellId = class_2960.method_60654((String)idString);
                    Optional optionalSpellEntry = SpellRegistry.from((class_1937)world).method_55841(spellId);
                    if (optionalSpellEntry.isPresent()) {
                        return (class_6880)optionalSpellEntry.get();
                    }
                    return null;
                }).filter(Objects::nonNull).toList();
            }
            boolean forceHideHeader = itemStack.method_31573(SpellEngineItemTags.SPELL_BOOK_MERGEABLE);
            boolean showListHeader = false;
            if (!forceHideHeader) {
                for (class_6880 class_68802 : spells) {
                    Spell spell = (Spell)class_68802.comp_349();
                    Spell.Tooltip tooltip = spell.tooltip != null ? spell.tooltip : Spell.Tooltip.DEFAULT;
                    showListHeader = showListHeader || tooltip.show_header;
                }
            }
            int n = indentLevel = showListHeader ? 1 : 0;
            if (!spells.isEmpty() && showListHeader) {
                void var13_22;
                String string = "";
                if (container.max_spell_count() > 0) {
                    String string2 = class_1074.method_4662((String)"spell.tooltip.host.limit", (Object[])new Object[0]).replace(SpellTooltip.placeholder("current"), "" + container.spell_ids().size()).replace(SpellTooltip.placeholder("max"), "" + container.max_spell_count());
                }
                String key = "spell.tooltip.host.list.spell";
                switch (container.content()) {
                    case MAGIC: {
                        key = "spell.tooltip.host.list.spell";
                        break;
                    }
                    case ARCHERY: {
                        key = "spell.tooltip.host.list.archery";
                    }
                }
                spellTextLines.add(class_2561.method_43471((String)key).method_10852((class_2561)class_2561.method_43470((String)(" " + (String)var13_22))).method_27692(class_124.field_1080));
                ++addSectionDivider;
            }
            class_304 class_3042 = Keybindings.bypass_spell_hotbar;
            boolean showDetails = config.alwaysShowFullTooltip || !class_3042.method_1415() && class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)((KeyBindingAccessor)class_3042).fabric_getBoundKey().method_1444());
            for (int i = 0; i < spells.size(); ++i) {
                class_6880 spellEntry = (class_6880)spells.get(i);
                List<class_2561> info = SpellTooltip.spellEntry((class_6880<Spell>)spellEntry, (class_1657)player, itemStack, showDetails, indentLevel);
                if (info.isEmpty()) continue;
                if (i > 0 && showDetails) {
                    spellTextLines.add(class_2561.method_43470((String)" "));
                }
                spellTextLines.addAll(info);
            }
            if (!showDetails) {
                if (!class_3042.method_1415() && container.spell_ids().size() > 0) {
                    spellTextLines.add(class_2561.method_43469((String)"spell.tooltip.hold_for_details", (Object[])new Object[]{class_3042.method_16007()}).method_27692(class_124.field_1063));
                }
                if (config.showSpellBindingTooltip && container.pool() != null && !container.pool().isEmpty() && container.spell_ids().isEmpty()) {
                    spellTextLines.add(class_2561.method_43471((String)"spell.tooltip.spell_binding_tip").method_27692(class_124.field_1080));
                }
            }
        }
        if (spellTextLines.isEmpty()) {
            return;
        }
        int found = 0;
        if (tooltipType.method_8035()) {
            class_2583 searchedStyle = class_2561.method_43470((String)"x").method_27692(class_124.field_1063).method_10866();
            int reverseIndex = lines.size();
            for (class_2561 line : lines.reversed()) {
                --reverseIndex;
                class_2583 class_25832 = line.method_10866();
                if (class_25832 == null) continue;
                boolean newFind = searchedStyle.method_10973().equals((Object)class_25832.method_10973());
                if (found != 0 && !newFind) break;
                found = reverseIndex;
            }
        }
        if (found <= 0) {
            if (addSectionDivider > 0) {
                spellTextLines.addFirst(class_2561.method_43470((String)""));
            }
            lines.addAll(spellTextLines);
        } else {
            if (addSectionDivider > 0) {
                boolean hasPreceedignEmptyLine = false;
                if (found > 0) {
                    String previousLine = lines.get(found - 1).getString();
                    hasPreceedignEmptyLine = previousLine.isBlank();
                }
                if (!hasPreceedignEmptyLine) {
                    spellTextLines.addFirst(class_2561.method_43470((String)""));
                }
            }
            lines.addAll(found, spellTextLines);
        }
    }

    public static List<class_2561> spellEntry(class_2960 spellId, class_1657 player, class_1799 itemStack, boolean details, int indentLevel) {
        class_1937 world = player.method_37908();
        if (world == null) {
            return List.of();
        }
        Optional optionalSpellEntry = SpellRegistry.from(world).method_55841(spellId);
        if (optionalSpellEntry.isEmpty()) {
            return List.of();
        }
        return SpellTooltip.spellEntry((class_6880<Spell>)((class_6880)optionalSpellEntry.get()), player, itemStack, details, indentLevel);
    }

    public static List<class_2561> spellEntry(class_6880<Spell> spellEntry, class_1657 player, class_1799 itemStack, boolean details, int indentLevel) {
        class_124 color;
        Spell.Tooltip tooltipData;
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        Spell spell = (Spell)spellEntry.comp_349();
        class_2960 spellId = ((class_5321)spellEntry.method_40230().get()).method_29177();
        SpellPower.Result primaryPower = SpellPower.getSpellPower((SpellSchool)spell.school, (class_1309)player);
        Spell.Tooltip tooltip = tooltipData = spell.tooltip != null ? spell.tooltip : Spell.Tooltip.DEFAULT;
        if (SpellTooltip.shouldShow(tooltipData.name, details)) {
            String group;
            color = class_124.method_533((String)tooltipData.name.color);
            class_5250 name = class_2561.method_43471((String)SpellTooltip.spellTranslationKey(spellId)).method_27692(class_124.field_1067).method_27692(color);
            if (spell.group != null && !(group = SpellTooltip.spellGroup(spell.group)).isEmpty()) {
                name.method_10852((class_2561)class_2561.method_43470((String)(" " + group))).method_27692(color);
            }
            lines.add((class_2561)SpellTooltip.indentation(indentLevel).method_10852((class_2561)name));
            ++indentLevel;
        }
        if (SpellTooltip.shouldShow(tooltipData.description, details)) {
            color = class_124.method_533((String)tooltipData.description.color);
            String description = SpellTooltip.createDescription(spellEntry, spellId, player, itemStack, spell, primaryPower);
            lines.add((class_2561)SpellTooltip.indentation(indentLevel).method_10852((class_2561)class_2561.method_43471((String)description)).method_27692(color));
        }
        if (details) {
            Ammo.Result ammoResult;
            float cooldownDuration;
            Spell.Passive passive;
            Spell.Active active = spell.active;
            if (active != null && active.cast != null) {
                if (SpellHelper.isInstant(spell)) {
                    lines.add((class_2561)SpellTooltip.indentation(indentLevel).method_10852((class_2561)class_2561.method_43471((String)"spell.tooltip.cast_instant")).method_27692(class_124.field_1065));
                } else {
                    float castDuration = SpellHelper.getCastDuration((class_1309)player, spell, itemStack);
                    String castTimeKey = SpellTooltip.keyWithPlural("spell.tooltip.cast_time", castDuration);
                    String castTime = class_1074.method_4662((String)castTimeKey, (Object[])new Object[0]).replace(SpellTooltip.placeholder(durationToken), SpellTooltip.formattedNumber(castDuration));
                    lines.add((class_2561)SpellTooltip.indentation(indentLevel).method_10852((class_2561)class_2561.method_43470((String)castTime)).method_27692(class_124.field_1065));
                }
            }
            if ((passive = spell.passive) != null && !passive.triggers.isEmpty()) {
                List<String> triggerList = passive.triggers.stream().map(trigger -> "spell.tooltip.trigger." + trigger.type.toString().toLowerCase(Locale.ENGLISH)).map(x$0 -> class_1074.method_4662((String)x$0, (Object[])new Object[0])).toList();
                String joinedTriggers = String.join((CharSequence)", ", triggerList);
                String triggerText = class_1074.method_4662((String)"spell.tooltip.trigger.base", (Object[])new Object[0]).replace(SpellTooltip.placeholder(trigger_list), joinedTriggers);
                lines.add((class_2561)SpellTooltip.indentation(indentLevel).method_10852((class_2561)class_2561.method_43470((String)triggerText)).method_27692(class_124.field_1065));
            }
            if (spell.range > 0.0f || spell.range_mechanic != null) {
                String rangeText = "";
                if (spell.range_mechanic != null) {
                    switch (spell.range_mechanic) {
                        case MELEE: {
                            if (spell.range == 0.0f) {
                                rangeText = class_1074.method_4662((String)"spell.tooltip.range.melee", (Object[])new Object[0]);
                                break;
                            }
                            String key = spell.range > 0.0f ? "spell.tooltip.range.melee.plus" : "spell.tooltip.range.melee.minus";
                            String rangeKey = SpellTooltip.keyWithPlural(key, spell.range);
                            rangeText = class_1074.method_4662((String)rangeKey, (Object[])new Object[0]).replace(SpellTooltip.placeholder(rangeToken), SpellTooltip.formattedNumber(Math.abs(spell.range)));
                        }
                    }
                } else {
                    String rangeKey = SpellTooltip.keyWithPlural("spell.tooltip.range", spell.range);
                    rangeText = class_1074.method_4662((String)rangeKey, (Object[])new Object[0]).replace(SpellTooltip.placeholder(rangeToken), SpellTooltip.formattedNumber(spell.range));
                }
                lines.add((class_2561)SpellTooltip.indentation(indentLevel).method_10852((class_2561)class_2561.method_43470((String)rangeText)).method_27692(class_124.field_1065));
            }
            if ((cooldownDuration = SpellHelper.getCooldownDuration((class_1309)player, spell, itemStack)) > 0.0f) {
                String cooldown;
                if (spell.cost.cooldown.proportional) {
                    cooldown = class_1074.method_4662((String)"spell.tooltip.cooldown.proportional", (Object[])new Object[0]);
                } else {
                    String cooldownKey = SpellTooltip.keyWithPlural("spell.tooltip.cooldown", cooldownDuration);
                    cooldown = class_1074.method_4662((String)cooldownKey, (Object[])new Object[0]).replace(SpellTooltip.placeholder(durationToken), SpellTooltip.formattedNumber(cooldownDuration));
                }
                lines.add((class_2561)SpellTooltip.indentation(indentLevel).method_10852((class_2561)class_2561.method_43470((String)cooldown)).method_27692(class_124.field_1065));
            }
            boolean showItemCost = true;
            ServerConfig config = SpellEngineMod.config;
            if (config != null) {
                showItemCost = config.spell_cost_item_allowed;
            }
            if (showItemCost && (ammoResult = Ammo.ammoForSpell(player, spell, itemStack)).item() != null) {
                int amount = spell.cost.item.amount;
                String ammoKey = SpellTooltip.keyWithPlural("spell.tooltip.ammo", amount);
                String itemName = class_1074.method_4662((String)ammoResult.item().getTranslationKey(), (Object[])new Object[0]);
                String ammo = class_1074.method_4662((String)ammoKey, (Object[])new Object[0]).replace(SpellTooltip.placeholder(itemToken), itemName).replace(SpellTooltip.placeholder(countToken), "" + amount);
                lines.add((class_2561)SpellTooltip.indentation(indentLevel).method_10852((class_2561)class_2561.method_43470((String)ammo).method_27692(ammoResult.satisfied() ? class_124.field_1060 : class_124.field_1061)));
            }
        }
        return lines;
    }

    public static boolean shouldShow(Spell.Tooltip.LineOptions options, boolean details) {
        return details ? options.show_in_details : options.show_in_compact;
    }

    private static String createDescription(class_6880<Spell> spellEntry, class_2960 spellId, class_1657 player, class_1799 itemStack, Spell spell, SpellPower.Result primaryPower) {
        String description = class_1074.method_4662((String)(SpellTooltip.spellKeyPrefix(spellId) + ".description"), (Object[])new Object[0]);
        ArrayList<Spell.Trigger> triggers = new ArrayList<Spell.Trigger>();
        if (spell.passive != null) {
            triggers.addAll(spell.passive.triggers);
        }
        if (spell.deliver != null) {
            Spell.Delivery.Cloud cloud;
            int extra_launch_count;
            Spell.ProjectileData projectile = null;
            if (spell.deliver.projectile != null) {
                projectile = spell.deliver.projectile.projectile;
            }
            if (spell.deliver.meteor != null) {
                projectile = spell.deliver.meteor.projectile;
            }
            if (projectile != null) {
                if (projectile.perks.ricochet > 0) {
                    description = description.replace(SpellTooltip.placeholder("ricochet"), SpellTooltip.formattedNumber(projectile.perks.ricochet));
                }
                if (projectile.perks.bounce > 0) {
                    description = description.replace(SpellTooltip.placeholder("bounce"), SpellTooltip.formattedNumber(projectile.perks.bounce));
                }
                if (projectile.perks.pierce > 0) {
                    description = description.replace(SpellTooltip.placeholder("pierce"), SpellTooltip.formattedNumber(projectile.perks.pierce));
                }
                if (projectile.perks.chain_reaction_size > 0) {
                    description = description.replace(SpellTooltip.placeholder("chain_reaction_size"), SpellTooltip.formattedNumber(projectile.perks.chain_reaction_size));
                }
            }
            Object launchProperties = null;
            if (spell.deliver.projectile != null) {
                launchProperties = spell.deliver.projectile.launch_properties;
            }
            if (spell.deliver.meteor != null) {
                launchProperties = spell.deliver.meteor.launch_properties;
            }
            if (launchProperties != null && (extra_launch_count = ((Spell.LaunchProperties)launchProperties).extra_launch_count) > 0) {
                description = description.replace(SpellTooltip.placeholder("extra_launch"), SpellTooltip.formattedNumber(extra_launch_count));
            }
            if (spell.deliver.clouds != null && !spell.deliver.clouds.isEmpty() && (cloud = spell.deliver.clouds.get(0)) != null) {
                float cloud_duration = cloud.time_to_live_seconds;
                if (cloud_duration > 0.0f) {
                    description = description.replace(SpellTooltip.placeholder("cloud_duration"), SpellTooltip.formattedNumber(cloud_duration));
                }
                float radius = cloud.volume.combinedRadius(primaryPower.baseValue());
                description = description.replace(SpellTooltip.placeholder("cloud_radius"), SpellTooltip.formattedNumber(radius));
            }
            if (spell.deliver.stash_effect != null) {
                Spell.Delivery.StashEffect stash = spell.deliver.stash_effect;
                triggers.addAll(stash.triggers);
            }
        }
        if (spell.impacts != null) {
            SpellHelper.EstimatedOutput estimatedOutput = SpellHelper.estimate(spell, player, itemStack);
            for (Spell.Impact impact : spell.impacts) {
                switch (impact.action.type) {
                    case DAMAGE: {
                        description = SpellTooltip.replaceDamageTokens(description, damageToken, estimatedOutput.damage());
                        break;
                    }
                    case HEAL: {
                        description = SpellTooltip.replaceDamageTokens(description, healToken, estimatedOutput.heal());
                        break;
                    }
                    case STATUS_EFFECT: {
                        Spell.Impact.Action.StatusEffect statusEffect = impact.action.status_effect;
                        description = description.replace(SpellTooltip.placeholder(effectAmplifierToken), "" + (statusEffect.amplifier + 1));
                        if (statusEffect.amplifier_cap > 0) {
                            description = description.replace(SpellTooltip.placeholder(effectAmplifierCapToken), "" + (statusEffect.amplifier_cap + 1));
                        }
                        description = description.replace(SpellTooltip.placeholder(effectDurationToken), SpellTooltip.formattedNumber(statusEffect.duration));
                        break;
                    }
                    case TELEPORT: {
                        Spell.Impact.Action.Teleport teleport = impact.action.teleport;
                        switch (teleport.mode) {
                            case FORWARD: {
                                Spell.Impact.Action.Teleport.Forward forward = teleport.forward;
                                description = description.replace(SpellTooltip.placeholder(teleportDistanceToken), SpellTooltip.formattedNumber(forward.distance));
                            }
                        }
                    }
                }
            }
            Spell.AreaImpact area_impact = spell.area_impact;
            if (area_impact != null) {
                float radius = area_impact.combinedRadius(primaryPower.baseValue());
                description = description.replace(SpellTooltip.placeholder(impactRangeToken), SpellTooltip.formattedNumber(radius));
            }
        }
        List<String> triggerChances = triggers.stream().map(trigger -> SpellTooltip.percent(trigger.chance)).toList();
        description = SpellTooltip.replaceTokens(description, trigger_chance, triggerChances);
        DescriptionMutator mutator = descriptionMutators.get(spellId);
        if (mutator != null) {
            DescriptionMutator.Args args = new DescriptionMutator.Args(description, player, spellEntry);
            description = mutator.mutate(args);
        }
        return description;
    }

    private static class_5250 indentation(int level) {
        return class_2561.method_43470((String)(level > 0 ? " ".repeat(level) : ""));
    }

    private static String replaceDamageTokens(String text, String token, List<SpellHelper.EstimatedValue> values) {
        boolean indexTokens = values.size() > 1;
        for (int i = 0; i < values.size(); ++i) {
            SpellHelper.EstimatedValue range = values.get(i);
            String actualToken = indexTokens ? SpellTooltip.placeholder(token + "_" + (i + 1)) : SpellTooltip.placeholder(token);
            text = text.replace(actualToken, SpellTooltip.formattedRange(range.min(), range.max()));
        }
        return text;
    }

    public static String replaceTokens(String text, String token, List<String> values) {
        boolean indexTokens = values.size() > 1;
        for (int i = 0; i < values.size(); ++i) {
            String actualToken = indexTokens ? SpellTooltip.placeholder(token + "_" + (i + 1)) : SpellTooltip.placeholder(token);
            text = text.replace(actualToken, values.get(i));
        }
        return text;
    }

    public static String percent(float chance) {
        return (int)(chance * 100.0f) + "%";
    }

    public static String bonus(float amount, class_1322.class_1323 operation) {
        switch (operation) {
            case field_6328: {
                return SpellTooltip.formattedNumber(amount);
            }
            case field_6330: {
                return SpellTooltip.percent(amount);
            }
            case field_6331: {
                return SpellTooltip.percent(amount - 1.0f);
            }
        }
        return "";
    }

    public static String formattedRange(double min, double max) {
        if (min == max) {
            return SpellTooltip.formattedNumber((float)min);
        }
        return SpellTooltip.formattedNumber((float)min) + " - " + SpellTooltip.formattedNumber((float)max);
    }

    public static String formattedNumber(float number) {
        DecimalFormat formatter = new DecimalFormat();
        formatter.setMaximumFractionDigits(1);
        return formatter.format((double)number);
    }

    public static String keyWithPlural(String key, float value) {
        if (value != 1.0f) {
            return key + ".plural";
        }
        return key;
    }

    public static String spellTranslationKey(class_2960 spellId) {
        return SpellTooltip.spellKeyPrefix(spellId) + ".name";
    }

    public static String spellKeyPrefix(class_2960 spellId) {
        return "spell." + spellId.method_12836() + "." + spellId.method_12832();
    }

    public static String spellGroup(String group) {
        String key = "spell.group." + group;
        if (class_1074.method_4663((String)key)) {
            return class_1074.method_4662((String)key, (Object[])new Object[0]);
        }
        return "";
    }

    public static void addDescriptionMutator(class_2960 spellId, DescriptionMutator handler) {
        descriptionMutators.put(spellId, handler);
    }

    public static interface DescriptionMutator {
        public String mutate(Args var1);

        public record Args(String description, class_1657 player, class_6880<Spell> spellEntry) {
        }
    }
}

