/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.gui;

import java.util.Locale;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.spell_engine.api.effect.EntityActionsAllowed;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.internals.Ammo;
import net.spell_engine.internals.casting.SpellCast;

public class HudMessages {
    public static final HudMessages INSTANCE = new HudMessages();
    public static final int DEFAULT_ERROR_MESSAGE_DURATION = 20;
    public static final int DEFAULT_ERROR_MESSAGE_FADEOUT = 10;
    private ErrorMessageState currentError;
    private static final String castAttemptPrefix = "hud.cast_attempt_error.";
    private boolean attemptDisplayed = false;

    public void castAttemptError(SpellCast.Attempt attempt) {
        if (this.attemptDisplayed) {
            return;
        }
        if (attempt.isSuccess() || attempt.isFail()) {
            this.attemptDisplayed = true;
        }
        if (!attempt.isFail() || !SpellEngineClient.config.showSpellCastErrors) {
            return;
        }
        String translationKey = castAttemptPrefix + attempt.result().toString().toLowerCase(Locale.ENGLISH);
        class_5250 message = null;
        switch (attempt.result()) {
            case MISSING_ITEM: {
                Ammo.Searched item = attempt.missingItem().item();
                if (item == null) break;
                String itemName = class_1074.method_4662((String)item.getTranslationKey(), (Object[])new Object[0]);
                message = class_2561.method_43469((String)translationKey, (Object[])new Object[]{itemName});
                break;
            }
            case ON_COOLDOWN: {
                message = class_2561.method_43471((String)translationKey);
            }
        }
        if (message != null) {
            this.error((class_2561)message.method_27692(class_124.field_1061));
        }
    }

    public void actionImpaired(EntityActionsAllowed.SemanticType reason) {
        this.error(class_1074.method_4662((String)("hud.action_impaired." + reason.toString().toLowerCase(Locale.ENGLISH)), (Object[])new Object[0]));
    }

    public void error(String message) {
        this.error(message, 20, 10);
    }

    public void error(String message, int duration, int fadeOut) {
        this.currentError = new ErrorMessageState(message, duration, fadeOut);
    }

    public void error(class_2561 text) {
        this.error(text, 20, 10);
    }

    public void error(class_2561 text, int duration, int fadeOut) {
        this.currentError = new ErrorMessageState(text, duration, fadeOut);
    }

    public void tick() {
        if (this.currentError != null) {
            if (this.currentError.durationLeft <= 0) {
                this.currentError = null;
            } else {
                --this.currentError.durationLeft;
            }
        }
        class_310 client = class_310.method_1551();
        if (!client.field_1690.field_1904.method_1434()) {
            this.attemptDisplayed = false;
        }
    }

    public ErrorMessageState currentError() {
        return this.currentError;
    }

    public static class ErrorMessageState {
        public class_2561 message;
        public int durationLeft;
        public int fadeOut;

        public ErrorMessageState(String message, int durationLeft, int fadeOut) {
            this.message = class_2561.method_43470((String)message).method_27692(class_124.field_1061);
            this.durationLeft = durationLeft;
            this.fadeOut = fadeOut;
        }

        public ErrorMessageState(class_2561 message, int durationLeft, int fadeOut) {
            this.message = message;
            this.durationLeft = durationLeft;
            this.fadeOut = fadeOut;
        }
    }
}

