/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.render;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.spell_engine.api.effect.CustomParticleStatusEffect;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.client.util.Color;
import net.spell_engine.fx.ParticleHelper;
import org.jetbrains.annotations.Nullable;

public class BuffParticleSpawner
implements CustomParticleStatusEffect.Spawner {
    private final ParticleBatch[] particles;
    @Nullable
    private ParticleBatch groundEffect;
    private int groundFrequency = 0;

    private static ParticleBatch defaultBatch(String particleId, float particleCount, float min_speed, float max_speed) {
        return new ParticleBatch(particleId, ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, null, particleCount, min_speed, max_speed, 0.0f, -0.2f);
    }

    public BuffParticleSpawner(List<String> particleIds, float particleCount, float min_speed, float max_speed) {
        this.particles = new ParticleBatch[particleIds.size()];
        for (int i = 0; i < particleIds.size(); ++i) {
            this.particles[i] = BuffParticleSpawner.defaultBatch(particleIds.get(i), particleCount, min_speed, max_speed);
        }
    }

    public BuffParticleSpawner(String particleId, float particleCount, float min_speed, float max_speed) {
        this.particles = new ParticleBatch[]{BuffParticleSpawner.defaultBatch(particleId, particleCount, min_speed, max_speed)};
    }

    public BuffParticleSpawner(String particleId, float particleCount) {
        this(particleId, particleCount, 0.11f, 0.12f);
    }

    public BuffParticleSpawner(ParticleBatch[] particles) {
        this.particles = particles;
    }

    public BuffParticleSpawner withGroundEffect(String particleId, Color color, int frequency) {
        this.groundFrequency = frequency;
        this.groundEffect = new ParticleBatch(particleId.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.GROUND, 1.0f, 0.0f, 0.0f).color(color.toRGBA()).followEntity(true);
        return this;
    }

    @Override
    public void spawnParticles(class_1309 livingEntity, int amplifier) {
        ParticleBatch[] scaledParticles = new ParticleBatch[this.particles.length];
        for (int i = 0; i < this.particles.length; ++i) {
            ParticleBatch copiedBatch = new ParticleBatch(this.particles[i]);
            copiedBatch.count *= (float)(amplifier + 1);
            scaledParticles[i] = copiedBatch;
        }
        ParticleHelper.play(livingEntity.method_37908(), (class_1297)livingEntity, scaledParticles);
        if (this.groundEffect != null && this.groundFrequency > 0 && livingEntity.field_6012 % this.groundFrequency == 0) {
            ParticleHelper.play(livingEntity.method_37908(), (class_1297)livingEntity, this.groundEffect);
        }
    }
}

