/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.ref.constraint;

import com.bawnorton.configurable.ref.constraint.ClampedReferenceConstraint;
import com.bawnorton.configurable.ref.constraint.PredicateReferenceConstraint;
import com.bawnorton.configurable.ref.constraint.ReferenceConstraint;
import com.bawnorton.configurable.ref.constraint.RegexReferenceConstraint;
import com.bawnorton.configurable.util.Pair;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public class ConstraintSet {
    private final Set<ReferenceConstraint> constraints;

    private ConstraintSet(Set<ReferenceConstraint> constraints) {
        this.constraints = constraints;
    }

    public Object apply(Object value) {
        Object pre = value;
        for (ReferenceConstraint constraint : this.constraints) {
            value = constraint.apply(value);
            if (value == pre || value == ReferenceConstraint.DEFAULT) continue;
            throw new IllegalStateException("Constraint \"%s#apply\" did not return \"value\" or \"DEFAULT\"".formatted(constraint.getClass().getSimpleName()));
        }
        return value;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<Pair<Double, Double>> clamps = new HashSet<Pair<Double, Double>>();
        private final Set<Predicate<Object>> predicates = new HashSet<Predicate<Object>>();
        private final Set<String> regexes = new HashSet<String>();

        public Builder addClamped(Double min, Double max) {
            this.clamps.add(Pair.of(min, max));
            return this;
        }

        public Builder addPredicate(Predicate<Object> predicate) {
            this.predicates.add(predicate);
            return this;
        }

        public Builder addRegex(String regex) {
            this.regexes.add(regex);
            return this;
        }

        public ConstraintSet build(Class<?> refHolder, Class<?> refType) {
            HashSet<ReferenceConstraint> constraints = new HashSet<ReferenceConstraint>();
            this.clamps.forEach(clamp -> constraints.add(new ClampedReferenceConstraint((Double)clamp.a(), (Double)clamp.b(), refHolder, refType)));
            this.predicates.forEach(predicate -> constraints.add(new PredicateReferenceConstraint((Predicate<Object>)predicate, refHolder, refType)));
            this.regexes.forEach(regex -> constraints.add(new RegexReferenceConstraint((String)regex, refHolder, refType)));
            return new ConstraintSet(constraints);
        }
    }
}

